/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.rop.cst;

import com.android.jack.dx.dex.file.ValueEncoder;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstMemberRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.type.Type;
import javax.annotation.Nonnull;

public final class CstFieldRef
extends CstMemberRef {
    @Nonnull
    private final Type type;

    public CstFieldRef(@Nonnull Type definingClass, @Nonnull CstString name, @Nonnull Type type) {
        super(definingClass, name);
        this.type = type;
    }

    @Override
    @Nonnull
    public String typeName() {
        return "field";
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Override
    protected int compareTo0(Constant other) {
        int cmp = super.compareTo0(other);
        if (cmp != 0) {
            return cmp;
        }
        CstFieldRef otherField = (CstFieldRef)other;
        return this.type.compareTo(otherField.type);
    }

    @Override
    @Nonnull
    public ValueEncoder.ValueType getEncodedValueType() {
        return ValueEncoder.ValueType.VALUE_FIELD;
    }

    public final boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CstFieldRef otherRef = (CstFieldRef)other;
        return this.getDefiningClass().equals(otherRef.getDefiningClass()) && this.getName().equals(otherRef.getName()) && this.type.equals(otherRef.type);
    }

    public final int hashCode() {
        return this.getDefiningClass().hashCode() * 31 + this.getName().hashCode() * 31 + this.getType().hashCode();
    }

    @Override
    @Nonnull
    public final String toHuman() {
        return this.getDefiningClass().toHuman() + '.' + this.getName().toHuman() + ':' + this.type.toHuman();
    }
}

