/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.rop.annotation;

import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstString;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class NameValuePair
implements Comparable<NameValuePair> {
    @Nonnull
    private final CstString name;
    @Nonnull
    private final Constant value;

    public NameValuePair(@Nonnull CstString name, @Nonnull Constant value) {
        assert (name != null);
        assert (value != null);
        this.name = name;
        this.value = value;
    }

    @Nonnull
    public String toString() {
        return this.name.toHuman() + ":" + this.value;
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.value.hashCode();
    }

    public boolean equals(@CheckForNull Object other) {
        if (!(other instanceof NameValuePair)) {
            return false;
        }
        NameValuePair otherPair = (NameValuePair)other;
        return this.name.equals(otherPair.name) && this.value.equals(otherPair.value);
    }

    @Override
    public int compareTo(@Nonnull NameValuePair other) {
        int result = this.name.compareTo(other.name);
        if (result != 0) {
            return result;
        }
        return this.value.compareTo(other.value);
    }

    @Nonnull
    public CstString getName() {
        return this.name;
    }

    @Nonnull
    public Constant getValue() {
        return this.value;
    }
}

