/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.io.instructions;

import com.android.jack.dx.io.IndexType;
import com.android.jack.dx.io.OpcodeInfo;
import com.android.jack.dx.io.Opcodes;
import com.android.jack.dx.io.instructions.CodeInput;
import com.android.jack.dx.io.instructions.CodeOutput;
import com.android.jack.dx.io.instructions.InstructionCodec;
import com.android.jack.dx.io.instructions.ShortArrayCodeInput;
import com.android.jack.dx.util.DexException;
import com.android.jack.dx.util.Hex;
import java.io.EOFException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class DecodedInstruction {
    @Nonnull
    private final InstructionCodec format;
    @Nonnegative
    private final int opcode;
    private final int firstIndex;
    @Nonnull
    private final IndexType firstIndexType;
    private final int secondIndex;
    @Nonnull
    private final IndexType secondIndexType;
    @Nonnegative
    private final int target;
    private final long literal;

    @Nonnull
    public static DecodedInstruction decode(@Nonnull CodeInput in) throws EOFException {
        int opcodeUnit = in.read();
        int opcode = Opcodes.extractOpcodeFromUnit(opcodeUnit);
        InstructionCodec format = OpcodeInfo.getFormat(opcode);
        return format.decode(opcodeUnit, in);
    }

    @Nonnull
    public static DecodedInstruction[] decodeAll(@Nonnull short[] encodedInstructions) {
        int size = encodedInstructions.length;
        DecodedInstruction[] decoded = new DecodedInstruction[size];
        ShortArrayCodeInput in = new ShortArrayCodeInput(encodedInstructions);
        try {
            while (in.hasMore()) {
                decoded[in.cursor()] = DecodedInstruction.decode(in);
            }
        }
        catch (EOFException ex) {
            throw new DexException(ex);
        }
        return decoded;
    }

    public DecodedInstruction(@Nonnull InstructionCodec format, @Nonnegative int opcode, int firstIndex, @Nonnull IndexType firstIndexType, @Nonnegative int target, long literal) {
        this(format, opcode, firstIndex, firstIndexType, target, literal, 0, IndexType.NONE);
    }

    public DecodedInstruction(@Nonnull InstructionCodec format, @Nonnegative int opcode, @Nonnegative int firstIndex, @Nonnull IndexType firstIndexType, @Nonnegative int target, long literal, @Nonnegative int secondIndex, @Nonnull IndexType secondIndexType) {
        assert (format != null);
        assert (Opcodes.isValidShape(opcode));
        this.format = format;
        this.opcode = opcode;
        this.firstIndex = firstIndex;
        this.firstIndexType = firstIndexType;
        this.target = target;
        this.literal = literal;
        this.secondIndex = secondIndex;
        this.secondIndexType = secondIndexType;
    }

    @Nonnull
    public final InstructionCodec getFormat() {
        return this.format;
    }

    @Nonnegative
    public final int getOpcode() {
        return this.opcode;
    }

    @Nonnegative
    public final short getOpcodeUnit() {
        return (short)this.opcode;
    }

    public final int getFirstIndex() {
        assert (this.firstIndexType != IndexType.NONE);
        return this.firstIndex;
    }

    public final int getSecondIndex() {
        assert (this.secondIndexType != IndexType.NONE);
        return this.secondIndex;
    }

    public final short getFirstIndexUnit() {
        assert (this.firstIndexType != IndexType.NONE);
        return (short)this.firstIndex;
    }

    public final short getSecondIndexUnit() {
        assert (this.secondIndexType != IndexType.NONE);
        return (short)this.secondIndex;
    }

    @Nonnull
    public final IndexType getFirstIndexType() {
        return this.firstIndexType;
    }

    @Nonnull
    public final IndexType getSecondIndexType() {
        return this.secondIndexType;
    }

    @Nonnegative
    public final int getTarget() {
        return this.target;
    }

    public final int getTarget(int baseAddress) {
        return this.target - baseAddress;
    }

    public final short getTargetUnit(int baseAddress) {
        int relativeTarget = this.getTarget(baseAddress);
        if (relativeTarget != (short)relativeTarget) {
            throw new DexException("Target out of range: " + Hex.s4(relativeTarget));
        }
        return (short)relativeTarget;
    }

    public final int getTargetByte(int baseAddress) {
        int relativeTarget = this.getTarget(baseAddress);
        if (relativeTarget != (byte)relativeTarget) {
            throw new DexException("Target out of range: " + Hex.s4(relativeTarget));
        }
        return relativeTarget & 0xFF;
    }

    public final long getLiteral() {
        return this.literal;
    }

    public final int getLiteralInt() {
        if (this.literal != (long)((int)this.literal)) {
            throw new DexException("Literal out of range: " + Hex.u8(this.literal));
        }
        return (int)this.literal;
    }

    public final short getLiteralUnit() {
        if (this.literal != (long)((short)this.literal)) {
            throw new DexException("Literal out of range: " + Hex.u8(this.literal));
        }
        return (short)this.literal;
    }

    public final int getLiteralByte() {
        if (this.literal != (long)((byte)this.literal)) {
            throw new DexException("Literal out of range: " + Hex.u8(this.literal));
        }
        return (int)this.literal & 0xFF;
    }

    public final int getLiteralNibble() {
        if (this.literal < -8L || this.literal > 7L) {
            throw new DexException("Literal out of range: " + Hex.u8(this.literal));
        }
        return (int)this.literal & 0xF;
    }

    @Nonnegative
    public abstract int getRegisterCount();

    @Nonnegative
    public int getA() {
        return 0;
    }

    @Nonnegative
    public int getB() {
        return 0;
    }

    @Nonnegative
    public int getC() {
        return 0;
    }

    @Nonnegative
    public int getD() {
        return 0;
    }

    @Nonnegative
    public int getE() {
        return 0;
    }

    public final short getAUnit() {
        int a = this.getA();
        if ((a & 0xFFFF0000) != 0) {
            throw new DexException("Register A out of range: " + Hex.u8(a));
        }
        return (short)a;
    }

    public final short getBUnit() {
        int b = this.getB();
        if ((b & 0xFFFF0000) != 0) {
            throw new DexException("Register B out of range: " + Hex.u8(b));
        }
        return (short)b;
    }

    public final void encode(@Nonnull CodeOutput out) {
        this.format.encode(this, out);
    }

    @Nonnull
    public DecodedInstruction withIndex(int newFirstIndex) {
        return this.withIndex(newFirstIndex, 0);
    }

    @Nonnull
    public abstract DecodedInstruction withIndex(int var1, int var2);
}

