/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.io;

import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.rop.cst.CstMethodHandleRef;
import com.android.jack.dx.util.Unsigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class MethodHandleId
implements Comparable<MethodHandleId> {
    @Nonnull
    private final DexBuffer buffer;
    @Nonnull
    private final CstMethodHandleRef.MethodHandleKind kind;
    @Nonnegative
    private final int memberIdx;

    public MethodHandleId(@Nonnull DexBuffer buffer, @Nonnull CstMethodHandleRef.MethodHandleKind kind, @Nonnegative int fieldOrMethodIdx) {
        this.buffer = buffer;
        this.kind = kind;
        this.memberIdx = fieldOrMethodIdx;
    }

    @Nonnull
    public CstMethodHandleRef.MethodHandleKind getKind() {
        return this.kind;
    }

    @Nonnegative
    public int getMemberIndex() {
        return this.memberIdx;
    }

    @Override
    public int compareTo(@Nonnull MethodHandleId other) {
        if (this.kind.getValue() != other.getKind().getValue()) {
            return Unsigned.compare(this.kind.getValue(), other.getKind().getValue());
        }
        return Unsigned.compare(this.memberIdx, other.memberIdx);
    }

    public void writeTo(@Nonnull DexBuffer.Section out) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public final String toString() {
        switch (this.kind) {
            case PUT_INSTANCE: 
            case PUT_STATIC: 
            case GET_INSTANCE: 
            case GET_STATIC: {
                return this.kind.getValue() + "." + this.buffer.fieldIds().get(this.memberIdx);
            }
            case INVOKE_CONSTRUCTOR: 
            case INVOKE_INSTANCE: 
            case INVOKE_STATIC: {
                return this.kind.getValue() + "." + this.buffer.methodIds().get(this.memberIdx);
            }
        }
        throw new AssertionError();
    }
}

