/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.io;

import com.android.jack.dx.dex.file.ValueEncoder;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.util.ByteInput;
import com.android.jack.dx.util.Leb128Utils;
import javax.annotation.Nonnull;

public class EncodedValueReader {
    @Nonnull
    protected final ByteInput in;
    @Nonnull
    protected DexBuffer dexBuffer;

    public EncodedValueReader(@Nonnull DexBuffer dexBuffer, @Nonnull ByteInput in) {
        this.in = in;
        this.dexBuffer = dexBuffer;
    }

    public void readArray() {
        int size = Leb128Utils.readUnsignedLeb128(this.in);
        this.visitArray(size);
        for (int i = 0; i < size; ++i) {
            this.readValue();
        }
    }

    public void readAnnotation() {
        int typeIndex = Leb128Utils.readUnsignedLeb128(this.in);
        int size = Leb128Utils.readUnsignedLeb128(this.in);
        this.visitAnnotation(typeIndex, size);
        for (int i = 0; i < size; ++i) {
            this.visitAnnotationName(Leb128Utils.readUnsignedLeb128(this.in));
            this.readValue();
        }
    }

    public final void readValue() {
        int argAndType = this.in.readByte() & 0xFF;
        int type = argAndType & 0x1F;
        int arg = (argAndType & 0xE0) >> 5;
        int size = arg + 1;
        switch (ValueEncoder.ValueType.getValueType(type)) {
            case VALUE_BYTE: 
            case VALUE_SHORT: 
            case VALUE_CHAR: 
            case VALUE_INT: 
            case VALUE_LONG: 
            case VALUE_FLOAT: 
            case VALUE_DOUBLE: {
                this.visitPrimitive(type, arg, size);
                break;
            }
            case VALUE_STRING: {
                this.visitString(this.readIndex(this.in, size));
                break;
            }
            case VALUE_TYPE: {
                this.visitType(this.readIndex(this.in, size));
                break;
            }
            case VALUE_FIELD: 
            case VALUE_ENUM: {
                this.visitField(type, this.readIndex(this.in, size));
                break;
            }
            case VALUE_METHOD: {
                this.visitMethod(this.readIndex(this.in, size));
                break;
            }
            case VALUE_ARRAY: {
                this.visitArrayValue(argAndType);
                this.readArray();
                break;
            }
            case VALUE_ANNOTATION: {
                this.visitAnnotationValue(argAndType);
                this.readAnnotation();
                break;
            }
            case VALUE_NULL: {
                this.visitEncodedNull(argAndType);
                break;
            }
            case VALUE_BOOLEAN: {
                this.visitEncodedBoolean(argAndType);
                break;
            }
            case VALUE_METHOD_TYPE: {
                assert (this.dexBuffer.getTableOfContents().dexVersion == 38);
                this.visitMethodType(this.readIndex(this.in, size));
                break;
            }
            case VALUE_METHOD_HANDLE: {
                assert (this.dexBuffer.getTableOfContents().dexVersion == 38);
                this.visitMethodHandle(this.readIndex(this.in, size));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    protected void visitArray(int size) {
    }

    protected void visitAnnotation(int typeIndex, int size) {
    }

    protected void visitAnnotationName(int nameIndex) {
    }

    protected void visitPrimitive(int type, int arg, int size) {
        for (int i = 0; i < size; ++i) {
            this.in.readByte();
        }
    }

    protected void visitString(int index) {
    }

    protected void visitType(int index) {
    }

    protected void visitField(int type, int index) {
    }

    protected void visitMethod(int index) {
    }

    protected void visitArrayValue(int argAndType) {
    }

    protected void visitAnnotationValue(int argAndType) {
    }

    protected void visitEncodedBoolean(int argAndType) {
    }

    protected void visitEncodedNull(int argAndType) {
    }

    protected void visitMethodType(int index) {
    }

    protected void visitMethodHandle(int index) {
    }

    private int readIndex(@Nonnull ByteInput in, int byteCount) {
        int result = 0;
        int shift = 0;
        for (int i = 0; i < byteCount; ++i) {
            result += (in.readByte() & 0xFF) << shift;
            shift += 8;
        }
        return result;
    }
}

