/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.file;

import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.dex.file.StringIdsSection;
import com.android.jack.dx.dex.file.TypeIdsSection;
import com.android.jack.dx.rop.annotation.Annotation;
import com.android.jack.dx.rop.annotation.NameValuePair;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstAnnotation;
import com.android.jack.dx.rop.cst.CstArray;
import com.android.jack.dx.rop.cst.CstBoolean;
import com.android.jack.dx.rop.cst.CstDouble;
import com.android.jack.dx.rop.cst.CstEnumRef;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.dx.rop.cst.CstFloat;
import com.android.jack.dx.rop.cst.CstLiteralBits;
import com.android.jack.dx.rop.cst.CstMethodHandleRef;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstPrototypeRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.type.Type;
import com.android.jack.dx.util.AnnotatedOutput;
import com.android.jack.dx.util.Hex;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ValueEncoder {
    private final DexFile file;
    private final AnnotatedOutput out;

    public ValueEncoder(DexFile file, AnnotatedOutput out) {
        assert (file != null);
        assert (out != null);
        this.file = file;
        this.out = out;
    }

    public void writeConstant(Constant cst) {
        ValueType encodedValueType = cst.getEncodedValueType();
        int type = encodedValueType.getValue();
        switch (encodedValueType) {
            case VALUE_BYTE: 
            case VALUE_SHORT: 
            case VALUE_INT: 
            case VALUE_LONG: {
                long value = ((CstLiteralBits)cst).getLongBits();
                this.writeSignedIntegralValue(type, value);
                break;
            }
            case VALUE_CHAR: {
                long value = ((CstLiteralBits)cst).getLongBits();
                this.writeUnsignedIntegralValue(type, value);
                break;
            }
            case VALUE_FLOAT: {
                long value = ((CstFloat)cst).getLongBits() << 32;
                this.writeRightZeroExtendedValue(type, value);
                break;
            }
            case VALUE_DOUBLE: {
                long value = ((CstDouble)cst).getLongBits();
                this.writeRightZeroExtendedValue(type, value);
                break;
            }
            case VALUE_STRING: {
                int index = this.file.getStringIds().indexOf((CstString)cst);
                this.writeUnsignedIntegralValue(type, index);
                break;
            }
            case VALUE_TYPE: {
                int index = this.file.getTypeIds().indexOf((Type)cst);
                this.writeUnsignedIntegralValue(type, index);
                break;
            }
            case VALUE_FIELD: {
                int index = this.file.getFieldIds().indexOf((CstFieldRef)cst);
                this.writeUnsignedIntegralValue(type, index);
                break;
            }
            case VALUE_METHOD: {
                int index = this.file.getMethodIds().indexOf((CstMethodRef)cst);
                this.writeUnsignedIntegralValue(type, index);
                break;
            }
            case VALUE_ENUM: {
                CstFieldRef fieldRef = ((CstEnumRef)cst).getFieldRef();
                int index = this.file.getFieldIds().indexOf(fieldRef);
                this.writeUnsignedIntegralValue(type, index);
                break;
            }
            case VALUE_ARRAY: {
                this.out.writeByte(type);
                this.writeArray((CstArray)cst, false);
                break;
            }
            case VALUE_ANNOTATION: {
                this.out.writeByte(type);
                this.writeAnnotation(((CstAnnotation)cst).getAnnotation(), false);
                break;
            }
            case VALUE_NULL: {
                this.out.writeByte(type);
                break;
            }
            case VALUE_BOOLEAN: {
                int value = ((CstBoolean)cst).getIntBits();
                this.out.writeByte(type | value << 5);
                break;
            }
            case VALUE_METHOD_TYPE: {
                assert (this.file.getDexOptions().getDexVersion() == 38);
                int index = this.file.getProtoIds().indexOf(((CstPrototypeRef)cst).getPrototype());
                this.writeUnsignedIntegralValue(type, index);
                break;
            }
            case VALUE_METHOD_HANDLE: {
                assert (this.file.getDexOptions().getDexVersion() == 38);
                int index = this.file.getMethodHandleIds().indexOf((CstMethodHandleRef)cst);
                this.writeUnsignedIntegralValue(type, index);
                break;
            }
            default: {
                throw new RuntimeException("Shouldn't happen");
            }
        }
    }

    public void writeArray(CstArray array, boolean topLevel) {
        boolean annotates = topLevel && this.out.annotates();
        CstArray.List list = array.getList();
        int size = list.size();
        if (annotates) {
            this.out.annotate("  size: " + Hex.u4(size));
        }
        this.out.writeUleb128(size);
        for (int i = 0; i < size; ++i) {
            Constant cst = list.get(i);
            if (annotates) {
                this.out.annotate("  [" + Integer.toHexString(i) + "] " + ValueEncoder.constantToHuman(cst));
            }
            this.writeConstant(cst);
        }
        if (annotates) {
            this.out.endAnnotation();
        }
    }

    public void writeAnnotation(Annotation annotation, boolean topLevel) {
        boolean annotates = topLevel && this.out.annotates();
        StringIdsSection stringIds = this.file.getStringIds();
        TypeIdsSection typeIds = this.file.getTypeIds();
        Type type = annotation.getType();
        int typeIdx = typeIds.indexOf(type);
        if (annotates) {
            this.out.annotate("  type_idx: " + Hex.u4(typeIdx) + " // " + type.toHuman());
        }
        this.out.writeUleb128(typeIds.indexOf(annotation.getType()));
        Collection<NameValuePair> pairs = annotation.getNameValuePairs();
        int size = pairs.size();
        if (annotates) {
            this.out.annotate("  size: " + Hex.u4(size));
        }
        this.out.writeUleb128(size);
        int at = 0;
        for (NameValuePair pair : pairs) {
            CstString name = pair.getName();
            int nameIdx = stringIds.indexOf(name);
            Constant value = pair.getValue();
            if (annotates) {
                this.out.annotate(0, "  elements[" + at + "]:");
                ++at;
                this.out.annotate("    name_idx: " + Hex.u4(nameIdx) + " // " + name.toHuman());
            }
            this.out.writeUleb128(nameIdx);
            if (annotates) {
                this.out.annotate("    value: " + ValueEncoder.constantToHuman(value));
            }
            this.writeConstant(value);
        }
        if (annotates) {
            this.out.endAnnotation();
        }
    }

    public static String constantToHuman(Constant cst) {
        if (cst.getEncodedValueType() == ValueType.VALUE_NULL) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(cst.typeName());
        sb.append(' ');
        sb.append(cst.toHuman());
        return sb.toString();
    }

    private void writeSignedIntegralValue(int type, long value) {
        int requiredBytes;
        int requiredBits = 65 - Long.numberOfLeadingZeros(value ^ value >> 63);
        this.out.writeByte(type | requiredBytes - 1 << 5);
        for (requiredBytes = requiredBits + 7 >> 3; requiredBytes > 0; --requiredBytes) {
            this.out.writeByte((byte)value);
            value >>= 8;
        }
    }

    private void writeUnsignedIntegralValue(int type, long value) {
        int requiredBytes;
        int requiredBits = 64 - Long.numberOfLeadingZeros(value);
        if (requiredBits == 0) {
            requiredBits = 1;
        }
        this.out.writeByte(type | requiredBytes - 1 << 5);
        for (requiredBytes = requiredBits + 7 >> 3; requiredBytes > 0; --requiredBytes) {
            this.out.writeByte((byte)value);
            value >>= 8;
        }
    }

    private void writeRightZeroExtendedValue(int type, long value) {
        int requiredBytes;
        int requiredBits = 64 - Long.numberOfTrailingZeros(value);
        if (requiredBits == 0) {
            requiredBits = 1;
        }
        value >>= 64 - requiredBytes * 8;
        this.out.writeByte(type | requiredBytes - 1 << 5);
        for (requiredBytes = requiredBits + 7 >> 3; requiredBytes > 0; --requiredBytes) {
            this.out.writeByte((byte)value);
            value >>= 8;
        }
    }

    public static void addContents(DexFile file, Annotation annotation) {
        TypeIdsSection typeIds = file.getTypeIds();
        StringIdsSection stringIds = file.getStringIds();
        typeIds.intern(annotation.getType());
        for (NameValuePair pair : annotation.getNameValuePairs()) {
            stringIds.intern(pair.getName());
            ValueEncoder.addContents(file, pair.getValue());
        }
    }

    public static void addContents(DexFile file, Constant cst) {
        if (cst instanceof CstAnnotation) {
            ValueEncoder.addContents(file, ((CstAnnotation)cst).getAnnotation());
        } else if (cst instanceof CstArray) {
            CstArray.List list = ((CstArray)cst).getList();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                ValueEncoder.addContents(file, list.get(i));
            }
        } else {
            file.internIfAppropriate(cst);
        }
    }

    public static final class ValueType
    extends Enum<ValueType> {
        public static final /* enum */ ValueType VALUE_BYTE = new ValueType(0);
        public static final /* enum */ ValueType VALUE_SHORT = new ValueType(2);
        public static final /* enum */ ValueType VALUE_CHAR = new ValueType(3);
        public static final /* enum */ ValueType VALUE_INT = new ValueType(4);
        public static final /* enum */ ValueType VALUE_LONG = new ValueType(6);
        public static final /* enum */ ValueType VALUE_FLOAT = new ValueType(16);
        public static final /* enum */ ValueType VALUE_DOUBLE = new ValueType(17);
        public static final /* enum */ ValueType VALUE_METHOD_TYPE = new ValueType(21);
        public static final /* enum */ ValueType VALUE_METHOD_HANDLE = new ValueType(22);
        public static final /* enum */ ValueType VALUE_STRING = new ValueType(23);
        public static final /* enum */ ValueType VALUE_TYPE = new ValueType(24);
        public static final /* enum */ ValueType VALUE_FIELD = new ValueType(25);
        public static final /* enum */ ValueType VALUE_METHOD = new ValueType(26);
        public static final /* enum */ ValueType VALUE_ENUM = new ValueType(27);
        public static final /* enum */ ValueType VALUE_ARRAY = new ValueType(28);
        public static final /* enum */ ValueType VALUE_ANNOTATION = new ValueType(29);
        public static final /* enum */ ValueType VALUE_NULL = new ValueType(30);
        public static final /* enum */ ValueType VALUE_BOOLEAN = new ValueType(31);
        @Nonnegative
        private int value;
        private static final /* synthetic */ ValueType[] $VALUES;

        public static ValueType[] values() {
            return (ValueType[])$VALUES.clone();
        }

        public static ValueType valueOf(String name) {
            return Enum.valueOf(ValueType.class, name);
        }

        private ValueType(int value) {
            this.value = value;
        }

        @Nonnegative
        public int getValue() {
            return this.value;
        }

        @Nonnull
        public static ValueType getValueType(@Nonnegative int value) {
            ValueType valueType;
            switch (value) {
                case 0: {
                    valueType = VALUE_BYTE;
                    break;
                }
                case 2: {
                    valueType = VALUE_SHORT;
                    break;
                }
                case 3: {
                    valueType = VALUE_CHAR;
                    break;
                }
                case 4: {
                    valueType = VALUE_INT;
                    break;
                }
                case 6: {
                    valueType = VALUE_LONG;
                    break;
                }
                case 16: {
                    valueType = VALUE_FLOAT;
                    break;
                }
                case 17: {
                    valueType = VALUE_DOUBLE;
                    break;
                }
                case 21: {
                    valueType = VALUE_METHOD_TYPE;
                    break;
                }
                case 22: {
                    valueType = VALUE_METHOD_HANDLE;
                    break;
                }
                case 23: {
                    valueType = VALUE_STRING;
                    break;
                }
                case 24: {
                    valueType = VALUE_TYPE;
                    break;
                }
                case 25: {
                    valueType = VALUE_FIELD;
                    break;
                }
                case 27: {
                    valueType = VALUE_ENUM;
                    break;
                }
                case 26: {
                    valueType = VALUE_METHOD;
                    break;
                }
                case 28: {
                    valueType = VALUE_ARRAY;
                    break;
                }
                case 29: {
                    valueType = VALUE_ANNOTATION;
                    break;
                }
                case 30: {
                    valueType = VALUE_NULL;
                    break;
                }
                case 31: {
                    valueType = VALUE_BOOLEAN;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            assert (valueType.getValue() == value);
            return valueType;
        }

        static {
            $VALUES = new ValueType[]{VALUE_BYTE, VALUE_SHORT, VALUE_CHAR, VALUE_INT, VALUE_LONG, VALUE_FLOAT, VALUE_DOUBLE, VALUE_METHOD_TYPE, VALUE_METHOD_HANDLE, VALUE_STRING, VALUE_TYPE, VALUE_FIELD, VALUE_METHOD, VALUE_ENUM, VALUE_ARRAY, VALUE_ANNOTATION, VALUE_NULL, VALUE_BOOLEAN};
        }
    }
}

