/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.file;

import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.dex.file.ItemType;
import com.android.jack.dx.dex.file.OffsettedItem;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.util.AnnotatedOutput;
import com.android.jack.dx.util.ByteArray;
import com.android.jack.dx.util.Hex;
import com.android.jack.dx.util.Leb128Utils;

public final class StringDataItem
extends OffsettedItem {
    private final CstString value;

    public StringDataItem(CstString value) {
        super(1, StringDataItem.writeSize(value));
        this.value = value;
    }

    private static int writeSize(CstString value) {
        int utf16Size = value.getUtf16Size();
        return Leb128Utils.unsignedLeb128Size(utf16Size) + value.getUtf8Size() + 1;
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_STRING_DATA_ITEM;
    }

    @Override
    public void addContents(DexFile file) {
    }

    @Override
    public void writeTo0(DexFile file, AnnotatedOutput out) {
        ByteArray bytes = this.value.getBytes();
        int utf16Size = this.value.getUtf16Size();
        if (out.annotates()) {
            out.annotate(Leb128Utils.unsignedLeb128Size(utf16Size), "utf16_size: " + Hex.u4(utf16Size));
            out.annotate(bytes.size() + 1, this.value.toQuoted());
        }
        out.writeUleb128(utf16Size);
        out.write(bytes);
        out.writeByte(0);
    }

    @Override
    public String toHuman() {
        return this.value.toQuoted();
    }

    @Override
    protected int compareTo0(OffsettedItem other) {
        StringDataItem otherData = (StringDataItem)other;
        return this.value.compareTo(otherData.value);
    }
}

