/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.file;

import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.dex.file.IndexedItem;
import com.android.jack.dx.dex.file.Item;
import com.android.jack.dx.dex.file.ProtoIdItem;
import com.android.jack.dx.dex.file.UniformItemSection;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstPrototypeRef;
import com.android.jack.dx.rop.type.Prototype;
import com.android.jack.dx.util.AnnotatedOutput;
import com.android.jack.dx.util.Hex;
import java.util.Collection;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public final class ProtoIdsSection
extends UniformItemSection {
    private final TreeMap<Prototype, ProtoIdItem> protoIds = new TreeMap();

    public ProtoIdsSection(DexFile file) {
        super("proto_ids", file, 4);
    }

    @Override
    public Collection<? extends Item> items() {
        return this.protoIds.values();
    }

    @Override
    @Nonnull
    public IndexedItem get(@Nonnull Constant cst) {
        this.throwIfNotPrepared();
        IndexedItem result = this.protoIds.get(((CstPrototypeRef)cst).getPrototype());
        assert (result != null);
        return result;
    }

    public void writeHeaderPart(AnnotatedOutput out) {
        int offset;
        this.throwIfNotPrepared();
        int sz = this.protoIds.size();
        int n = offset = sz == 0 ? 0 : this.getFileOffset();
        if (sz > 65536) {
            throw new UnsupportedOperationException("too many proto ids");
        }
        if (out.annotates()) {
            out.annotate(4, "proto_ids_size:  " + Hex.u4(sz));
            out.annotate(4, "proto_ids_off:   " + Hex.u4(offset));
        }
        out.writeInt(sz);
        out.writeInt(offset);
    }

    public ProtoIdItem intern(Prototype prototype) {
        assert (prototype != null);
        this.throwIfPrepared();
        ProtoIdItem result = this.protoIds.get(prototype);
        if (result == null) {
            result = new ProtoIdItem(prototype);
            this.protoIds.put(prototype, result);
        }
        return result;
    }

    public int indexOf(Prototype prototype) {
        assert (prototype != null);
        this.throwIfNotPrepared();
        ProtoIdItem item = this.protoIds.get(prototype);
        if (item == null) {
            throw new IllegalArgumentException("not found");
        }
        return item.getIndex();
    }

    @Override
    protected void orderItems() {
        int idx = 0;
        for (Item item : this.items()) {
            ((ProtoIdItem)item).setIndex(idx);
            ++idx;
        }
    }
}

