/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.file;

import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.dex.file.IndexedItem;
import com.android.jack.dx.dex.file.Item;
import com.android.jack.dx.dex.file.MethodHandleIdItem;
import com.android.jack.dx.dex.file.UniformItemSection;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstMethodHandleRef;
import java.util.Collection;
import java.util.TreeMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class MethodHandleIdsSection
extends UniformItemSection {
    @Nonnegative
    private static final int ALIGNMENT = 4;
    @Nonnull
    private final TreeMap<CstMethodHandleRef, MethodHandleIdItem> methodHandleIds = new TreeMap();

    public MethodHandleIdsSection(@Nonnull DexFile file) {
        super("method_handle_ids", file, 4);
    }

    @Override
    @Nonnull
    public Collection<? extends Item> items() {
        return this.methodHandleIds.values();
    }

    @Override
    @Nonnull
    public IndexedItem get(@Nonnull Constant cst) {
        this.throwIfNotPrepared();
        IndexedItem result = this.methodHandleIds.get(cst);
        assert (result != null);
        return result;
    }

    @Nonnull
    public MethodHandleIdItem intern(@Nonnull CstMethodHandleRef cstMethodHandleRef) {
        assert (cstMethodHandleRef != null);
        this.throwIfPrepared();
        MethodHandleIdItem result = this.methodHandleIds.get(cstMethodHandleRef);
        if (result == null) {
            result = new MethodHandleIdItem(cstMethodHandleRef);
            this.methodHandleIds.put(cstMethodHandleRef, result);
        }
        return result;
    }

    @Nonnegative
    public int indexOf(@Nonnull CstMethodHandleRef methodHandleRef) {
        assert (methodHandleRef != null);
        this.throwIfNotPrepared();
        MethodHandleIdItem item = this.methodHandleIds.get(methodHandleRef);
        assert (item != null);
        return item.getIndex();
    }

    @Override
    protected void orderItems() {
        int idx = 0;
        for (Item item : this.items()) {
            ((MethodHandleIdItem)item).setIndex(idx);
            ++idx;
        }
    }
}

