/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.code;

import com.android.jack.dx.dex.code.CodeAddress;
import com.android.jack.dx.dex.code.DalvInsn;
import com.android.jack.dx.dex.code.VariableSizeInsn;
import com.android.jack.dx.rop.code.RegisterSpecList;
import com.android.jack.dx.rop.code.SourcePosition;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstLiteral32;
import com.android.jack.dx.rop.cst.CstLiteral64;
import com.android.jack.dx.rop.type.Type;
import com.android.jack.dx.util.AnnotatedOutput;
import com.android.jack.dx.util.Hex;
import java.util.ArrayList;

public final class ArrayData
extends VariableSizeInsn {
    private final CodeAddress user;
    private final ArrayList<Constant> values;
    private final Constant arrayType;
    private final int elemWidth;
    private final int initLength;

    public ArrayData(SourcePosition position, CodeAddress user, ArrayList<Constant> values, Constant arrayType) {
        super(position, RegisterSpecList.EMPTY);
        assert (user != null);
        assert (values != null);
        int sz = values.size();
        if (sz <= 0) {
            throw new IllegalArgumentException("Illegal number of init values");
        }
        this.arrayType = arrayType;
        if (arrayType == Type.BYTE_ARRAY || arrayType == Type.BOOLEAN_ARRAY) {
            this.elemWidth = 1;
        } else if (arrayType == Type.SHORT_ARRAY || arrayType == Type.CHAR_ARRAY) {
            this.elemWidth = 2;
        } else if (arrayType == Type.INT_ARRAY || arrayType == Type.FLOAT_ARRAY) {
            this.elemWidth = 4;
        } else if (arrayType == Type.LONG_ARRAY || arrayType == Type.DOUBLE_ARRAY) {
            this.elemWidth = 8;
        } else {
            throw new IllegalArgumentException("Unexpected constant type");
        }
        this.user = user;
        this.values = values;
        this.initLength = values.size();
    }

    @Override
    public int codeSize() {
        int sz = this.initLength;
        return 4 + (sz * this.elemWidth + 1) / 2;
    }

    @Override
    public void writeTo(AnnotatedOutput out) {
        int sz = this.values.size();
        out.writeShort(768);
        out.writeShort(this.elemWidth);
        out.writeInt(this.initLength);
        switch (this.elemWidth) {
            case 1: {
                for (int i = 0; i < sz; ++i) {
                    Constant cst = this.values.get(i);
                    out.writeByte((byte)((CstLiteral32)cst).getIntBits());
                }
                break;
            }
            case 2: {
                for (int i = 0; i < sz; ++i) {
                    Constant cst = this.values.get(i);
                    out.writeShort((short)((CstLiteral32)cst).getIntBits());
                }
                break;
            }
            case 4: {
                for (int i = 0; i < sz; ++i) {
                    Constant cst = this.values.get(i);
                    out.writeInt(((CstLiteral32)cst).getIntBits());
                }
                break;
            }
            case 8: {
                for (int i = 0; i < sz; ++i) {
                    Constant cst = this.values.get(i);
                    out.writeLong(((CstLiteral64)cst).getLongBits());
                }
                break;
            }
        }
        if (this.elemWidth == 1 && sz % 2 != 0) {
            out.writeByte(0);
        }
    }

    @Override
    public DalvInsn withRegisters(RegisterSpecList registers) {
        return new ArrayData(this.getPosition(), this.user, this.values, this.arrayType);
    }

    @Override
    protected String argString() {
        StringBuffer sb = new StringBuffer(100);
        int sz = this.values.size();
        for (int i = 0; i < sz; ++i) {
            sb.append("\n    ");
            sb.append(i);
            sb.append(": ");
            sb.append(this.values.get(i).toHuman());
        }
        return sb.toString();
    }

    @Override
    protected String listingString0(boolean noteIndices) {
        int baseAddress = this.user.getAddress();
        StringBuffer sb = new StringBuffer(100);
        int sz = this.values.size();
        sb.append("fill-array-data-payload // for fill-array-data @ ");
        sb.append(Hex.u2(baseAddress));
        for (int i = 0; i < sz; ++i) {
            sb.append("\n  ");
            sb.append(i);
            sb.append(": ");
            sb.append(this.values.get(i).toHuman());
        }
        return sb.toString();
    }
}

