/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex;

import com.android.jack.dx.dex.DexFormat;
import com.android.jack.util.AndroidApiLevel;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class DexOptions {
    public static final boolean ALIGN_64BIT_REGS = true;
    @Nonnull
    private final AndroidApiLevel androidApiLevel;
    private final boolean forceJumbo;

    public DexOptions(@Nonnull AndroidApiLevel androidApiLevel, boolean forcejumbo) {
        this.androidApiLevel = androidApiLevel;
        this.forceJumbo = forcejumbo;
    }

    @Nonnegative
    public int getDexVersion() {
        return DexFormat.apiToDexVersion(this.androidApiLevel);
    }

    public boolean isForceJumbo() {
        return this.forceJumbo;
    }

    @Nonnull
    public String getMagic() {
        return DexFormat.dexVersionToMagic(DexFormat.apiToDexVersion(this.androidApiLevel));
    }
}

