/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.cfg;

import com.android.jack.cfg.BasicBlock;
import com.android.jack.ir.ast.JStatement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class SwitchBasicBlock
extends BasicBlock {
    @Nonnegative
    private static final int DEFAULT_BLOCK_INDEX = 0;
    @Nonnegative
    private static final int CASE_BLOCK_START_INDEX = 1;
    @Nonnegative
    private static final int FIXED_BLOCK_COUNT = 1;

    public SwitchBasicBlock(@Nonnegative int id, @Nonnull List<JStatement> statements) {
        super(id, statements, 1);
    }

    public void setDefault(@Nonnull BasicBlock defaultBb) {
        this.setSuccessor(0, defaultBb);
    }

    public void addCaseBlock(@Nonnull BasicBlock caseBb) {
        this.addSuccessor(1, caseBb);
    }

    @Nonnull
    public BasicBlock getDefaultBlock() {
        return (BasicBlock)this.getInternalSuccessors().get(0);
    }

    @Nonnull
    public List<BasicBlock> getCasesBlock() {
        List cases = this.getInternalSuccessors().subList(1, this.getInternalSuccessors().size());
        ArrayList<BasicBlock> result = new ArrayList<BasicBlock>();
        for (BasicBlock bb : cases) {
            result.add(0, bb);
        }
        return result;
    }
}

