/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.cfg;

import com.android.jack.Options;
import com.android.jack.analysis.dfa.reachingdefs.ReachingDefsMarker;
import com.android.jack.cfg.BasicBlockMarker;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Removes markers related to the ControlFlowGraph.")
@Name(value="CfgMarkerRemover")
@Constraint(need={ControlFlowGraph.class, BasicBlockMarker.class})
@Transform(remove={ControlFlowGraph.class, BasicBlockMarker.class, ReachingDefsMarker.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class CfgMarkerRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        method.removeMarker(ControlFlowGraph.class);
        Visitor v = new Visitor();
        v.accept(method);
    }

    private static class Visitor
    extends JVisitor {
        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JStatement stmt) {
            stmt.removeMarker(BasicBlockMarker.class);
            return super.visit(stmt);
        }
    }
}

