/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.cfg;

import com.android.jack.JackEventType;
import com.android.jack.Options;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.BasicBlockMarker;
import com.android.jack.cfg.CatchBasicBlock;
import com.android.jack.cfg.ConditionalBasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.cfg.EntryBlock;
import com.android.jack.cfg.ExitBlock;
import com.android.jack.cfg.ForwardBranchResolver;
import com.android.jack.cfg.NormalBasicBlock;
import com.android.jack.cfg.PeiBasicBlock;
import com.android.jack.cfg.ReturnBasicBlock;
import com.android.jack.cfg.SwitchBasicBlock;
import com.android.jack.cfg.ThrowBasicBlock;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JBreakStatement;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JContinueStatement;
import com.android.jack.ir.ast.JExceptionRuntimeValue;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JIntegralConstant32;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLock;
import com.android.jack.ir.ast.JLoop;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JStatementList;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JSynchronizedBlock;
import com.android.jack.ir.ast.JThrowStatement;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JUnlock;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfoFactory;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.RefAsStatement;
import com.android.jack.transformations.ast.switches.UselessSwitches;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.ControlFlowHelper;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.schedulable.With;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Builds a ControlFlowGraph instance from a JMethod.")
@Name(value="CfgBuilder")
@Constraint(need={ThreeAddressCodeForm.class, JExceptionRuntimeValue.class}, no={JLoop.class, JBreakStatement.class, JContinueStatement.class, RefAsStatement.class, JSynchronizedBlock.class, JTryStatement.class, JFieldInitializer.class, UselessSwitches.class})
@Protect(add={JNode.class}, remove={JNode.class}, unprotect={@With(remove={ControlFlowGraph.class, BasicBlockMarker.class})})
@Transform(add={ControlFlowGraph.class, BasicBlockMarker.class})
@Use(value={SourceInfoFactory.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class CfgBuilder
implements RunnableSchedulable<JMethod> {
    @Nonnegative
    private static final byte NO_STATE = 0;
    @Nonnegative
    private static final byte QUEUED = 1;
    @Nonnegative
    private static final byte ACCESSIBLE = 2;
    @Nonnull
    public static final StatisticId<Counter> CREATED_BASIC_BLOCK = new StatisticId<Counter>("jack.cfg.created-basic-blocks", "Basic blocks created", CounterImpl.class, Counter.class);
    @Nonnull
    public static final StatisticId<Counter> REMOVED_BASIC_BLOCK = new StatisticId<Counter>("jack.cfg.removed-basic-blocks", "Unaccessible basic blocks removed", CounterImpl.class, Counter.class);
    @Nonnull
    public static final StatisticId<Counter> REMOVED_STATEMENT = new StatisticId<Counter>("jack.cfg.removed-statements", "Statements removed from the IR", CounterImpl.class, Counter.class);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        BuilderVisitor cfgBuilder = new BuilderVisitor(method);
        cfgBuilder.accept(method);
        method.addMarker(cfgBuilder.getCfg());
    }

    private void removeUnaccessibleNode(@Nonnull ArrayList<BasicBlock> nodes, @Nonnull BasicBlock entryNode, @Nonnull BasicBlock exitNode, @Nonnegative int maxBasicBlockId, @Nonnull JMethod method) {
        if (nodes.isEmpty()) {
            return;
        }
        byte[] state = new byte[maxBasicBlockId];
        LinkedList<BasicBlock> workingList = new LinkedList<BasicBlock>();
        workingList.add(entryNode);
        int accessibleNodesCount = 0;
        ArrayList<BasicBlock> basicBlockOfVirtualStmt = new ArrayList<BasicBlock>();
        while (!workingList.isEmpty()) {
            BasicBlock currentBb = (BasicBlock)workingList.remove(0);
            if (currentBb.getStatements().isEmpty() && currentBb != entryNode) {
                assert (currentBb instanceof NormalBasicBlock);
                BasicBlock newBlock = ((NormalBasicBlock)currentBb).getTarget();
                currentBb.replaceBy(newBlock);
                basicBlockOfVirtualStmt.add(currentBb);
            } else {
                state[currentBb.getId()] = 2;
                ++accessibleNodesCount;
            }
            for (BasicBlock succ : currentBb.getSuccessors()) {
                if (succ == exitNode || state[succ.getId()] != 0) continue;
                state[succ.getId()] = 1;
                workingList.add(succ);
            }
        }
        ArrayList<BasicBlock> accessibleBlocks = new ArrayList<BasicBlock>(accessibleNodesCount);
        int len = nodes.size();
        for (int i = 0; i < len; ++i) {
            BasicBlock block = nodes.get(i);
            if (state[i + 1] == 2) {
                accessibleBlocks.add(block);
                continue;
            }
            for (BasicBlock succ : block.getSuccessors()) {
                succ.removePredecessor(block);
            }
        }
        this.tracer.getStatistic(REMOVED_BASIC_BLOCK).incValue(nodes.size() - accessibleNodesCount);
        nodes.clear();
        nodes.addAll(accessibleBlocks);
        nodes.trimToSize();
        TransformationRequest tr = new TransformationRequest(method);
        new DeadCodeRemover(state, tr, exitNode, basicBlockOfVirtualStmt).accept(method);
        tr.commit();
    }

    class DeadCodeRemover
    extends JVisitor {
        @Nonnull
        private final byte[] blockState;
        @Nonnull
        private final BasicBlock exiBlock;
        @Nonnull
        private final TransformationRequest tr;
        @Nonnull
        private final List<BasicBlock> basicBlockOfVirtualStmt;

        public DeadCodeRemover(@Nonnull byte[] blockState, @Nonnull TransformationRequest tr, @Nonnull BasicBlock exiBlock, List<BasicBlock> basicBlockOfVirtualStmt) {
            this.blockState = blockState;
            this.tr = tr;
            this.exiBlock = exiBlock;
            this.basicBlockOfVirtualStmt = basicBlockOfVirtualStmt;
        }

        @Override
        public boolean visit(@Nonnull JStatement stmt) {
            boolean deadStatement = this.isDeadStatement(stmt);
            if (deadStatement) {
                assert (!(stmt instanceof JBlock) || !(stmt.getParent() instanceof JIfStatement) && !(stmt.getParent() instanceof JLabeledStatement) && !(stmt.getParent() instanceof JSwitchStatement));
                CfgBuilder.this.tracer.getStatistic(REMOVED_STATEMENT).incValue();
                this.tr.append(new Remove(stmt));
            }
            ArrayList<JCatchBlock> uselessCatchBlock = new ArrayList<JCatchBlock>(0);
            for (JCatchBlock catchBlock : stmt.getJCatchBlocks()) {
                BasicBlockMarker bbmOfCatch = catchBlock.getMarker(BasicBlockMarker.class);
                assert (bbmOfCatch != null);
                if (this.blockState[bbmOfCatch.getBasicBlock().getId()] == 2) continue;
                uselessCatchBlock.add(catchBlock);
            }
            if (!uselessCatchBlock.isEmpty()) {
                stmt.removeCatchBlocks(uselessCatchBlock);
            }
            return !deadStatement;
        }

        private boolean isDeadStatement(@Nonnull JStatement stmt) {
            BasicBlockMarker bbm = stmt.getMarker(BasicBlockMarker.class);
            assert (bbm != null);
            BasicBlock basicBlock = bbm.getBasicBlock();
            return basicBlock != this.exiBlock && this.blockState[basicBlock.getId()] != 2 && !this.basicBlockOfVirtualStmt.contains(basicBlock);
        }
    }

    class BuilderVisitor
    extends JVisitor {
        @Nonnegative
        private int basicBlockId = 0;
        @Nonnull
        private final EntryBlock entryBlock;
        @Nonnull
        private final ExitBlock exitBlock = new ExitBlock();
        @Nonnull
        private final ArrayList<BasicBlock> blocks;
        @Nonnull
        private final JMethod method;
        @Nonnull
        private List<JStatement> currentStmts = new LinkedList<JStatement>();
        private boolean firstStmtCreated = false;
        @Nonnull
        private List<JStatement> virtualStmts = new LinkedList<JStatement>();
        @Nonnull
        private final ForwardBranchResolver forwardBranchResolver = new ForwardBranchResolver(this.exitBlock);
        @Nonnull
        private List<JCatchBlock> previousCatchBlock = new ArrayList<JCatchBlock>();

        public BuilderVisitor(JMethod method) {
            assert (method != null);
            this.method = method;
            this.blocks = new ArrayList();
            this.entryBlock = new EntryBlock(this.basicBlockId++);
        }

        @Override
        public void endVisit(@Nonnull JMethodBody methodBody) {
            assert (this.currentStmts.isEmpty());
            if (!this.virtualStmts.isEmpty()) {
                BasicBlockMarker marker = new BasicBlockMarker(this.exitBlock);
                for (JStatement statement : this.virtualStmts) {
                    statement.addMarker(marker);
                }
            }
            this.forwardBranchResolver.resolve();
        }

        @Override
        public boolean visit(@Nonnull JCatchBlock catchBlock) {
            super.visit(catchBlock);
            assert (this.currentStmts.isEmpty());
            List<JStatement> catchStmts = catchBlock.getStatements();
            assert (catchStmts.size() >= 1);
            this.accept(catchStmts.get(0));
            CatchBasicBlock catchBasicBlock = new CatchBasicBlock(this.basicBlockId++, this.currentStmts, catchBlock.getCatchTypes(), catchBlock.getCatchVar());
            this.setBlockOfStatement(catchBasicBlock);
            JStatement nextStatementAfterExceptionAssign = ControlFlowHelper.getNextStatement(this.getConcreteStatement(catchBlock));
            this.forwardBranchResolver.addNormalBasicBlock(catchBasicBlock, nextStatementAfterExceptionAssign);
            this.accept(catchStmts.subList(1, catchStmts.size()));
            if (nextStatementAfterExceptionAssign != null) {
                NormalBasicBlock endOfBlock = new NormalBasicBlock(this.basicBlockId++, this.currentStmts);
                this.setBlockOfStatement(endOfBlock);
                this.forwardBranchResolver.addNormalBasicBlock(endOfBlock, ControlFlowHelper.getNextStatement(catchBlock));
            }
            return false;
        }

        @Override
        public boolean visit(@Nonnull JStatement statement) {
            if (!this.currentStmts.isEmpty() && !statement.getJCatchBlocks().equals(this.previousCatchBlock)) {
                this.previousCatchBlock = statement.getJCatchBlocks();
                NormalBasicBlock tryBasicBlock = new NormalBasicBlock(this.basicBlockId++, this.currentStmts);
                this.setBlockOfStatement(tryBasicBlock);
                this.forwardBranchResolver.addNormalBasicBlock(tryBasicBlock, statement instanceof JBlock ? this.getConcreteStatement((JBlock)statement) : statement);
            }
            if (statement instanceof JLabeledStatement || statement instanceof JBlock || statement instanceof JCatchBlock) {
                this.virtualStmts.add(statement);
            } else {
                this.currentStmts.add(statement);
            }
            return super.visit(statement);
        }

        @Override
        public boolean visit(@Nonnull JIfStatement ifStmt) {
            JStatement nextStatement;
            NormalBasicBlock endOfBlock;
            super.visit(ifStmt);
            ConditionalBasicBlock condBlock = new ConditionalBasicBlock(this.basicBlockId++, this.currentStmts);
            this.setBlockOfStatement(condBlock);
            this.accept(ifStmt.getThenStmt());
            JStatement elseStmt = ifStmt.getElseStmt();
            if (!this.currentStmts.isEmpty() || elseStmt != null && !this.virtualStmts.isEmpty()) {
                endOfBlock = new NormalBasicBlock(this.basicBlockId++, this.currentStmts);
                this.setBlockOfStatement(endOfBlock);
                nextStatement = ControlFlowHelper.getNextStatement(ifStmt);
                this.forwardBranchResolver.addNormalBasicBlock(endOfBlock, nextStatement);
            }
            if (elseStmt != null) {
                this.accept(elseStmt);
                if (!this.currentStmts.isEmpty()) {
                    endOfBlock = new NormalBasicBlock(this.basicBlockId++, this.currentStmts);
                    this.setBlockOfStatement(endOfBlock);
                    nextStatement = ControlFlowHelper.getNextStatement(ifStmt);
                    this.forwardBranchResolver.addNormalBasicBlock(endOfBlock, nextStatement);
                }
            } else {
                elseStmt = ControlFlowHelper.getNextStatement(ifStmt);
            }
            this.forwardBranchResolver.addConditionalBasicBlock(condBlock, ifStmt.getThenStmt(), elseStmt);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JReturnStatement retStmt) {
            super.visit(retStmt);
            ReturnBasicBlock returnBlock = new ReturnBasicBlock(this.basicBlockId++, this.exitBlock, this.currentStmts);
            this.setBlockOfStatement(returnBlock);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JGoto gotoStmt) {
            super.visit(gotoStmt);
            NormalBasicBlock branchBlock = new NormalBasicBlock(this.basicBlockId++, this.currentStmts);
            this.setBlockOfStatement(branchBlock);
            JLabeledStatement labeledStatement = gotoStmt.getTargetBlock();
            BasicBlockMarker bbm = labeledStatement.getMarker(BasicBlockMarker.class);
            if (bbm == null || bbm.getBasicBlock() == null) {
                this.forwardBranchResolver.addNormalBasicBlock(branchBlock, labeledStatement.getBody());
            } else {
                branchBlock.setTarget(bbm.getBasicBlock());
            }
            return false;
        }

        @Override
        public boolean visit(@Nonnull JLabeledStatement labeledStatement) {
            if (!this.currentStmts.isEmpty()) {
                NormalBasicBlock normalBasicBlock = new NormalBasicBlock(this.basicBlockId++, this.currentStmts);
                this.setBlockOfStatement(normalBasicBlock);
                this.forwardBranchResolver.addNormalBasicBlock(normalBasicBlock, this.getConcreteStatement((JBlock)labeledStatement.getBody()));
            }
            super.visit(labeledStatement);
            return true;
        }

        @Override
        public boolean visit(@Nonnull JSwitchStatement switchStatement) {
            super.visit(switchStatement);
            SwitchBasicBlock switchBlock = new SwitchBasicBlock(this.basicBlockId++, this.currentStmts);
            this.setBlockOfStatement(switchBlock);
            List<JCaseStatement> cases = switchStatement.getCases();
            Collections.sort(cases, new JCaseStatementComparator());
            JStatement defaultCase = switchStatement.getDefaultCase();
            if (defaultCase == null) {
                defaultCase = ControlFlowHelper.getNextStatement(switchStatement);
            }
            this.forwardBranchResolver.addSwitchBasicBlock(switchBlock, cases, defaultCase);
            return true;
        }

        @Override
        public boolean visit(@Nonnull JCaseStatement caseStatement) {
            if (!this.currentStmts.isEmpty()) {
                NormalBasicBlock caseBlock = new NormalBasicBlock(this.basicBlockId++, this.currentStmts);
                this.setBlockOfStatement(caseBlock);
                this.forwardBranchResolver.addNormalBasicBlock(caseBlock, caseStatement);
            }
            super.visit(caseStatement);
            return true;
        }

        @Override
        public boolean visit(@Nonnull JExpressionStatement exprStmt) {
            super.visit(exprStmt);
            JExpression expr = exprStmt.getExpr();
            if (this.expressionCanThrow(expr)) {
                this.buildCfgForPei(exprStmt);
            }
            return false;
        }

        @Override
        public boolean visit(@Nonnull JThrowStatement throwStmt) {
            super.visit(throwStmt);
            ThrowBasicBlock throwBlock = new ThrowBasicBlock(this.basicBlockId++, this.currentStmts);
            this.setBlockOfStatement(throwBlock);
            this.forwardBranchResolver.addPeiBasicBlock(throwBlock, null, throwStmt.getJCatchBlocks());
            throwBlock.setExitBlockWhenUncaught(this.exitBlock);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JLock lockStmt) {
            super.visit(lockStmt);
            this.buildCfgForPei(lockStmt);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JUnlock unlockStmt) {
            super.visit(unlockStmt);
            this.buildCfgForPei(unlockStmt);
            return false;
        }

        @Nonnull
        public ControlFlowGraph getCfg() {
            try (Event optEvent = CfgBuilder.this.tracer.open(JackEventType.REMOVE_DEAD_CODE);){
                CfgBuilder.this.tracer.getStatistic(CREATED_BASIC_BLOCK).incValue(this.blocks.size() + 1);
                CfgBuilder.this.removeUnaccessibleNode(this.blocks, this.entryBlock, this.exitBlock, this.basicBlockId, this.method);
            }
            return new ControlFlowGraph(this.method, this.basicBlockId, this.entryBlock, this.exitBlock, this.blocks);
        }

        @Nonnull
        private JStatement getConcreteStatement(@Nonnull JStatementList block) {
            List<JStatement> statements = block.getStatements();
            if (statements.isEmpty()) {
                JStatement nextStatement = ControlFlowHelper.getNextStatement(block);
                assert (nextStatement != null);
                return nextStatement;
            }
            JStatement firstStmt = statements.get(0);
            if (firstStmt instanceof JBlock) {
                return this.getConcreteStatement((JBlock)firstStmt);
            }
            if (firstStmt instanceof JLabeledStatement) {
                return this.getConcreteStatement((JBlock)((JLabeledStatement)firstStmt).getBody());
            }
            if (firstStmt instanceof JTryStatement) {
                return this.getConcreteStatement(((JTryStatement)firstStmt).getTryBlock());
            }
            return firstStmt;
        }

        private boolean expressionCanThrow(@Nonnull JExpression expression) {
            return expression.canThrow() || expression instanceof JBinaryOperation && (this.expressionCanThrow(((JBinaryOperation)expression).getLhs()) || this.expressionCanThrow(((JBinaryOperation)expression).getRhs()));
        }

        private void setBlockOfStatement(@Nonnull BasicBlock bb) {
            this.blocks.add(bb);
            BasicBlockMarker marker = new BasicBlockMarker(bb);
            for (JStatement statement : this.currentStmts) {
                statement.addMarker(marker);
            }
            for (JStatement statement : this.virtualStmts) {
                statement.addMarker(marker);
            }
            if (!this.firstStmtCreated) {
                this.entryBlock.setTarget(bb);
                this.firstStmtCreated = true;
            }
            this.currentStmts = new LinkedList<JStatement>();
            this.virtualStmts = new LinkedList<JStatement>();
        }

        private void buildCfgForPei(@Nonnull JStatement peiInst) {
            PeiBasicBlock peiBlock = new PeiBasicBlock(this.basicBlockId++, this.currentStmts);
            this.setBlockOfStatement(peiBlock);
            JStatement nextStatement = ControlFlowHelper.getNextStatement(peiInst);
            this.forwardBranchResolver.addPeiBasicBlock(peiBlock, nextStatement, peiInst.getJCatchBlocks());
            peiBlock.setExitBlockWhenUncaught(this.exitBlock);
        }
    }

    private static class JCaseStatementComparator
    implements Comparator<JCaseStatement>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private JCaseStatementComparator() {
        }

        @Override
        public int compare(JCaseStatement case1, JCaseStatement case2) {
            int lit2Value;
            JLiteral lit1 = case1.getExpr();
            JLiteral lit2 = case2.getExpr();
            assert (lit1 instanceof JValueLiteral);
            assert (lit2 instanceof JValueLiteral);
            int lit1Value = ((JIntegralConstant32)((Object)lit1)).getIntValue();
            return lit1Value < (lit2Value = ((JIntegralConstant32)((Object)lit2)).getIntValue()) ? -1 : (lit1Value == lit2Value ? 0 : 1);
        }
    }
}

