/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.cfg;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.util.graph.GraphNode;
import com.android.sched.item.Component;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class BasicBlock
extends GraphNode<BasicBlock>
implements Component {
    @Nonnull
    private final List<JStatement> statements;
    @Nonnegative
    private final int id;
    @Nonnull
    static final List<JStatement> EMPTY_STATEMENT_LIST = new LinkedList<JStatement>();

    protected BasicBlock(@Nonnegative int id, @Nonnull List<JStatement> statements, @Nonnegative int fixedSuccessorCount) {
        super(fixedSuccessorCount);
        this.statements = Jack.getUnmodifiableCollections().getUnmodifiableList(statements);
        this.id = id;
    }

    @Nonnull
    public List<JStatement> getStatements() {
        return this.statements;
    }

    @Nonnegative
    public int getId() {
        return this.id;
    }

    @Nonnull
    public String toString() {
        return "BB-" + this.id;
    }

    @Nonnull
    public JStatement getLastInstruction() {
        return this.statements.get(this.statements.size() - 1);
    }

    @Override
    @Nonnull
    public List<BasicBlock> getSuccessors() {
        return Jack.getUnmodifiableCollections().getUnmodifiableList(this.successors);
    }
}

