/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.invokecustom;

import com.android.jack.Jack;
import com.android.jack.backend.dex.rop.RopHelper;
import com.android.jack.dx.rop.cst.CstArray;
import com.android.jack.dx.rop.cst.CstCallSiteRef;
import com.android.jack.dx.rop.cst.CstDouble;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.dx.rop.cst.CstFloat;
import com.android.jack.dx.rop.cst.CstInteger;
import com.android.jack.dx.rop.cst.CstLong;
import com.android.jack.dx.rop.cst.CstMethodHandleRef;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstPrototypeRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.TypedConstant;
import com.android.jack.dx.rop.type.Prototype;
import com.android.jack.dx.rop.type.StdTypeList;
import com.android.jack.ir.ast.JAbstractMethodCall;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JByteLiteral;
import com.android.jack.ir.ast.JCharLiteral;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JDoubleLiteral;
import com.android.jack.ir.ast.JEnumLiteral;
import com.android.jack.ir.ast.JFloatLiteral;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JShortLiteral;
import com.android.jack.ir.ast.JStringLiteral;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class InvokeCustomHelper {
    public static boolean isInvokeCustom(@Nonnull JAbstractMethodCall call) {
        Collection<JMethod> methods = call.getMethodIdWide().getMethods();
        Iterator<JMethod> methodsIt = methods.iterator();
        boolean isInvokeCustom = false;
        while (methodsIt.hasNext()) {
            JMethod method = methodsIt.next();
            if (InvokeCustomHelper.getInvokeCustomCallsite(method) == null) continue;
            isInvokeCustom = true;
            break;
        }
        assert (!isInvokeCustom || methods.size() == 1);
        return isInvokeCustom;
    }

    @Nonnull
    public static CstCallSiteRef readInvokeCustomCallSite(@Nonnull JAnnotation invokeCustomCallSite) {
        CstMethodHandleRef methodHandle = null;
        JStringLiteral callSiteMethodName = null;
        JClassLiteral callSiteReturnType = null;
        JArrayLiteral callSiteArgumentTypes = null;
        CstArray extraArgs = null;
        for (JNameValuePair nameValuePair : invokeCustomCallSite.getNameValuePairs()) {
            switch (nameValuePair.getName()) {
                case "invokeMethodHandle": {
                    JArrayLiteral arrayLiteral = (JArrayLiteral)nameValuePair.getValue();
                    assert (arrayLiteral.getValues().size() == 1);
                    methodHandle = InvokeCustomHelper.readLinkerMethodHandle((JAnnotation)arrayLiteral.getValues().get(0));
                    break;
                }
                case "fieldMethodHandle": {
                    JArrayLiteral arrayLiteral = (JArrayLiteral)nameValuePair.getValue();
                    assert (arrayLiteral.getValues().size() == 1);
                    methodHandle = InvokeCustomHelper.readLinkerFieldHandle((JAnnotation)arrayLiteral.getValues().get(0));
                    break;
                }
                case "methodHandleExtraArgs": {
                    extraArgs = InvokeCustomHelper.readExtraArgs((JArrayLiteral)nameValuePair.getValue());
                    break;
                }
                case "name": {
                    callSiteMethodName = (JStringLiteral)nameValuePair.getValue();
                    break;
                }
                case "returnType": {
                    callSiteReturnType = (JClassLiteral)nameValuePair.getValue();
                    break;
                }
                case "argumentTypes": {
                    callSiteArgumentTypes = (JArrayLiteral)nameValuePair.getValue();
                }
            }
        }
        assert (methodHandle != null);
        assert (callSiteMethodName != null);
        assert (callSiteArgumentTypes != null);
        assert (callSiteReturnType != null);
        return new CstCallSiteRef(methodHandle, callSiteMethodName.getValue(), new CstPrototypeRef(InvokeCustomHelper.buildPrototype(callSiteArgumentTypes, callSiteReturnType)), extraArgs);
    }

    @CheckForNull
    public static JAnnotation getInvokeCustomCallsite(@Nonnull JMethod method) {
        for (JAnnotation annotation : method.getAnnotations()) {
            if (!annotation.getType().getName().equals("CalledByInvokeCustom")) continue;
            return annotation;
        }
        return null;
    }

    @Nonnull
    private static CstArray readExtraArgs(@Nonnull JArrayLiteral extraArgs) {
        CstArray.List list = new CstArray.List(extraArgs.getValues().size());
        int idx = 0;
        for (JLiteral extraArg : extraArgs.getValues()) {
            assert (extraArg instanceof JAnnotation);
            JAnnotation extrArgAnnot = (JAnnotation)extraArg;
            for (JNameValuePair nameValuePair : extrArgAnnot.getNameValuePairs()) {
                JArrayLiteral value = (JArrayLiteral)nameValuePair.getValue();
                assert (value.getValues().size() == 1);
                TypedConstant cst = null;
                JLiteral jLiteral = value.getValues().get(0);
                switch (nameValuePair.getName()) {
                    case "booleanValue": {
                        cst = CstInteger.make(((JBooleanLiteral)jLiteral).getValue() ? 1 : 0);
                        break;
                    }
                    case "byteValue": {
                        cst = CstInteger.make(((JByteLiteral)jLiteral).getValue());
                        break;
                    }
                    case "charValue": {
                        cst = CstInteger.make(((JCharLiteral)jLiteral).getValue());
                        break;
                    }
                    case "shortValue": {
                        cst = CstInteger.make(((JShortLiteral)jLiteral).getValue());
                        break;
                    }
                    case "intValue": {
                        cst = CstInteger.make(((JIntLiteral)jLiteral).getValue());
                        break;
                    }
                    case "floatValue": {
                        cst = CstFloat.make(Float.floatToIntBits(((JFloatLiteral)jLiteral).getValue()));
                        break;
                    }
                    case "doubleValue": {
                        cst = CstDouble.make(Double.doubleToLongBits(((JDoubleLiteral)jLiteral).getValue()));
                        break;
                    }
                    case "longValue": {
                        cst = CstLong.make(((JLongLiteral)jLiteral).getValue());
                        break;
                    }
                    case "stringValue": {
                        cst = new CstString(((JStringLiteral)jLiteral).getValue());
                        break;
                    }
                    case "classValue": {
                        cst = RopHelper.convertTypeToDx(((JClassLiteral)jLiteral).getRefType());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                list.set(idx++, cst);
            }
        }
        list.setImmutable();
        return new CstArray(list);
    }

    @Nonnull
    private static CstMethodHandleRef readLinkerFieldHandle(@Nonnull JAnnotation linkerFieldHandle) {
        JNameValuePair kindValuePair = linkerFieldHandle.getNameValuePair("kind");
        assert (kindValuePair != null);
        JEnumLiteral enumKind = (JEnumLiteral)kindValuePair.getValue();
        CstMethodHandleRef.MethodHandleKind kind = CstMethodHandleRef.MethodHandleKind.valueOf(enumKind.getFieldId().getName());
        assert (kind == CstMethodHandleRef.MethodHandleKind.GET_INSTANCE || kind == CstMethodHandleRef.MethodHandleKind.GET_STATIC || kind == CstMethodHandleRef.MethodHandleKind.PUT_INSTANCE || kind == CstMethodHandleRef.MethodHandleKind.PUT_STATIC);
        JNameValuePair ownerValuePair = linkerFieldHandle.getNameValuePair("enclosingType");
        assert (ownerValuePair != null);
        JClassLiteral owner = (JClassLiteral)ownerValuePair.getValue();
        JNameValuePair nameValuePair = linkerFieldHandle.getNameValuePair("name");
        assert (nameValuePair != null);
        JStringLiteral name = (JStringLiteral)nameValuePair.getValue();
        JNameValuePair typeValuePair = linkerFieldHandle.getNameValuePair("type");
        JClassLiteral type = typeValuePair == null ? (JClassLiteral)InvokeCustomHelper.getDefaultValue(linkerFieldHandle, "type") : (JClassLiteral)typeValuePair.getValue();
        assert (type != null);
        CstFieldRef fieldRef = new CstFieldRef(RopHelper.convertTypeToDx(owner.getRefType()), new CstString(name.getValue()), RopHelper.convertTypeToDx(type.getRefType()));
        return new CstMethodHandleRef(kind, fieldRef);
    }

    @Nonnull
    private static CstMethodHandleRef readLinkerMethodHandle(@Nonnull JAnnotation linkerMethodHandle) {
        JNameValuePair kindValuePair = linkerMethodHandle.getNameValuePair("kind");
        assert (kindValuePair != null);
        JEnumLiteral enumKind = (JEnumLiteral)kindValuePair.getValue();
        CstMethodHandleRef.MethodHandleKind kind = CstMethodHandleRef.MethodHandleKind.valueOf(enumKind.getFieldId().getName());
        assert (kind == CstMethodHandleRef.MethodHandleKind.INVOKE_CONSTRUCTOR || kind == CstMethodHandleRef.MethodHandleKind.INVOKE_INSTANCE || kind == CstMethodHandleRef.MethodHandleKind.INVOKE_STATIC);
        JNameValuePair ownerValuePair = linkerMethodHandle.getNameValuePair("enclosingType");
        assert (ownerValuePair != null);
        JClassLiteral owner = (JClassLiteral)ownerValuePair.getValue();
        JNameValuePair nameValuePair = linkerMethodHandle.getNameValuePair("name");
        assert (nameValuePair != null);
        JStringLiteral name = (JStringLiteral)nameValuePair.getValue();
        JNameValuePair returnTypeValuePair = linkerMethodHandle.getNameValuePair("returnType");
        JClassLiteral returnType = returnTypeValuePair == null ? (JClassLiteral)InvokeCustomHelper.getDefaultValue(linkerMethodHandle, "returnType") : (JClassLiteral)returnTypeValuePair.getValue();
        assert (returnType != null);
        JNameValuePair argumentTypesValuePair = linkerMethodHandle.getNameValuePair("argumentTypes");
        JArrayLiteral argumentsTypes = argumentTypesValuePair == null ? (JArrayLiteral)InvokeCustomHelper.getDefaultValue(linkerMethodHandle, "argumentTypes") : (JArrayLiteral)argumentTypesValuePair.getValue();
        assert (argumentsTypes != null);
        CstMethodRef methodRef = new CstMethodRef(RopHelper.convertTypeToDx(owner.getRefType()), new CstString(name.getValue()), InvokeCustomHelper.buildPrototype(argumentsTypes, returnType));
        return new CstMethodHandleRef(kind, methodRef);
    }

    @Nonnull
    private static JLiteral getDefaultValue(@Nonnull JAnnotation annotation, @Nonnull String name) {
        JLiteral returnValue = null;
        JDefinedAnnotationType annotationType = (JDefinedAnnotationType)annotation.getType();
        if (annotationType.isToEmit()) {
            Collection annotations = annotationType.getAnnotations(Jack.getSession().getPhantomLookup().getAnnotationType("Ldalvik/annotation/AnnotationDefault;"));
            assert (annotations.size() == 1);
            JNameValuePair defaultAnnotationPair = ((JAnnotation)annotations.get(0)).getNameValuePair("value");
            assert (defaultAnnotationPair != null);
            JNameValuePair nameValuePair = ((JAnnotation)defaultAnnotationPair.getValue()).getNameValuePair(name);
            assert (nameValuePair != null);
            returnValue = nameValuePair.getValue();
        } else {
            for (JMethod annotationMethod : annotationType.getMethods()) {
                if (!annotationMethod.getName().equals(name)) continue;
                returnValue = ((JAnnotationMethod)annotationMethod).getDefaultValue();
                break;
            }
        }
        assert (returnValue != null);
        return returnValue;
    }

    @Nonnull
    private static Prototype buildPrototype(@Nonnull JArrayLiteral signature, @Nonnull JClassLiteral returnType) {
        List<JLiteral> values = signature.getValues();
        StdTypeList stdTypeList = new StdTypeList(values.size());
        int idx = 0;
        for (JLiteral lit : values) {
            assert (lit instanceof JClassLiteral);
            JClassLiteral classLit = (JClassLiteral)lit;
            stdTypeList.set(idx++, RopHelper.convertTypeToDx(classLit.getRefType()));
        }
        return Prototype.intern(stdTypeList, RopHelper.convertTypeToDx(returnType.getRefType()));
    }
}

