/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.compatibility;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.api.v01.impl.Api01Feature;
import com.android.jack.api.v02.impl.Api02Feature;
import com.android.jack.api.v03.impl.Api03Feature;
import com.android.jack.backend.dex.compatibility.CheckAndroidCompatibility;
import com.android.jack.backend.dex.compatibility.DefaultMethodReportable;
import com.android.jack.backend.dex.compatibility.InvokePolymorphicReportable;
import com.android.jack.backend.dex.compatibility.SerializableLambdaReportable;
import com.android.jack.backend.dex.compatibility.StaticMethodReportable;
import com.android.jack.config.id.Carnac;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JPolymorphicMethodCall;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.InvalidDefaultBridgeInInterfaceRemoved;
import com.android.jack.util.AndroidApiLevel;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import javax.annotation.Nonnull;

@HasKeyId
@Description(value="Checks that the IR is compatible with the dex output.")
@Support(value={CheckAndroidCompatibility.class})
@Constraint(need={InvalidDefaultBridgeInInterfaceRemoved.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class}, unlessOne={Api01Feature.class, Api02Feature.class, Api03Feature.class})
public class AndroidCompatibilityChecker
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public static final BooleanPropertyId CHECK_COMPATIBILITY = BooleanPropertyId.create("jack.android.api-level.check", "Check compatibility with the Android platform").addDefaultValue(Boolean.FALSE).addCategory(Carnac.class);
    @Nonnull
    private final AndroidApiLevel androidMinApiLevel = ThreadConfig.get(Options.ANDROID_MIN_API_LEVEL);
    @Nonnull
    private final JInterface serializable = Jack.getSession().getPhantomLookup().getInterface(CommonTypes.JAVA_IO_SERIALIZABLE);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final JSession session = Jack.getSession();

    @Override
    public void run(@Nonnull JMethod m) {
        JVisitor visitor;
        if (this.androidMinApiLevel.getReleasedLevel() < AndroidApiLevel.ReleasedLevel.N.getLevel() && m.getEnclosingType() instanceof JInterface && !m.isAbstract() && !JMethod.isClinit(m)) {
            Reportable reportable = m.isStatic() ? new StaticMethodReportable(m) : new DefaultMethodReportable(m);
            this.session.getReporter().report(Reporter.Severity.NON_FATAL, reportable);
            this.session.abortEventually();
        }
        if (!m.isNative() && !m.isAbstract() && this.filter.accept(this.getClass(), m)) {
            visitor = new SerializableLambdaVisitor();
            visitor.accept(m);
        }
        switch (this.androidMinApiLevel.getProvisionalLevel()) {
            case O_BETA1: 
            case O_BETA2: {
                break;
            }
            default: {
                visitor = new UsedInvokePolymorphicVisitor();
                visitor.accept(m);
            }
        }
    }

    private class SerializableLambdaVisitor
    extends JVisitor {
        private SerializableLambdaVisitor() {
        }

        @Override
        public boolean visit(@Nonnull JLambda lambda) {
            if (lambda.getType().canBeSafelyUpcast(AndroidCompatibilityChecker.this.serializable)) {
                Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, new SerializableLambdaReportable(lambda));
            }
            for (JInterface bound : lambda.getInterfaceBounds()) {
                if (!bound.canBeSafelyUpcast(AndroidCompatibilityChecker.this.serializable)) continue;
                Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, new SerializableLambdaReportable(lambda));
            }
            return true;
        }
    }

    private class UsedInvokePolymorphicVisitor
    extends JVisitor {
        @Nonnull
        Reporter reporter;

        private UsedInvokePolymorphicVisitor() {
            this.reporter = AndroidCompatibilityChecker.this.session.getReporter();
        }

        @Override
        public boolean visit(@Nonnull JPolymorphicMethodCall polymorphicMethodCall) {
            this.reporter.report(Reporter.Severity.NON_FATAL, new InvokePolymorphicReportable(polymorphicMethodCall));
            AndroidCompatibilityChecker.this.session.abortEventually();
            return true;
        }

        @Override
        public boolean visit(@Nonnull JMethodCall methodCall) {
            if (methodCall.isCallToPolymorphicMethod()) {
                this.reporter.report(Reporter.Severity.NON_FATAL, new InvokePolymorphicReportable(methodCall));
                AndroidCompatibilityChecker.this.session.abortEventually();
            }
            return true;
        }
    }
}

