/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.annotations;

import com.android.jack.Jack;
import com.android.jack.backend.dex.annotations.tag.ParameterMetadataAnnotation;
import com.android.jack.backend.dex.annotations.tag.ParameterMetadataFeature;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.JStringLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.library.PrebuiltCompatibility;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.request.AddAnnotation;
import com.android.jack.transformations.request.PutNameValuePair;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.With;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.id.BooleanPropertyId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@HasKeyId
@Description(value="Add annotations for parameter metadata")
@Transform(add={ParameterMetadataAnnotation.class, JAnnotation.class, JNameValuePair.class, JStringLiteral.class, JIntLiteral.class, JArrayLiteral.class})
@Protect(add={JMethod.class, JParameter.class}, unprotect={@With(remove={ParameterMetadataAnnotation.class})})
@Filter(value={TypeWithoutPrebuiltFilter.class})
@Support(value={ParameterMetadataFeature.class})
public class ParameterMetadataAnnotationsAdder
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public static final BooleanPropertyId PARAMETER_ANNOTATION = ((BooleanPropertyId)BooleanPropertyId.create("jack.dex.parameter.annotations", "Emit parameter annotations").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class);
    @Nonnull
    JAnnotationType methodParametersAnnotationType = Jack.getSession().getPhantomLookup().getAnnotationType("Ldalvik/annotation/MethodParameters;");
    @Nonnull
    JMethodIdWide namesMethodIdWide = this.methodParametersAnnotationType.getOrCreateMethodIdWide("names", Collections.emptyList(), MethodKind.INSTANCE_VIRTUAL);
    @Nonnull
    JMethodIdWide accessFlagsMethodIdWide = this.methodParametersAnnotationType.getOrCreateMethodIdWide("accessFlags", Collections.emptyList(), MethodKind.INSTANCE_VIRTUAL);

    @Override
    public void run(@Nonnull JMethod method) {
        Visitor visitor = new Visitor(method.getParams().size());
        visitor.accept(method);
        this.writeParameterAnnotation(method, visitor.names, visitor.accessFlags);
    }

    private void writeParameterAnnotation(@Nonnull JMethod method, @Nonnull List<JLiteral> names, @Nonnull List<JLiteral> accessFlags) {
        TransformationRequest tr = new TransformationRequest(method);
        SourceInfo si = SourceInfo.UNKNOWN;
        JAnnotation annotation = new JAnnotation(si, JRetentionPolicy.SYSTEM, this.methodParametersAnnotationType);
        tr.append(new AddAnnotation(annotation, method));
        JNameValuePair namesPair = new JNameValuePair(si, this.namesMethodIdWide, new JArrayLiteral(si, names));
        tr.append(new PutNameValuePair(annotation, namesPair));
        JNameValuePair accessFlagsPair = new JNameValuePair(si, this.accessFlagsMethodIdWide, new JArrayLiteral(si, accessFlags));
        tr.append(new PutNameValuePair(annotation, accessFlagsPair));
        tr.commit();
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final List<JLiteral> names;
        @Nonnull
        private final List<JLiteral> accessFlags;
        @Nonnull
        private final SourceInfo si = SourceInfo.UNKNOWN;

        public Visitor(@Nonnull int parameterCount) {
            this.names = new ArrayList<JLiteral>(parameterCount);
            this.accessFlags = new ArrayList<JLiteral>(parameterCount);
        }

        @Override
        public boolean visit(@Nonnull JMethod method) {
            for (JParameter parameter : method.getParams()) {
                this.addParameterName(parameter.isNamePresent() ? parameter.getName() : null);
                this.accessFlags.add(new JIntLiteral(this.si, parameter.getModifier() & 0xFFBFFFFF));
            }
            return super.visit(method);
        }

        private void addParameterName(@CheckForNull String parameterName) {
            if (parameterName != null) {
                this.names.add(new JStringLiteral(this.si, parameterName));
            } else {
                this.names.add(new JNullLiteral(this.si));
            }
        }
    }
}

