/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.annotations;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.backend.dex.annotations.AnnotationMethodDefaultValue;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.feature.SourceVersion8;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.request.AddAnnotation;
import com.android.jack.transformations.request.AddNameValuePair;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.Optional;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.ToSupport;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Add annotation methods default values as system annotation.")
@Synchronized
@Transform(remove={AnnotationMethodDefaultValue.class}, add={JAnnotation.class, JNameValuePair.class})
@Optional(value={@ToSupport(feature={SourceVersion8.class}, add={@Constraint(no={JAnnotation.RepeatedAnnotation.class})})})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
@ExclusiveAccess(value=JDefinedClassOrInterface.class)
public class DefaultValueAnnotationAdder
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @CheckForNull
    private JAnnotationType defaultAnnotationType;

    @Override
    public synchronized void run(@Nonnull JMethod method) {
        JAnnotationMethod annotationMethod;
        JLiteral defaultValue;
        JDefinedClassOrInterface enclosingType = method.getEnclosingType();
        if (!this.filter.accept(this.getClass(), method)) {
            return;
        }
        if (method instanceof JAnnotationMethod && (defaultValue = (annotationMethod = (JAnnotationMethod)method).getDefaultValue()) != null) {
            TransformationRequest tr = new TransformationRequest(enclosingType);
            tr.append(new Remove(defaultValue));
            SourceInfo sourceInfo = defaultValue.getSourceInfo();
            JAnnotation defaultAnnotation = this.getDefaultAnnotation((JDefinedAnnotationType)enclosingType, tr);
            tr.append(new AddNameValuePair(defaultAnnotation, new JNameValuePair(sourceInfo, method.getMethodIdWide(), defaultValue)));
            tr.commit();
        }
    }

    @Nonnull
    private JAnnotation getDefaultAnnotation(@Nonnull JDefinedAnnotationType targetAnnotationType, @Nonnull TransformationRequest tr) {
        JAnnotationType defaultAnnotationType = this.getDefaultAnnotationType();
        JAnnotation defaultAnnotation = null;
        Collection defaultAnnotations = targetAnnotationType.getAnnotations(defaultAnnotationType);
        if (defaultAnnotations.isEmpty()) {
            defaultAnnotation = new JAnnotation(SourceInfo.UNKNOWN, JRetentionPolicy.SYSTEM, defaultAnnotationType);
            JMethodIdWide methodId = defaultAnnotationType.getOrCreateMethodIdWide("value", Collections.emptyList(), MethodKind.INSTANCE_VIRTUAL);
            defaultAnnotation.add(new JNameValuePair(SourceInfo.UNKNOWN, methodId, new JAnnotation(SourceInfo.UNKNOWN, targetAnnotationType.getRetentionPolicy(), targetAnnotationType)));
            tr.append(new AddAnnotation(defaultAnnotation, targetAnnotationType));
        } else {
            assert (defaultAnnotations.size() == 1);
            defaultAnnotation = (JAnnotation)defaultAnnotations.get(0);
        }
        return (JAnnotation)defaultAnnotation.getNameValuePairs().iterator().next().getValue();
    }

    @Nonnull
    private JAnnotationType getDefaultAnnotationType() {
        if (this.defaultAnnotationType == null) {
            this.defaultAnnotationType = Jack.getSession().getPhantomLookup().getAnnotationType("Ldalvik/annotation/AnnotationDefault;");
        }
        assert (this.defaultAnnotationType != null);
        return this.defaultAnnotationType;
    }
}

