/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.Jack;
import com.android.jack.JackEventType;
import com.android.jack.backend.dex.DexWritingException;
import com.android.jack.backend.dex.DexWritingTool;
import com.android.jack.backend.dex.SingleDexOverflowException;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.library.OutputJackLibrary;
import com.android.jack.tools.merger.JackMerger;
import com.android.jack.tools.merger.MergingOverflowException;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.Event;
import com.android.sched.vfs.OutputVFS;
import com.android.sched.vfs.OutputVFile;
import java.util.HashSet;
import javax.annotation.Nonnull;

@ImplementationName(iface=DexWritingTool.class, name="single-dex", description="only emit one dex file")
public class SingleDexWritingTool
extends DexWritingTool {
    @Override
    public void write(@Nonnull OutputVFS outputVDir) throws DexWritingException {
        OutputJackLibrary jackOutputLibrary = Jack.getSession().getJackOutputLibrary();
        HashSet<DexWritingTool.MatchableInputVFile> dexToMerge = new HashSet<DexWritingTool.MatchableInputVFile>();
        for (JDefinedClassOrInterface type : Jack.getSession().getTypesToEmit()) {
            dexToMerge.add(new DexWritingTool.MatchableInputVFile(this.getDexInputVFileOfType(jackOutputLibrary, type)));
        }
        if (this.usePrebuilts) {
            DexWritingTool.addOrphanDexFiles(null, dexToMerge);
        }
        try (Event event = this.tracer.open(JackEventType.DEX_MERGER);){
            JackMerger merger = new JackMerger(this.createDexFile());
            OutputVFile outputDex = this.getOutputDex(outputVDir);
            for (DexWritingTool.MatchableInputVFile matchableVFile : dexToMerge) {
                try {
                    this.mergeDex(merger, matchableVFile.getInputVFile());
                }
                catch (MergingOverflowException e) {
                    throw new DexWritingException(new SingleDexOverflowException(e));
                }
            }
            this.finishMerge(merger, outputDex);
        }
    }

    @Nonnull
    private OutputVFile getOutputDex(@Nonnull OutputVFS outputVDir) throws DexWritingException {
        return this.getOutputDex(outputVDir, 1);
    }
}

