/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.Jack;
import com.android.jack.JackEventType;
import com.android.jack.JackIOException;
import com.android.jack.Options;
import com.android.jack.backend.dex.DexWriter;
import com.android.jack.backend.dex.rop.CodeItemBuilder;
import com.android.jack.dx.dex.DexOptions;
import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.library.FileType;
import com.android.jack.library.FileTypeDoesNotExistException;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.LibraryLocation;
import com.android.jack.library.OutputJackLibrary;
import com.android.jack.library.TypeInInputLibraryLocation;
import com.android.jack.scheduling.marker.ClassDefItemMarker;
import com.android.jack.util.AndroidApiLevel;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.OutputVFile;
import com.android.sched.vfs.VPath;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public abstract class DexInLibraryWriter
extends DexWriter
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    private final OutputJackLibrary outputLibrary = Jack.getSession().getJackOutputLibrary();
    private final boolean forceJumbo = ThreadConfig.get(CodeItemBuilder.FORCE_JUMBO);
    @Nonnull
    private final AndroidApiLevel apiLevel = ThreadConfig.get(Options.ANDROID_MIN_API_LEVEL);
    private final boolean usePrebuilts = ThreadConfig.get(Options.USE_PREBUILT_FROM_LIBRARY);
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        Location loc;
        if (this.usePrebuilts && (loc = type.getLocation()) instanceof TypeInInputLibraryLocation) {
            InputLibrary inputLibrary = ((TypeInInputLibraryLocation)loc).getInputLibrary();
            LibraryLocation inputLibraryLocation = inputLibrary.getLocation();
            if (this.outputLibrary.containsLibraryLocation(inputLibraryLocation)) {
                return;
            }
            try {
                OutputVFile vFile;
                InputVFile in = inputLibrary.getFile(FileType.PREBUILT, new VPath(BinaryQualifiedNameFormatter.getFormatter().getName(type), '/'));
                try {
                    vFile = this.outputLibrary.createFile(FileType.PREBUILT, new VPath(BinaryQualifiedNameFormatter.getFormatter().getName(type), '/'));
                }
                catch (CannotCreateFileException e) {
                    throw new JackIOException("Could not create Dex file in output " + ((LibraryLocation)this.outputLibrary.getLocation()).getDescription() + " for type " + Jack.getUserFriendlyFormatter().getName(type), e);
                }
                try {
                    vFile.copy(in);
                }
                catch (CannotCloseException | CannotReadException | CannotWriteException | WrongPermissionException e) {
                    throw new JackIOException("Could not copy Dex file from " + in.getLocation().getDescription() + " to " + vFile.getLocation().getDescription(), e);
                }
                return;
            }
            catch (FileTypeDoesNotExistException e) {
                // empty catch block
            }
        }
        ClassDefItemMarker cdiMarker = type.getMarker(ClassDefItemMarker.class);
        assert (cdiMarker != null);
        try (Event event = this.tracer.open(JackEventType.DX_BACKEND);){
            OutputVFile vFile;
            DexOptions options = new DexOptions(this.apiLevel, this.forceJumbo);
            DexFile typeDex = new DexFile(options);
            typeDex.add(cdiMarker.getClassDefItem());
            try {
                vFile = this.outputLibrary.createFile(FileType.PREBUILT, new VPath(BinaryQualifiedNameFormatter.getFormatter().getName(type), '/'));
            }
            catch (CannotCreateFileException e) {
                throw new JackIOException("Could not create Dex file in output " + ((LibraryLocation)this.outputLibrary.getLocation()).getDescription() + " for type " + Jack.getUserFriendlyFormatter().getName(type), e);
            }
            try (OutputStream outStream = vFile.getOutputStream();){
                typeDex.getStringIds().intern(DexWriter.getJackDexTag());
                typeDex.prepare();
                typeDex.writeTo(outStream, null, false);
            }
            catch (WrongPermissionException | IOException e) {
                throw new JackIOException("Could not write Dex file to output " + vFile.getLocation().getDescription(), e);
            }
        }
    }
}

