/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.JackAbortException;
import com.android.jack.Options;
import com.android.jack.backend.dex.DexFileProduct;
import com.android.jack.backend.dex.DexWriter;
import com.android.jack.backend.dex.DexWritingException;
import com.android.jack.backend.dex.DexWritingTool;
import com.android.jack.ir.ast.JSession;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.reporting.Reporter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Produce;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.ImplementationPropertyId;
import com.android.sched.vfs.Container;
import com.android.sched.vfs.OutputVFS;
import javax.annotation.Nonnull;

@HasKeyId
@Description(value="Write dex into a file")
@Name(value="DexFileWriter")
@Produce(value={DexFileProduct.class})
public class DexFileWriter
extends DexWriter
implements RunnableSchedulable<JSession> {
    @Nonnull
    static final String DEX_PREFIX = "classes";
    @Nonnull
    public static final String DEX_FILE_EXTENSION = ".dex";
    @Nonnull
    public static final String DEX_FILENAME = "classes.dex";
    @Nonnull
    public static final ImplementationPropertyId<DexWritingTool> DEX_WRITING_POLICY = ((ImplementationPropertyId)ImplementationPropertyId.create("jack.dex.output.policy", "Define which policy will be used to emit dex files", DexWritingTool.class).addDefaultValue("single-dex")).addCategory(DumpInLibrary.class);
    @Nonnull
    private final OutputVFS outputVDir;

    public DexFileWriter() {
        assert (ThreadConfig.get(Options.GENERATE_DEX_FILE).booleanValue());
        Container container = ThreadConfig.get(Options.DEX_OUTPUT_CONTAINER_TYPE);
        this.outputVDir = container == Container.DIR ? ThreadConfig.get(Options.DEX_OUTPUT_DIR) : ThreadConfig.get(Options.DEX_OUTPUT_ZIP);
    }

    @Override
    public void run(@Nonnull JSession session) {
        DexWritingTool writingTool = ThreadConfig.get(DEX_WRITING_POLICY);
        try {
            writingTool.write(this.outputVDir);
        }
        catch (DexWritingException e) {
            session.getReporter().report(Reporter.Severity.FATAL, e);
            throw new JackAbortException(e);
        }
    }
}

