/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.backend.dex.rop.RopHelper;
import com.android.jack.dx.rop.annotation.Annotation;
import com.android.jack.dx.rop.annotation.AnnotationVisibility;
import com.android.jack.dx.rop.annotation.NameValuePair;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstAnnotation;
import com.android.jack.dx.rop.cst.CstArray;
import com.android.jack.dx.rop.cst.CstBoolean;
import com.android.jack.dx.rop.cst.CstByte;
import com.android.jack.dx.rop.cst.CstChar;
import com.android.jack.dx.rop.cst.CstDouble;
import com.android.jack.dx.rop.cst.CstEnumRef;
import com.android.jack.dx.rop.cst.CstFloat;
import com.android.jack.dx.rop.cst.CstInteger;
import com.android.jack.dx.rop.cst.CstKnownNull;
import com.android.jack.dx.rop.cst.CstLong;
import com.android.jack.dx.rop.cst.CstShort;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JByteLiteral;
import com.android.jack.ir.ast.JCharLiteral;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDoubleLiteral;
import com.android.jack.ir.ast.JEnumLiteral;
import com.android.jack.ir.ast.JFloatLiteral;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.ast.JMethodLiteral;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JShortLiteral;
import com.android.jack.ir.ast.JVisitor;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ConstantBuilder {
    @Nonnull
    private final Visitor constantBuilder = new Visitor();

    @Nonnull
    public Constant parseLiteral(@Nonnull JLiteral literal) {
        this.constantBuilder.result = null;
        this.constantBuilder.accept(literal);
        Constant constant = this.constantBuilder.result;
        assert (constant != null);
        return constant;
    }

    public void createAnnotationPairs(@Nonnull JAnnotation annotation, @Nonnull Annotation ropAnnotation) {
        for (JNameValuePair jPair : annotation.getNameValuePairs()) {
            ropAnnotation.add(new NameValuePair(RopHelper.createString(jPair.getName()), this.parseLiteral(jPair.getValue())));
        }
    }

    private class Visitor
    extends JVisitor {
        @CheckForNull
        private Constant result;

        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JAnnotation annotation) {
            Annotation ropAnnotation = new Annotation(RopHelper.convertTypeToDx(annotation.getType()), AnnotationVisibility.EMBEDDED);
            ConstantBuilder.this.createAnnotationPairs(annotation, ropAnnotation);
            ropAnnotation.setImmutable();
            CstAnnotation cstAnnotation = new CstAnnotation(ropAnnotation);
            this.result = cstAnnotation;
            return false;
        }

        @Override
        public boolean visit(@Nonnull JArrayLiteral array) {
            List<JLiteral> literals = array.getValues();
            CstArray.List constants = new CstArray.List(literals.size());
            int i = 0;
            for (JLiteral literal : literals) {
                this.result = null;
                this.accept(literal);
                assert (this.result != null);
                constants.set(i, this.result);
                ++i;
            }
            constants.setImmutable();
            this.result = new CstArray(constants);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JEnumLiteral literal) {
            this.result = new CstEnumRef(new CstString(literal.getFieldId().getName()), RopHelper.convertTypeToDx(literal.getType()));
            return false;
        }

        @Override
        public boolean visit(@Nonnull JClassLiteral literal) {
            this.result = RopHelper.convertTypeToDx(literal.getRefType());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JMethodLiteral x) {
            this.result = RopHelper.createMethodRef(x.getMethod());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JCharLiteral literal) {
            this.result = CstChar.make(literal.getValue());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JBooleanLiteral literal) {
            this.result = CstBoolean.make(literal.getValue());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JByteLiteral literal) {
            this.result = CstByte.make(literal.getValue());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JShortLiteral literal) {
            this.result = CstShort.make(literal.getValue());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JIntLiteral literal) {
            this.result = CstInteger.make(literal.getValue());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JLongLiteral literal) {
            this.result = CstLong.make(literal.getValue());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JFloatLiteral literal) {
            this.result = CstFloat.make(Float.floatToIntBits(literal.getValue()));
            return false;
        }

        @Override
        public boolean visit(@Nonnull JDoubleLiteral literal) {
            this.result = CstDouble.make(Double.doubleToLongBits(literal.getValue()));
            return false;
        }

        @Override
        public boolean visit(@Nonnull JAbstractStringLiteral literal) {
            this.result = RopHelper.createString(literal);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JNullLiteral literal) {
            this.result = CstKnownNull.THE_ONE;
            return false;
        }
    }
}

