/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.Options;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.Resource;
import com.android.jack.reporting.ReportableIOException;
import com.android.jack.reporting.Reporter;
import com.android.jack.scheduling.feature.Resources;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.vfs.Container;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.OutputVFS;
import com.android.sched.vfs.OutputVFile;
import com.android.sched.vfs.VPath;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Writer of resources")
@Name(value="ResourceWriter")
@Support(value={Resources.class})
public class ResourceWriter
implements RunnableSchedulable<JSession> {
    @Nonnull
    private final OutputVFS outputVDir;

    public ResourceWriter() {
        assert (ThreadConfig.get(Options.GENERATE_DEX_FILE).booleanValue());
        Container containerType = ThreadConfig.get(Options.DEX_OUTPUT_CONTAINER_TYPE);
        this.outputVDir = containerType == Container.DIR ? ThreadConfig.get(Options.DEX_OUTPUT_DIR) : ThreadConfig.get(Options.DEX_OUTPUT_ZIP);
    }

    @Override
    public void run(@Nonnull JSession session) {
        assert (this.outputVDir != null);
        List<Resource> resources = session.getResources();
        for (Resource resource : resources) {
            InputVFile inputFile = resource.getVFile();
            VPath path = resource.getPath();
            try {
                OutputVFile outputFile = this.outputVDir.getRootDir().createOutputVFile(path);
                outputFile.copy(inputFile);
            }
            catch (CannotCloseException | CannotCreateFileException | CannotReadException | CannotWriteException | WrongPermissionException e) {
                ReportableIOException reportable = new ReportableIOException("Dex resource writing", e);
                Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
        }
    }
}

