/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.api.v02.impl;

import com.android.jack.Options;
import com.android.jack.VerbosityLevel;
import com.android.jack.api.v01.ConfigurationException;
import com.android.jack.api.v01.impl.Api01ConfigImpl;
import com.android.jack.api.v02.Api02Config;
import com.android.jack.api.v02.JavaSourceVersion;
import com.android.jack.config.id.JavaVersionPropertyId;
import java.io.File;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class Api02ConfigImpl
extends Api01ConfigImpl
implements Api02Config {
    @Override
    public void setJavaSourceVersion(@Nonnull JavaSourceVersion javaSourceVersion) throws ConfigurationException {
        JavaVersionPropertyId.JavaVersion javaSourceVersionWrapped = null;
        switch (javaSourceVersion) {
            case JAVA_3: {
                javaSourceVersionWrapped = JavaVersionPropertyId.JavaVersion.JAVA_3;
                break;
            }
            case JAVA_4: {
                javaSourceVersionWrapped = JavaVersionPropertyId.JavaVersion.JAVA_4;
                break;
            }
            case JAVA_5: {
                javaSourceVersionWrapped = JavaVersionPropertyId.JavaVersion.JAVA_5;
                break;
            }
            case JAVA_6: {
                javaSourceVersionWrapped = JavaVersionPropertyId.JavaVersion.JAVA_6;
                break;
            }
            case JAVA_7: {
                javaSourceVersionWrapped = JavaVersionPropertyId.JavaVersion.JAVA_7;
                break;
            }
            case JAVA_8: {
                javaSourceVersionWrapped = JavaVersionPropertyId.JavaVersion.JAVA_8;
                break;
            }
            default: {
                throw new ConfigurationException("Java source version '" + javaSourceVersion.toString() + "' is unsupported");
            }
        }
        this.options.addProperty(Options.JAVA_SOURCE_VERSION.getName(), javaSourceVersionWrapped.toString());
    }

    @Override
    public void setVerbosityLevel(@Nonnull com.android.jack.api.v02.VerbosityLevel verbosityLevel) throws ConfigurationException {
        VerbosityLevel jackVerbosityLevel;
        switch (verbosityLevel) {
            case ERROR: {
                jackVerbosityLevel = VerbosityLevel.ERROR;
                break;
            }
            case INFO: {
                jackVerbosityLevel = VerbosityLevel.INFO;
                break;
            }
            case WARNING: {
                jackVerbosityLevel = VerbosityLevel.WARNING;
                break;
            }
            default: {
                throw new ConfigurationException("Verbosity level '" + verbosityLevel.toString() + "' is unsupported");
            }
        }
        this.options.setVerbosityLevel(jackVerbosityLevel);
    }

    @Override
    public void setBaseDirectory(@Nonnull File baseDir) {
        this.options.setWorkingDirectory(baseDir);
    }

    @Override
    public void setAndroidMinApiLevel(@Nonnegative int level) {
        this.options.addProperty(Options.ANDROID_MIN_API_LEVEL.getName(), Integer.toString(level));
    }
}

