/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.tracer;

import com.android.jack.analysis.tracer.TracerBrush;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import java.util.BitSet;
import java.util.Stack;
import javax.annotation.Nonnull;

public class ComposedTracerBrush
implements TracerBrush {
    @Nonnull
    private final TracerBrush[] brushes;
    @Nonnull
    private final Stack<BitSet> composedStatus = new Stack();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ComposedTracerBrush(@Nonnull TracerBrush[] brushes) {
        this.brushes = brushes;
        BitSet initialAllEnabled = new BitSet(brushes.length);
        initialAllEnabled.set(0, brushes.length);
        this.composedStatus.push(initialAllEnabled);
    }

    @Override
    public boolean startTrace(@Nonnull JDefinedClassOrInterface type) {
        boolean status = false;
        BitSet currentStatus = this.composedStatus.peek();
        BitSet nextStatus = new BitSet(this.brushes.length);
        for (int i = 0; i < this.brushes.length; ++i) {
            boolean b = currentStatus.get(i) && this.brushes[i].startTrace(type);
            nextStatus.set(i, b);
            status |= b;
        }
        if (status) {
            this.composedStatus.push(nextStatus);
        }
        return status;
    }

    @Override
    public void endTrace(@Nonnull JDefinedClassOrInterface type) {
        this.composedStatus.pop();
        for (TracerBrush brush : this.brushes) {
            brush.endTrace(type);
        }
    }

    @Override
    public boolean startTrace(@Nonnull JMethod method) {
        boolean status = false;
        BitSet currentStatus = this.composedStatus.peek();
        BitSet nextStatus = new BitSet(this.brushes.length);
        for (int i = 0; i < this.brushes.length; ++i) {
            boolean b = currentStatus.get(i) && this.brushes[i].startTrace(method);
            nextStatus.set(i, b);
            status |= b;
        }
        if (status) {
            this.composedStatus.push(nextStatus);
        }
        return status;
    }

    @Override
    public void endTrace(@Nonnull JMethod method) {
        this.composedStatus.pop();
        for (TracerBrush brush : this.brushes) {
            brush.endTrace(method);
        }
    }

    @Override
    public boolean startTrace(@Nonnull JField field) {
        boolean status = false;
        BitSet currentStatus = this.composedStatus.peek();
        BitSet nextStatus = new BitSet(this.brushes.length);
        for (int i = 0; i < this.brushes.length; ++i) {
            boolean b = currentStatus.get(i) && this.brushes[i].startTrace(field);
            nextStatus.set(i, b);
            status |= b;
        }
        if (status) {
            this.composedStatus.push(nextStatus);
        }
        return status;
    }

    @Override
    public void endTrace(@Nonnull JField field) {
        this.composedStatus.pop();
        for (TracerBrush brush : this.brushes) {
            brush.endTrace(field);
        }
    }

    @Override
    public boolean startTraceOverridingMethod(@Nonnull JMethod method) {
        boolean status = false;
        BitSet currentStatus = this.composedStatus.peek();
        BitSet nextStatus = new BitSet(this.brushes.length);
        for (int i = 0; i < this.brushes.length; ++i) {
            boolean b = currentStatus.get(i) && this.brushes[i].startTraceOverridingMethod(method);
            nextStatus.set(i, b);
            status |= b;
        }
        if (status) {
            this.composedStatus.push(nextStatus);
        }
        return status;
    }

    @Override
    public void endTraceOverridingMethod(@Nonnull JMethod method) {
        this.composedStatus.pop();
        for (TracerBrush brush : this.brushes) {
            brush.endTraceOverridingMethod(method);
        }
    }

    @Override
    public void setMustTraceOverridingMethods(@Nonnull JMethod method) {
        BitSet currentStatus = this.composedStatus.peek();
        for (int i = 0; i < this.brushes.length; ++i) {
            if (!currentStatus.get(i)) continue;
            this.brushes[i].setMustTraceOverridingMethods(method);
        }
    }

    @Override
    public boolean traceMarked(@Nonnull JNode node) {
        boolean isMarked = false;
        BitSet currentStatus = this.composedStatus.peek();
        BitSet nextStatus = new BitSet(this.brushes.length);
        for (int i = 0; i < this.brushes.length; ++i) {
            boolean b = currentStatus.get(i) && this.brushes[i].traceMarked(node);
            nextStatus.set(i, b);
            isMarked |= b;
        }
        if (isMarked) {
            this.composedStatus.push(nextStatus);
        }
        return isMarked;
    }

    @Override
    public boolean startTraceEnclosingMethod() {
        boolean startTrace = false;
        BitSet currentStatus = this.composedStatus.peek();
        BitSet nextStatus = new BitSet(this.brushes.length);
        for (int i = 0; i < this.brushes.length; ++i) {
            boolean b = currentStatus.get(i) && this.brushes[i].startTraceEnclosingMethod();
            nextStatus.set(i, b);
            startTrace |= b;
        }
        if (startTrace) {
            this.composedStatus.push(nextStatus);
        }
        return startTrace;
    }

    @Override
    public void endTraceEnclosingMethod() {
        this.composedStatus.pop();
        for (TracerBrush brush : this.brushes) {
            brush.endTraceEnclosingMethod();
        }
    }

    @Override
    public void endTraceMarked(@Nonnull JNode node) {
        this.composedStatus.pop();
        for (TracerBrush brush : this.brushes) {
            brush.endTraceMarked(node);
        }
    }

    @Override
    public boolean startTraceSeed(@Nonnull JDefinedClassOrInterface type) {
        boolean status = false;
        BitSet currentStatus = this.composedStatus.peek();
        BitSet nextStatus = new BitSet(this.brushes.length);
        for (int i = 0; i < this.brushes.length; ++i) {
            boolean b = currentStatus.get(i) && this.brushes[i].startTraceSeed(type);
            nextStatus.set(i, b);
            status |= b;
        }
        if (status) {
            this.composedStatus.push(nextStatus);
        }
        return status;
    }

    @Override
    public void endTraceSeed(@Nonnull JDefinedClassOrInterface type) {
        this.composedStatus.pop();
        for (TracerBrush brush : this.brushes) {
            brush.endTraceSeed(type);
        }
    }

    @Override
    public boolean startTraceSeed(@Nonnull JMethod method) {
        boolean status = false;
        BitSet currentStatus = this.composedStatus.peek();
        BitSet nextStatus = new BitSet(this.brushes.length);
        for (int i = 0; i < this.brushes.length; ++i) {
            boolean b = currentStatus.get(i) && this.brushes[i].startTraceSeed(method);
            nextStatus.set(i, b);
            status |= b;
        }
        if (status) {
            this.composedStatus.push(nextStatus);
        }
        return status;
    }

    @Override
    public void endTraceSeed(@Nonnull JMethod method) {
        this.composedStatus.pop();
        for (TracerBrush brush : this.brushes) {
            brush.endTraceSeed(method);
        }
    }

    @Override
    public boolean startTraceSeed(@Nonnull JField field) {
        boolean status = false;
        BitSet currentStatus = this.composedStatus.peek();
        BitSet nextStatus = new BitSet(this.brushes.length);
        for (int i = 0; i < this.brushes.length; ++i) {
            boolean b = currentStatus.get(i) && this.brushes[i].startTraceSeed(field);
            nextStatus.set(i, b);
            status |= b;
        }
        if (status) {
            this.composedStatus.push(nextStatus);
        }
        return status;
    }

    @Override
    public void endTraceSeed(@Nonnull JField field) {
        this.composedStatus.pop();
        for (TracerBrush brush : this.brushes) {
            brush.endTraceSeed(field);
        }
    }
}

