/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis;

import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JExceptionRuntimeValue;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Marker used to represent a variable definition his usage.")
@ValidOn(value={JAsgOperation.class, JParameter.class, JThis.class})
public class DefinitionMarker
implements Marker {
    @Nonnull
    private final JNode definition;
    @Nonnull
    final List<JVariableRef> uses;
    @Nonnull
    private JVariable definedVariable;
    @Nonnegative
    private int bitSetIdx;

    public DefinitionMarker(@Nonnull JNode definition) {
        this.definition = definition;
        this.uses = new ArrayList<JVariableRef>();
        if (definition instanceof JAsgOperation) {
            JExpression lhsExpr = ((JAsgOperation)definition).getLhs();
            assert (lhsExpr instanceof JVariableRef);
            this.definedVariable = ((JVariableRef)lhsExpr).getTarget();
        } else {
            assert (definition instanceof JParameter || definition instanceof JThis);
            this.definedVariable = (JVariable)definition;
        }
    }

    @Override
    public Marker cloneIfNeeded() {
        throw new AssertionError((Object)"It is not valid to use cloneIfNeeded, create a new marker.");
    }

    public void resetDefinedVariable(@Nonnull JVariable var) {
        this.definedVariable = var;
    }

    public boolean isUnused() {
        return this.uses.isEmpty();
    }

    public boolean isUsedOnlyOnce() {
        return this.uses.size() == 1;
    }

    @Nonnull
    public List<JVariableRef> getUses() {
        return new ArrayList<JVariableRef>(this.uses);
    }

    public void removeUse(@Nonnull JVariableRef use) {
        assert (this.uses.contains(use));
        this.uses.remove(use);
        this.removeDefFromUseDefsChain(use);
    }

    public void addUse(@Nonnull JVariableRef use) {
        assert (!this.uses.contains(use));
        this.uses.add(use);
        UseDefsMarker udm = use.getMarker(UseDefsMarker.class);
        assert (udm != null);
        udm.defs.add(this);
    }

    public void removeAllUses() {
        for (JVariableRef useOfDef : this.uses) {
            this.removeDefFromUseDefsChain(useOfDef);
        }
        this.uses.clear();
    }

    public void clearUses() {
        this.uses.clear();
    }

    public boolean hasValue() {
        if (this.definition instanceof JAsgOperation) {
            JExpression rhsExpr = ((JAsgOperation)this.definition).getRhs();
            return !(rhsExpr instanceof JExceptionRuntimeValue);
        }
        assert (this.definition instanceof JParameter || this.definition instanceof JThis);
        return false;
    }

    @Nonnull
    public JNode getDefinedExpr() {
        if (this.definition instanceof JAsgOperation) {
            JExpression lhsExpr = ((JAsgOperation)this.definition).getLhs();
            assert (lhsExpr instanceof JVariableRef);
            return lhsExpr;
        }
        assert (this.definition instanceof JParameter || this.definition instanceof JThis);
        return this.definition;
    }

    @Nonnull
    public JVariable getDefinedVariable() {
        return this.definedVariable;
    }

    @Nonnull
    public JExpression getValue() {
        assert (this.hasValue());
        return ((JAsgOperation)this.definition).getRhs();
    }

    public void setBitSetIdx(@Nonnegative int bitSetIdx) {
        this.bitSetIdx = bitSetIdx;
    }

    @Nonnegative
    public int getBitSetIdx() {
        return this.bitSetIdx;
    }

    public String toString() {
        return this.definition.toString();
    }

    @Nonnull
    public JNode getDefinition() {
        return this.definition;
    }

    @CheckForNull
    public JStatement getStatement() {
        try {
            return this.definition.getParent(JExpressionStatement.class);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private void removeDefFromUseDefsChain(@Nonnull JVariableRef use) {
        UseDefsMarker udm = use.getMarker(UseDefsMarker.class);
        assert (udm != null);
        udm.defs.remove(this);
    }
}

