/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack;

import com.android.jack.reporting.Reportable;
import com.android.sched.util.codec.VariableName;
import javax.annotation.Nonnull;

@VariableName(value="level")
public enum VerbosityLevel {
    ERROR("error"),
    WARNING("warning"),
    INFO("info"),
    DEBUG("debug"),
    TRACE("trace");

    @Nonnull
    private final String id;

    private VerbosityLevel(String id) {
        this.id = id;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    static class DeprecatedVerbosity
    implements Reportable {
        @Nonnull
        private final VerbosityLevel verbosity;

        DeprecatedVerbosity(@Nonnull VerbosityLevel verbosity) {
            this.verbosity = verbosity;
        }

        @Override
        @Nonnull
        public String getMessage() {
            return "Verbosity level '" + this.verbosity.name().toLowerCase() + "' is deprecated";
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.WARNING;
        }
    }
}

