/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ConditionalBasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.cfg.PeiBasicBlock;
import com.android.jack.cfg.ReturnBasicBlock;
import com.android.jack.cfg.SwitchBasicBlock;
import com.android.jack.coverage.CodeCoverageFeature;
import com.android.jack.coverage.CodeCoverageLookupException;
import com.android.jack.coverage.CodeCoverageMarker;
import com.android.jack.coverage.JacocoPackage;
import com.android.jack.coverage.ProbeDescription;
import com.android.jack.coverage.ProbeMarker;
import com.android.jack.digest.SourceDigestAdder;
import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JEqOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JPackageLookupException;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JStatementList;
import com.android.jack.ir.ast.JStringLiteral;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.ast.MissingJTypeLookupException;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.ir.formatter.TypeFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JLookup;
import com.android.jack.lookup.JLookupException;
import com.android.jack.lookup.JNodeLookup;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.ReportableException;
import com.android.jack.reporting.Reporter;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.ast.NoImplicitBlock;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.AppendField;
import com.android.jack.transformations.request.AppendMethod;
import com.android.jack.transformations.request.AppendStatement;
import com.android.jack.transformations.request.PrependAfter;
import com.android.jack.transformations.request.PrependStatement;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.request.TransformationStep;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.collect.Lists;
import com.android.sched.util.config.ThreadConfig;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Instruments classes for code coverage")
@Support(value={CodeCoverageFeature.class})
@Constraint(need={CodeCoverageMarker.Analyzed.class, ProbeMarker.class, ControlFlowGraph.class, ThreeAddressCodeForm.class, NoImplicitBlock.class})
@Transform(add={CodeCoverageMarker.Complete.class, JField.class, JFieldRef.class, JMethod.class, JMethodCall.class, JMethodBody.class, JBlock.class, JLocal.class, JLocalRef.class, JExpressionStatement.class, JAsgOperation.NonReusedAsg.class, JIntLiteral.class, JLongLiteral.class, JStringLiteral.class, JIfStatement.class, JEqOperation.class, JNullLiteral.class, JReturnStatement.class}, remove={ProbeMarker.class})
@Filter(value={TypeWithoutPrebuiltFilter.class})
public class CodeCoverageTransformer
extends SourceDigestAdder
implements RunnableSchedulable<JDefinedClassOrInterface> {
    private static final String COVERAGE_DATA_FIELD_NAME = NamingTools.getNonSourceConflictingName((String)"jacocoData");
    private static final int CLASS_COVERAGE_DATA_FIELD_MODIFIERS = 4250;
    private static final int INTERFACE_COVERAGE_DATA_FIELD_MODIFIERS = 4121;
    private static final String COVERAGE_DATA_INIT_METHOD_NAME = NamingTools.getNonSourceConflictingName((String)"jacocoInit");
    private static final int COVERAGE_DATA_INIT_METHOD_MODIFIERS = 4106;
    private static final String LOCAL_VAR_NAME_PREFIX = "cov";
    @Nonnull
    private final TypeFormatter binaryTypeFormatter = BinaryQualifiedNameFormatter.getFormatter();
    @CheckForNull
    private JDefinedClass jacocoProbesClass = null;
    @CheckForNull
    private JMethodId jacocoProbesMethod = null;
    @Nonnull
    private static final String JACOCO_RUNTIME_CLASS_NAME = "Offline";

    @Nonnull
    private static JPackage lookupJacocoRuntimePackage(@Nonnull JLookup lookup) throws JacocoPackageNotFoundException {
        JacocoPackage jacocoPackage = (JacocoPackage)ThreadConfig.get(CodeCoverageFeature.COVERAGE_JACOCO_PACKAGE_NAME);
        String jacocoPackageName = jacocoPackage.getPackageName();
        if (!jacocoPackageName.isEmpty()) {
            String packageString = NamingTools.getBinaryName((String)jacocoPackageName);
            try {
                return lookup.getPackage(packageString);
            }
            catch (JPackageLookupException e) {
                throw new JacocoPackageNotFoundException("Cannot find Jacoco package " + jacocoPackageName, e);
            }
        }
        String parentPackageName = NamingTools.getBinaryName((String)"org.jacoco.agent.rt");
        JPackageLookupException lookupFailureCause = null;
        try {
            JPackage parentPackage = lookup.getPackage(parentPackageName);
            for (JPackage p : parentPackage.getSubPackages()) {
                if (!p.getName().startsWith("internal")) continue;
                return p;
            }
        }
        catch (JPackageLookupException e) {
            lookupFailureCause = e;
        }
        throw new JacocoPackageNotFoundException("Cannot find any Jacoco package org.jacoco.agent.rt.internal*", lookupFailureCause);
    }

    @Nonnull
    private synchronized JDefinedClass lookupJacocoOfflineClass(@Nonnull JLookup lookup) {
        if (this.jacocoProbesClass == null) {
            JDefinedClassOrInterface clOrI;
            JPackage jacocoRuntimePackage;
            try {
                jacocoRuntimePackage = CodeCoverageTransformer.lookupJacocoRuntimePackage(lookup);
            }
            catch (JacocoPackageNotFoundException e) {
                CodeCoverageLookupException cle = new CodeCoverageLookupException(e.getMessage(), e);
                Jack.getSession().getReporter().report(Reporter.Severity.FATAL, (Reportable)cle);
                throw new JackAbortException((ReportableException)cle);
            }
            try {
                clOrI = jacocoRuntimePackage.getType(JACOCO_RUNTIME_CLASS_NAME);
                if (!(clOrI instanceof JDefinedClass)) {
                    throw new MissingJTypeLookupException(jacocoRuntimePackage, JACOCO_RUNTIME_CLASS_NAME);
                }
            }
            catch (JLookupException e) {
                CodeCoverageLookupException cle = new CodeCoverageLookupException(e.getMessage(), e);
                Jack.getSession().getReporter().report(Reporter.Severity.FATAL, (Reportable)cle);
                throw new JackAbortException((ReportableException)cle);
            }
            this.jacocoProbesClass = (JDefinedClass)clOrI;
        }
        return this.jacocoProbesClass;
    }

    @Nonnull
    private synchronized JMethodId lookupJacocoProbesMethod(@Nonnull JLookup lookup, @Nonnull JType classIdType, @Nonnull JType classNameType, @Nonnull JType probeCountType, @Nonnull JType probeArrayType) {
        if (this.jacocoProbesMethod == null) {
            JDefinedClass jacocoClass = this.lookupJacocoOfflineClass(lookup);
            List argsTypes = Lists.create((Object[])new JType[]{classIdType, classNameType, probeCountType});
            this.jacocoProbesMethod = jacocoClass.getMethodId("getProbes", argsTypes, MethodKind.STATIC, probeArrayType);
        }
        return this.jacocoProbesMethod;
    }

    private long computeClassID(@Nonnull JDefinedClassOrInterface declaredType) {
        byte[] digest = this.computeSourceDigest(declaredType).digest();
        BigInteger bigInteger = new BigInteger(digest);
        return bigInteger.longValue();
    }

    public void run(@Nonnull JDefinedClassOrInterface declaredType) {
        CodeCoverageMarker marker = (CodeCoverageMarker)declaredType.getMarker(CodeCoverageMarker.class);
        if (marker == null || marker.getProbes().isEmpty()) {
            return;
        }
        long classID = this.computeClassID(declaredType);
        marker.setClassId(classID);
        TransformationRequest transformationRequest = new TransformationRequest((JNode)declaredType);
        JField coverageDataField = this.createProbesArrayField(declaredType);
        transformationRequest.append((TransformationStep)new AppendField(declaredType, coverageDataField));
        JMethod coverageInitMethod = this.createProbesArrayInitMethod(declaredType, marker.getNumberOfProbes(), transformationRequest, coverageDataField, classID);
        marker.setInitMethod(coverageInitMethod);
        transformationRequest.append((TransformationStep)new AppendMethod(declaredType, coverageInitMethod));
        new TransformerVisitor(coverageInitMethod, transformationRequest).accept(declaredType.getMethods());
        transformationRequest.commit();
    }

    @Nonnull
    private JField createProbesArrayField(@Nonnull JDefinedClassOrInterface declaredType) {
        JType booleanArrayType = CodeCoverageTransformer.getCoverageDataType();
        int modifiers = declaredType instanceof JInterface ? 4121 : 4250;
        return new JField(SourceInfo.UNKNOWN, COVERAGE_DATA_FIELD_NAME, declaredType, booleanArrayType, modifiers);
    }

    @Nonnull
    private JMethod createProbesArrayInitMethod(@Nonnull JDefinedClassOrInterface declaredType, @Nonnegative int probeCount, @Nonnull TransformationRequest transformationRequest, @Nonnull JField coverageDataField, long classId) {
        JType returnType = CodeCoverageTransformer.getCoverageDataType();
        JMethodId methodId = new JMethodId(new JMethodIdWide(COVERAGE_DATA_INIT_METHOD_NAME, MethodKind.STATIC), returnType);
        JMethod coverageInitMethod = new JMethod(SourceInfo.UNKNOWN, methodId, declaredType, 4106);
        this.fillCoverageInitMethodBody(coverageInitMethod, declaredType, probeCount, transformationRequest, coverageDataField, classId);
        return coverageInitMethod;
    }

    private void fillCoverageInitMethodBody(@Nonnull JMethod coverageInitMethod, @Nonnull JDefinedClassOrInterface declaredType, @Nonnegative int probeCount, @Nonnull TransformationRequest transformationRequest, @Nonnull JField coverageDataField, long classId) {
        JType coverageDataType = coverageDataField.getType();
        assert (coverageDataType.equals(JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType().getArray()));
        assert (coverageDataField.getEnclosingType().equals(declaredType));
        JBlock block = new JBlock(coverageInitMethod.getSourceInfo());
        coverageInitMethod.setBody((JAbstractMethodBody)new JMethodBody(block.getSourceInfo(), block));
        JNodeLookup lookup = Jack.getSession().getLookup();
        JDefinedClass jacocoClass = this.lookupJacocoOfflineClass((JLookup)lookup);
        JPrimitiveType classIdType = JPrimitiveType.JPrimitiveTypeEnum.LONG.getType();
        JType classNameType = lookup.getType(CommonTypes.CommonType.STRING);
        JPrimitiveType probeCountType = JPrimitiveType.JPrimitiveTypeEnum.INT.getType();
        JMethodId jacocoMethodId = this.lookupJacocoProbesMethod((JLookup)lookup, (JType)classIdType, classNameType, (JType)probeCountType, coverageDataType);
        LocalVarCreator localVarCreator = new LocalVarCreator(coverageInitMethod, LOCAL_VAR_NAME_PREFIX);
        JLocal coverageDataLocal = localVarCreator.createTempLocal(coverageDataType, block.getSourceInfo(), transformationRequest);
        JStatement coverageDataLocalInit = CodeCoverageTransformer.createLocalAssignStatement(coverageDataLocal, (JExpression)new JFieldRef(coverageDataLocal.getSourceInfo(), null, coverageDataField.getId(), (JClassOrInterface)declaredType));
        transformationRequest.append((TransformationStep)new AppendStatement((JStatementList)block, coverageDataLocalInit));
        JBlock ifBlock = new JBlock(block.getSourceInfo());
        JLocal classIdLocal = localVarCreator.createTempLocal((JType)classIdType, ifBlock.getSourceInfo(), transformationRequest);
        JLocal classNameLocal = localVarCreator.createTempLocal(classNameType, ifBlock.getSourceInfo(), transformationRequest);
        JLocal probeCountLocal = localVarCreator.createTempLocal((JType)probeCountType, ifBlock.getSourceInfo(), transformationRequest);
        JStatement classIdInit = CodeCoverageTransformer.createLocalAssignStatement(classIdLocal, (JExpression)new JLongLiteral(classIdLocal.getSourceInfo(), classId));
        String className = this.binaryTypeFormatter.getName((JType)declaredType);
        JStatement classNameInit = CodeCoverageTransformer.createLocalAssignStatement(classNameLocal, (JExpression)new JStringLiteral(classNameLocal.getSourceInfo(), className));
        JStatement probeCountInit = CodeCoverageTransformer.createLocalAssignStatement(probeCountLocal, (JExpression)new JIntLiteral(probeCountLocal.getSourceInfo(), probeCount));
        transformationRequest.append((TransformationStep)new AppendStatement((JStatementList)ifBlock, classIdInit));
        transformationRequest.append((TransformationStep)new AppendStatement((JStatementList)ifBlock, classNameInit));
        transformationRequest.append((TransformationStep)new AppendStatement((JStatementList)ifBlock, probeCountInit));
        JMethodCall methodCall = new JMethodCall(ifBlock.getSourceInfo(), null, (JClassOrInterface)jacocoClass, jacocoMethodId, false);
        methodCall.addArg((JExpression)classIdLocal.makeRef(ifBlock.getSourceInfo()));
        methodCall.addArg((JExpression)classNameLocal.makeRef(ifBlock.getSourceInfo()));
        methodCall.addArg((JExpression)probeCountLocal.makeRef(ifBlock.getSourceInfo()));
        JStatement assignLocal = CodeCoverageTransformer.createLocalAssignStatement(coverageDataLocal, (JExpression)methodCall);
        transformationRequest.append((TransformationStep)new AppendStatement((JStatementList)ifBlock, assignLocal));
        JFieldRef putFieldRef = new JFieldRef(ifBlock.getSourceInfo(), null, coverageDataField.getId(), (JClassOrInterface)coverageDataField.getEnclosingType());
        JAsgOperation assignField = new JAsgOperation(putFieldRef.getSourceInfo(), (JExpression)putFieldRef, (JExpression)coverageDataLocal.makeRef(putFieldRef.getSourceInfo()));
        transformationRequest.append((TransformationStep)new AppendStatement((JStatementList)ifBlock, (JStatement)new JExpressionStatement(assignField.getSourceInfo(), (JExpression)assignField)));
        JEqOperation condition = new JEqOperation(block.getSourceInfo(), (JExpression)coverageDataLocal.makeRef(block.getSourceInfo()), (JExpression)new JNullLiteral(block.getSourceInfo()));
        JIfStatement ifStatement = new JIfStatement(condition.getSourceInfo(), (JExpression)condition, (JStatement)ifBlock, null);
        transformationRequest.append((TransformationStep)new AppendStatement((JStatementList)block, (JStatement)ifStatement));
        JReturnStatement returnStatement = new JReturnStatement(block.getSourceInfo(), (JExpression)coverageDataLocal.makeRef(block.getSourceInfo()));
        transformationRequest.append((TransformationStep)new AppendStatement((JStatementList)block, (JStatement)returnStatement));
    }

    @Nonnull
    private static JStatement createLocalAssignStatement(@Nonnull JLocal local, @Nonnull JExpression expr) {
        JLocalRef localRef = local.makeRef(local.getSourceInfo());
        JAsgOperation assign = new JAsgOperation(local.getSourceInfo(), (JExpression)localRef, expr);
        return assign.makeStatement();
    }

    @Nonnull
    private static JType getCoverageDataType() {
        return JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType().getArray();
    }

    private static class TransformerVisitor
    extends JVisitor {
        @Nonnull
        private final JMethod coverageMethod;
        @Nonnull
        private final TransformationRequest transformationRequest;
        @CheckForNull
        private LocalVarCreator localVarCreator;
        @CheckForNull
        private JLocal coverageProbesArrayLocal;

        public TransformerVisitor(@Nonnull JMethod initMethod, @Nonnull TransformationRequest transformationRequest) {
            this.transformationRequest = transformationRequest;
            this.coverageMethod = initMethod;
        }

        private static boolean canInsertProbeBeforeLastStatement(@Nonnull BasicBlock bb) {
            if (bb instanceof PeiBasicBlock) {
                return true;
            }
            if (bb instanceof ReturnBasicBlock) {
                return true;
            }
            if (bb instanceof ConditionalBasicBlock || bb instanceof SwitchBasicBlock) {
                return true;
            }
            assert (!bb.getStatements().isEmpty()) : "there is no statement in block " + bb.getId();
            JStatement lastStmt = bb.getLastInstruction();
            assert (lastStmt != null);
            return lastStmt instanceof JGoto;
        }

        public boolean visit(@Nonnull JMethod m) {
            if (m.isNative() || m.isAbstract()) {
                return false;
            }
            if (m.getBody() == null || !(m.getBody() instanceof JMethodBody)) {
                return false;
            }
            this.localVarCreator = new LocalVarCreator(m, CodeCoverageTransformer.LOCAL_VAR_NAME_PREFIX);
            JMethodBody methodBody = (JMethodBody)m.getBody();
            assert (methodBody != null);
            this.coverageProbesArrayLocal = this.insertCoverageLocal(methodBody, this.coverageMethod, this.coverageMethod.getSourceInfo());
            ControlFlowGraph controlFlowGraph = (ControlFlowGraph)m.getMarker(ControlFlowGraph.class);
            assert (controlFlowGraph != null);
            for (BasicBlock bb : controlFlowGraph.getNodes()) {
                ProbeMarker probeMarker = (ProbeMarker)bb.removeMarker(ProbeMarker.class);
                if (probeMarker == null) continue;
                assert (!bb.getStatements().isEmpty());
                JStatement insertionPoint = bb.getLastInstruction();
                ProbeDescription probe = probeMarker.getProbe();
                JStatement probeStatement = this.createProbeStatement(insertionPoint.getSourceInfo(), probe);
                Object transformationStep = TransformerVisitor.canInsertProbeBeforeLastStatement(bb) ? new AppendBefore((JNode)insertionPoint, (JNode)probeStatement) : new PrependAfter((JNode)insertionPoint, (JNode)probeStatement);
                this.transformationRequest.append((TransformationStep)transformationStep);
            }
            return false;
        }

        private JLocal insertCoverageLocal(@Nonnull JMethodBody x, @Nonnull JMethod coverageMethod, @Nonnull SourceInfo sourceInfo) {
            JType booleanArrayType = coverageMethod.getType();
            assert (this.localVarCreator != null);
            JLocal local = this.localVarCreator.createTempLocal(booleanArrayType, sourceInfo, this.transformationRequest);
            JLocalRef localRef = local.makeRef(sourceInfo);
            JMethodCall expr = new JMethodCall(sourceInfo, null, (JClassOrInterface)coverageMethod.getEnclosingType(), coverageMethod.getMethodId(), false);
            JAsgOperation assign = new JAsgOperation(sourceInfo, (JExpression)localRef, (JExpression)expr);
            this.transformationRequest.append((TransformationStep)new PrependStatement((JStatementList)x.getBlock(), (JStatement)new JExpressionStatement(sourceInfo, (JExpression)assign)));
            return local;
        }

        @Nonnull
        private JStatement createProbeStatement(@Nonnull SourceInfo sourceInfo, @Nonnull ProbeDescription probe) {
            assert (this.coverageProbesArrayLocal != null);
            assert (this.coverageProbesArrayLocal.getType().equals(JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType().getArray()));
            JLocalRef localRef = this.coverageProbesArrayLocal.makeRef(sourceInfo);
            JArrayRef arrayRef = new JArrayRef(localRef.getSourceInfo(), (JExpression)localRef, (JExpression)new JIntLiteral(localRef.getSourceInfo(), probe.getProbeId()));
            JAsgOperation assign = new JAsgOperation(arrayRef.getSourceInfo(), (JExpression)arrayRef, (JExpression)new JBooleanLiteral(arrayRef.getSourceInfo(), true));
            return assign.makeStatement();
        }
    }

    private static class JacocoPackageNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public JacocoPackageNotFoundException(@Nonnull String msg, @CheckForNull Throwable cause) {
            super(msg, cause);
        }
    }
}

