/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import com.android.jack.coverage.CodeCoverageFeature;
import com.android.jack.coverage.CodeCoverageMarker;
import com.android.jack.coverage.CoverageFilter;
import com.android.jack.coverage.CoverageFilterSet;
import com.android.jack.coverage.CoverageScope;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.SourceFormatter;
import com.android.jack.library.TypeInInputLibraryLocation;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Filters classes for code coverage")
@Support(value={CodeCoverageFeature.class})
@Constraint(need={OriginalNames.class})
@Transform(add={CodeCoverageMarker.Initialized.class})
@Protect(add={JDefinedClassOrInterface.class})
public class CodeCoverageSelector
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    private static final SourceFormatter formatter = SourceFormatter.getFormatter();
    @Nonnull
    private final CoverageFilter filter = new CoverageFilter((CoverageFilterSet)ThreadConfig.get(CodeCoverageFeature.COVERAGE_JACOCO_INCLUDES), (CoverageFilterSet)ThreadConfig.get(CodeCoverageFeature.COVERAGE_JACOCO_EXCLUDES));
    @Nonnull
    private final CoverageScope scope = (CoverageScope)((Object)ThreadConfig.get(CodeCoverageFeature.COVERAGE_SCOPE));

    public void run(@Nonnull JDefinedClassOrInterface t) {
        if (this.needsCoverage(t)) {
            t.addMarker((Marker)new CodeCoverageMarker());
        }
    }

    private boolean needsCoverage(@Nonnull JDefinedClassOrInterface declaredType) {
        if (!declaredType.isToEmit()) {
            return false;
        }
        if (!this.isInScope(declaredType)) {
            return false;
        }
        String typeName = formatter.getName((JType)declaredType);
        return this.filter.matches(typeName);
    }

    private boolean isInScope(@Nonnull JDefinedClassOrInterface declaredType) {
        switch (this.scope) {
            case SOURCE: {
                return CodeCoverageSelector.isSourceType(declaredType);
            }
            case IMPORTS: {
                return !CodeCoverageSelector.isSourceType(declaredType);
            }
            case ALL: {
                return true;
            }
        }
        throw new AssertionError();
    }

    private static boolean isSourceType(@Nonnull JDefinedClassOrInterface declaredType) {
        return !(declaredType.getLocation() instanceof TypeInInputLibraryLocation);
    }
}

