/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class MacAddressOptionHandler
extends OptionHandler<byte[]> {
    public MacAddressOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super byte[]> setter) {
        super(parser, option, setter);
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        String macString = params.getParameter(0);
        String[] macStringArray = null;
        if (macString.matches("[0-9a-fA-F]{12}")) {
            macStringArray = macString.split("(?<=\\G.{2})");
        } else if (macString.matches("([0-9a-fA-F]{1,2}[^0-9a-fA-F]+){5}[0-9a-fA-F]{1,2}")) {
            macStringArray = macString.split("[^0-9a-fA-F]+");
        } else {
            throw new CmdLineException(this.owner, Messages.ILLEGAL_MAC_ADDRESS, macString);
        }
        byte[] mac = new byte[6];
        for (int i = 0; i < 6; ++i) {
            mac[i] = (byte)Short.parseShort(macStringArray[i], 16);
        }
        this.setter.asFieldSetter().addValue(mac);
        return 1;
    }

    @Override
    public String getDefaultMetaVariable() {
        return Messages.DEFAULT_META_MAC_ADDRESS_OPTION_HANDLER.format(new Object[0]);
    }
}

