/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.sched.util.config.MessageDigestFactory;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.FileUtils;
import com.android.sched.util.file.Files;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.OutputZipFile;
import com.android.sched.util.file.Statusful;
import com.android.sched.util.file.StreamFileStatus;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.DirectoryLocation;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.BadVFSFormatException;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.CachedDirectFS;
import com.android.sched.vfs.Capabilities;
import com.android.sched.vfs.CaseInsensitiveFS;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VFSToVFSWrapper;
import com.android.sched.vfs.VPath;
import com.android.sched.vfs.WriteZipFS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ReadWriteZipFS
extends BaseVFS<BaseVDir, BaseVFile>
implements VFS,
Statusful {
    @Nonnull
    private final VFSToVFSWrapper vfs;
    @Nonnull
    private final File dir;

    public ReadWriteZipFS(@Nonnull OutputZipFile file, int numGroups, int groupSize, @Nonnull MessageDigestFactory mdf, boolean debug) throws NotDirectoryException, WrongPermissionException, CannotChangePermissionException, NoSuchFileException, FileAlreadyExistsException, CannotCreateFileException {
        CaseInsensitiveFS workVFS;
        int permissions = 3;
        this.dir = Files.createTempDir("vfs-");
        try {
            CachedDirectFS cdFS = new CachedDirectFS(new Directory(this.dir.getPath(), null, FileOrDirectory.Existence.MUST_EXIST, permissions, FileOrDirectory.ChangePermission.NOCHANGE), permissions);
            workVFS = new CaseInsensitiveFS(cdFS, numGroups, groupSize, mdf, debug);
            cdFS.setInfoString("tmp-for-zip");
        }
        catch (BadVFSFormatException e) {
            throw new AssertionError((Object)e);
        }
        WriteZipFS finalVFS = new WriteZipFS(file);
        this.vfs = new VFSToVFSWrapper(workVFS, finalVFS);
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.vfs.getLocation();
    }

    @Override
    public synchronized void close() throws CannotCloseException {
        if (!this.closed) {
            this.vfs.close();
            try {
                if (this.dir.exists()) {
                    FileUtils.deleteDir(this.dir);
                }
            }
            catch (IOException e) {
                throw new CannotCloseException((Location)new DirectoryLocation(this.dir), (Exception)e);
            }
            this.closed = true;
        }
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "zip archive writer that uses a temporary directory";
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.vfs.getPath();
    }

    @Override
    @Nonnull
    public BaseVDir getRootDir() {
        return this.vfs.getRootDir();
    }

    @Override
    public boolean needsSequentialWriting() {
        return this.vfs.needsSequentialWriting();
    }

    @Override
    @Nonnull
    public Set<Capabilities> getCapabilities() {
        return this.vfs.getCapabilities();
    }

    @Override
    @Nonnull
    InputStream openRead(@Nonnull BaseVFile file) throws WrongPermissionException {
        return this.vfs.openRead(file);
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull BaseVFile file) throws WrongPermissionException {
        return this.openWrite(file, false);
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull BaseVFile file, boolean append) throws WrongPermissionException {
        return this.vfs.openWrite(file, append);
    }

    @Override
    @Nonnull
    BaseVDir getVDir(@Nonnull BaseVDir parent, @Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        return this.vfs.getVDir(parent, name);
    }

    @Override
    @Nonnull
    BaseVFile getVFile(@Nonnull BaseVDir parent, @Nonnull String name) throws NotFileException, NoSuchFileException {
        return this.vfs.getVFile(parent, name);
    }

    @Override
    @Nonnull
    BaseVDir createVDir(@Nonnull BaseVDir parent, @Nonnull String name) throws CannotCreateFileException {
        return this.vfs.createVDir(parent, name);
    }

    @Override
    @Nonnull
    BaseVFile createVFile(@Nonnull BaseVDir parent, @Nonnull String name) throws CannotCreateFileException {
        return this.vfs.createVFile(parent, name);
    }

    @Override
    @Nonnull
    void delete(@Nonnull BaseVFile file) throws CannotDeleteFileException {
        this.vfs.delete(file);
    }

    @Override
    @Nonnull
    Collection<? extends BaseVElement> list(@Nonnull BaseVDir dir) {
        return this.vfs.list(dir);
    }

    @Override
    boolean isEmpty(@Nonnull BaseVDir dir) {
        return this.vfs.isEmpty(dir);
    }

    @Override
    @Nonnull
    FileTime getLastModified(@Nonnull BaseVFile file) throws CannotGetModificationTimeException {
        return this.vfs.getLastModified(file);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull BaseVFile file) {
        return this.vfs.getVFileLocation(file);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull BaseVDir parent, @Nonnull String name) {
        return this.vfs.getVFileLocation(parent, name);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull BaseVDir parent, @Nonnull VPath path) {
        return this.vfs.getVFileLocation(parent, path);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull BaseVDir dir) {
        return this.vfs.getVDirLocation(dir);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull BaseVDir parent, @Nonnull String name) {
        return this.vfs.getVDirLocation(parent, name);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull BaseVDir parent, @Nonnull VPath path) {
        return this.vfs.getVDirLocation(parent, path);
    }

    public void setWorkVFS(@Nonnull VFS workVFS) {
        this.vfs.setWorkVFS(workVFS);
    }

    @Override
    @Nonnull
    VPath getPathFromDir(@Nonnull BaseVDir parent, @Nonnull BaseVFile file) {
        return this.vfs.getPathFromDir(parent, file);
    }

    @Override
    @Nonnull
    VPath getPathFromRoot(@Nonnull BaseVFile file) {
        return this.getPathFromDir(this.getRootDir(), file);
    }

    @Nonnull
    public VFS getWorkVFS() {
        return this.vfs.getWorkVFS();
    }

    @Override
    @CheckForNull
    public String getInfoString() {
        return this.vfs.getInfoString();
    }

    public void setInfoString(@CheckForNull String infoString) {
        ((WriteZipFS)this.vfs.getFinalVFS()).setInfoString(infoString);
    }

    public String toString() {
        return "rwZipFS >> " + this.vfs.toString();
    }

    @Override
    @Nonnull
    public StreamFileStatus getStatus() {
        return ((Statusful)((Object)this.vfs.getWorkVFS())).getStatus();
    }
}

