/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.sched;

import com.android.sched.filter.ManagedComponentFilter;
import com.android.sched.item.AbstractComponent;
import com.android.sched.item.AbstractItemManager;
import com.android.sched.item.Component;
import com.android.sched.item.Feature;
import com.android.sched.item.Item;
import com.android.sched.item.Items;
import com.android.sched.item.ManagedItem;
import com.android.sched.item.Production;
import com.android.sched.item.Tag;
import com.android.sched.item.TagOrMarkerOrComponent;
import com.android.sched.marker.ManagedMarker;
import com.android.sched.marker.Marker;
import com.android.sched.marker.MarkerNotConformException;
import com.android.sched.schedulable.AdapterSchedulable;
import com.android.sched.schedulable.ComponentFilter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.scheduler.FeatureSet;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.ManagedVisitor;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.codec.WriterFileCodec;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ReflectFactory;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.ReflectFactoryPropertyId;
import com.android.sched.util.config.id.WriterFilePropertyId;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.print.DataModel;
import com.android.sched.util.print.DataModelList;
import com.android.sched.util.print.DataModelListAdapter;
import com.android.sched.util.print.DataType;
import com.android.sched.util.print.DataView;
import com.android.sched.util.print.DataViewBuilder;
import com.android.sched.util.print.Printer;
import com.android.sched.util.sched.ManagedDataListener;
import com.android.sched.util.sched.ManagedDataListenerFactory;
import com.android.sched.util.stream.CustomPrintWriter;
import com.google.common.collect.Iterators;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@ImplementationName(iface=ManagedDataListener.class, name="text")
@HasKeyId
public class ManagedDataAsReport
implements ManagedDataListener {
    @Nonnull
    private static final ReflectFactoryPropertyId<Printer> PRINTER = ((ReflectFactoryPropertyId)ReflectFactoryPropertyId.create("sched.report.format", "Define which format to use", Printer.class).addArgType(PrintWriter.class).addDefaultValue("text")).requiredIf(ManagedDataListenerFactory.DATA_LISTENER.getClazz().isSubClassOf(ManagedDataAsReport.class));
    @Nonnull
    public static final WriterFilePropertyId FILE = WriterFilePropertyId.create("sched.report.file", "The file where to print the report", new WriterFileCodec(FileOrDirectory.Existence.MAY_EXIST).allowStandardOutputOrError().allowCharset()).addDefaultValue("-").requiredIf(ManagedDataListenerFactory.DATA_LISTENER.getClazz().isSubClassOf(ManagedDataAsReport.class));
    @Nonnegative
    private int closeIfZero = 2;
    @Nonnegative
    private int nbItemManagerOpen = 0;
    private boolean noMoreItemManager = false;
    private boolean noMoreManagedSchedulable = false;
    @Nonnull
    private static final DataView ID_VIEW = DataViewBuilder.getStructure().addField("id", DataType.STRING).build();
    @Nonnull
    private final DataModelList markers = new DataModelList();
    @Nonnull
    private final DataModelList filters = new DataModelList();
    @Nonnull
    private final DataModelList tags = new DataModelList();
    @Nonnull
    private final DataModelList components = new DataModelList();
    @Nonnull
    private final DataModelList productions = new DataModelList();
    @Nonnull
    private final DataModelList features = new DataModelList();
    @Nonnull
    private static final DataView RUNNER_VIEW = DataViewBuilder.getStructure().addField("name", DataType.STRING).addField("id", DataType.STRING).addField("description", DataType.STRING).addField("runOnId", DataType.STRING).addField("supports", DataType.LIST).addField("optional", DataType.LIST).addField("produces", DataType.LIST).addField("constraints", DataType.STRUCT).addField("transforms", DataType.STRUCT).addField("synchronized", DataType.STRUCT).build();
    @Nonnull
    private final DataModelListAdapter<ManagedRunnable> runners = new DataModelListAdapter<ManagedRunnable>(new DataModelListAdapter.Converter<ManagedRunnable>(){

        @Override
        @Nonnull
        public DataModel apply(ManagedRunnable data) {
            return new ManagedRunnerModel(data);
        }
    });
    @Nonnull
    private final DataModelList adapters = new DataModelList();
    @Nonnull
    private static final DataView DATA_VIEW = DataViewBuilder.getStructure().addField("markers", DataType.LIST).addField("tags", DataType.LIST).addField("productions", DataType.LIST).addField("features", DataType.LIST).addField("components", DataType.LIST).addField("adapters", DataType.LIST).addField("runners", DataType.LIST).addField("filters", DataType.LIST).build();

    @Override
    public void notifyNewItemManager(@Nonnull AbstractItemManager itemManager) {
        assert (!this.noMoreItemManager);
        ++this.nbItemManagerOpen;
        ++this.closeIfZero;
    }

    @Override
    public void notifyNoMoreItemManager() {
        assert (!this.noMoreItemManager);
        this.noMoreItemManager = true;
        --this.closeIfZero;
        this.closeIfZero();
    }

    @Override
    public void notifyNewManagedItem(@Nonnull ManagedItem item) {
        assert (this.nbItemManagerOpen > 0);
        if (Marker.class.isAssignableFrom(item.getItem())) {
            try {
                this.addManagedMarker(new ManagedMarker(item.getItem()));
            }
            catch (MarkerNotConformException e) {
                this.addManagedMarkerError(item);
            }
        } else if (Tag.class.isAssignableFrom(item.getItem())) {
            this.addManagedTag(item);
        } else if (AbstractComponent.class.isAssignableFrom(item.getItem())) {
            this.addManagedComponent(item);
        } else if (Production.class.isAssignableFrom(item.getItem())) {
            this.addManagedProduction(item);
        } else if (Feature.class.isAssignableFrom(item.getItem())) {
            this.addManagedFeature(item);
        } else if (ComponentFilter.class.isAssignableFrom(item.getItem())) {
            this.addManagedComponentFilter(item);
        }
    }

    @Override
    public void notifyNoMoreManagedItem(@Nonnull Class<? extends Item> type) {
        assert (this.nbItemManagerOpen > 0);
        --this.nbItemManagerOpen;
        --this.closeIfZero;
        this.closeIfZero();
    }

    @Override
    public void notifyNewManagedSchedulable(@Nonnull ManagedSchedulable schedulable) {
        assert (!this.noMoreManagedSchedulable);
        if (schedulable instanceof ManagedRunnable) {
            this.addManagedRunnable((ManagedRunnable)schedulable);
        } else if (schedulable instanceof ManagedVisitor) {
            this.addManagedVisitor((ManagedVisitor)schedulable);
        } else {
            throw new AssertionError();
        }
    }

    @Override
    public void notifyNoMoreManagedSchedulable() {
        assert (!this.noMoreManagedSchedulable);
        this.noMoreManagedSchedulable = true;
        --this.closeIfZero;
        this.closeIfZero();
    }

    private void closeIfZero() {
        if (this.closeIfZero == 0) {
            this.close();
        }
    }

    private void addManagedMarker(@Nonnull ManagedMarker marker) {
        this.markers.add(new ManagedMarkerModel(marker));
    }

    private void addManagedMarkerError(@Nonnull ManagedItem item) {
    }

    private void addManagedComponentFilter(@Nonnull ManagedItem filter) {
        this.filters.add(new ManagedComponentFilterModel((ManagedComponentFilter)filter));
    }

    private void addManagedTag(@Nonnull ManagedItem item) {
        this.tags.add(new ManagedItemModel(item, Tag.class));
    }

    private void addManagedComponent(@Nonnull ManagedItem item) {
        this.components.add(new ManagedItemModel(item, Component.class));
    }

    private void addManagedProduction(@Nonnull ManagedItem item) {
        this.productions.add(new ManagedItemModel(item, Production.class));
    }

    private void addManagedFeature(@Nonnull ManagedItem item) {
        this.features.add(new ManagedItemModel(item, Feature.class));
    }

    private void addManagedRunnable(@Nonnull ManagedRunnable runnable) {
        this.runners.add(runnable);
    }

    private void addManagedVisitor(@Nonnull ManagedVisitor visitor) {
        this.adapters.add(new ManagedVisitorModel(visitor));
    }

    private void close() {
        CustomPrintWriter writer = ThreadConfig.get(FILE).getPrintWriter();
        Printer provider = ((Printer)((ReflectFactory)((Object)ThreadConfig.get(PRINTER))).create(writer)).addResourceBundles(ResourceBundle.getBundle(ManagedDataAsReport.class.getCanonicalName()));
        try {
            writer.print("ctx=");
            provider.print(new DataModel(){

                @Override
                @Nonnull
                public Iterator<Object> iterator() {
                    return Iterators.forArray((Object[])new Object[]{ManagedDataAsReport.this.markers, ManagedDataAsReport.this.tags, ManagedDataAsReport.this.productions, ManagedDataAsReport.this.features, ManagedDataAsReport.this.components, ManagedDataAsReport.this.adapters, ManagedDataAsReport.this.runners, ManagedDataAsReport.this.filters});
                }

                @Override
                @Nonnull
                public DataView getDataView() {
                    return DATA_VIEW;
                }
            });
        }
        finally {
            ((PrintWriter)writer).close();
        }
    }

    @Nonnull
    private static String getId(@Nonnull Class<?> cls, @Nonnull Class<?> category) {
        String id = cls.getCanonicalName();
        if (Feature.class.isAssignableFrom(category)) {
            return "f-" + id;
        }
        if (TagOrMarkerOrComponent.class.isAssignableFrom(category)) {
            return "tcm-" + id;
        }
        if (RunnableSchedulable.class.isAssignableFrom(category)) {
            return "r-" + id;
        }
        if (AdapterSchedulable.class.isAssignableFrom(category)) {
            return "a-" + id;
        }
        if (Production.class.isAssignableFrom(category)) {
            return "p-" + id;
        }
        if (ComponentFilter.class.isAssignableFrom(category)) {
            return "cf-" + id;
        }
        throw new AssertionError((Object)("No 'id' for '" + id + "'"));
    }

    private static class ManagedVisitorModel
    implements DataModel {
        @Nonnull
        private static final DataView ADAPTER_VIEW = DataViewBuilder.getStructure().addField("name", DataType.STRING).addField("id", DataType.STRING).addField("description", DataType.STRING).addField("runOnId", DataType.STRING).addField("adaptToId", DataType.STRING).addField("synchronized", DataType.STRUCT).build();
        @Nonnull
        private final ManagedVisitor adapter;

        public ManagedVisitorModel(@Nonnull ManagedVisitor adapter) {
            this.adapter = adapter;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            return Iterators.forArray((Object[])new Object[]{this.adapter.getName(), ManagedDataAsReport.getId(this.adapter.getSchedulable(), AdapterSchedulable.class), this.adapter.getDescription(), ManagedDataAsReport.getId(this.adapter.getRunOn(), Component.class), ManagedDataAsReport.getId(this.adapter.getRunOnAfter(), Component.class), new SynchronizedModel(this.adapter)});
        }

        @Override
        @Nonnull
        public DataView getDataView() {
            return ADAPTER_VIEW;
        }
    }

    private static class ManagedRunnerModel
    implements DataModel {
        @Nonnull
        private final ManagedRunnable runner;

        public ManagedRunnerModel(@Nonnull ManagedRunnable runner) {
            this.runner = runner;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            return Iterators.forArray((Object[])new Object[]{this.runner.getName(), ManagedDataAsReport.getId(this.runner.getSchedulable(), RunnableSchedulable.class), this.runner.getDescription(), ManagedDataAsReport.getId(this.runner.getRunOn(), Component.class), new IdList(Feature.class).addAll(this.runner.getSupportedFeatures().getCompactSet().iterator()), new DataModelListAdapter<FeatureSet>(new DataModelListAdapter.Converter<FeatureSet>(){

                @Override
                @Nonnull
                public DataModel apply(FeatureSet data) {
                    return new OptionalModel(runner, data);
                }
            }).addAll(this.runner.getOptionalFeatures()), new IdList(Production.class).addAll(this.runner.getProductions().getCompactSet().iterator()), new ConstraintModel(this.runner), new TransformModel(this.runner), new SynchronizedModel(this.runner)});
        }

        @Override
        @Nonnull
        public DataView getDataView() {
            return RUNNER_VIEW;
        }
    }

    private static class OptionalModel
    implements DataModel {
        @Nonnull
        private static final DataView OPTIONAL_VIEW = DataViewBuilder.getStructure().addField("supports", DataType.LIST).addField("constraints", DataType.STRUCT).build();
        @Nonnull
        private final ManagedRunnable runner;
        @Nonnull
        private final FeatureSet features;

        public OptionalModel(@Nonnull ManagedRunnable runner, @Nonnull FeatureSet features) {
            this.runner = runner;
            this.features = features;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            return Iterators.forArray((Object[])new Object[]{new DataModelListAdapter<Class<? extends Feature>>(new DataModelListAdapter.Converter<Class<? extends Feature>>(){

                @Override
                @Nonnull
                public DataModel apply(final Class<? extends Feature> data) {
                    return new DataModel(){

                        @Override
                        public Iterator<Object> iterator() {
                            return Iterators.forArray((Object[])new Object[]{ManagedDataAsReport.getId(data, Feature.class)});
                        }

                        @Override
                        @Nonnull
                        public DataView getDataView() {
                            return ID_VIEW;
                        }
                    };
                }
            }).addAll(this.features.getCompactSet().iterator()), new ConstraintModel(this.runner, this.features)});
        }

        @Override
        @Nonnull
        public DataView getDataView() {
            return OPTIONAL_VIEW;
        }
    }

    private static class TransformModel
    implements DataModel {
        @Nonnull
        private static final DataView TRANSFORM_VIEW = DataViewBuilder.getStructure().addField("add", DataType.LIST).addField("remove", DataType.LIST).build();
        @Nonnull
        private final ManagedRunnable runner;

        public TransformModel(@Nonnull ManagedRunnable runner) {
            this.runner = runner;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            return Iterators.forArray((Object[])new Object[]{new IdList(TagOrMarkerOrComponent.class).addAll(this.runner.getAddedTags().getCompactSet().iterator()), new IdList(TagOrMarkerOrComponent.class).addAll(this.runner.getRemovedTags().getCompactSet().iterator())});
        }

        @Override
        @Nonnull
        public DataView getDataView() {
            return TRANSFORM_VIEW;
        }
    }

    private static class ConstraintModel
    implements DataModel {
        @Nonnull
        private static final DataView CONSTRAINT_VIEW = DataViewBuilder.getStructure().addField("need", DataType.LIST).addField("no", DataType.LIST).build();
        @Nonnull
        private final ManagedRunnable runner;
        @CheckForNull
        private final FeatureSet features;

        public ConstraintModel(@Nonnull ManagedRunnable runner, @Nonnull FeatureSet features) {
            this.runner = runner;
            this.features = features;
        }

        public ConstraintModel(@Nonnull ManagedRunnable runner) {
            this.runner = runner;
            this.features = null;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            return Iterators.forArray((Object[])new Object[]{new IdList(TagOrMarkerOrComponent.class).addAll((this.features == null ? this.runner.getDefaultNeededTags().getCompactSet() : this.runner.getNeededTags(this.features).getCompactSet()).iterator()), new IdList(TagOrMarkerOrComponent.class).addAll((this.features == null ? this.runner.getDefaultUnsupportedTags().getCompactSet() : this.runner.getUnsupportedTags(this.features).getCompactSet()).iterator())});
        }

        @Override
        @Nonnull
        public DataView getDataView() {
            return CONSTRAINT_VIEW;
        }
    }

    private static class SynchronizedModel
    implements DataModel {
        @Nonnull
        private static final DataView SYNCHRONIZED_VIEW = DataViewBuilder.getStructure().addField("static", DataType.BOOLEAN).addField("dynamic", DataType.STRING).build();
        @Nonnull
        private final ManagedSchedulable schedulable;

        public SynchronizedModel(@Nonnull ManagedSchedulable schedulable) {
            this.schedulable = schedulable;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            String dynamic = null;
            Method method = this.schedulable.getDynamicallySynchronizedMethod();
            if (method != null) {
                dynamic = method.getDeclaringClass().getCanonicalName() + "#" + method.getName();
            }
            return Iterators.forArray((Object[])new Object[]{this.schedulable.isStaticallySynchronized(), dynamic});
        }

        @Override
        @Nonnull
        public DataView getDataView() {
            return SYNCHRONIZED_VIEW;
        }
    }

    private static class ManagedItemModel
    implements DataModel {
        private static final DataView ITEM_VIEW = DataViewBuilder.getStructure().addField("name", DataType.STRING).addField("id", DataType.STRING).addField("description", DataType.STRING).addField("composedOfId", DataType.LIST).build();
        @Nonnull
        private final ManagedItem item;
        @Nonnull
        private final Class<? extends Item> category;

        public ManagedItemModel(@Nonnull ManagedItem item, @Nonnull Class<? extends Item> catagory) {
            this.item = item;
            this.category = catagory;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            return Iterators.forArray((Object[])new Object[]{this.item.getName(), ManagedDataAsReport.getId(this.item.getItem(), this.category), this.item.getDescription(), new IdList(this.category).addAll(Items.getComposedOf(this.item.getItem()))});
        }

        @Override
        @Nonnull
        public DataView getDataView() {
            return ITEM_VIEW;
        }
    }

    private static class ManagedComponentFilterModel
    implements DataModel {
        @Nonnull
        private static final DataView FILTER_VIEW = DataViewBuilder.getStructure().addField("name", DataType.STRING).addField("id", DataType.STRING).addField("description", DataType.STRING).addField("filterOnId", DataType.STRING).build();
        @Nonnull
        private final ManagedComponentFilter filter;

        public ManagedComponentFilterModel(@Nonnull ManagedComponentFilter filter) {
            this.filter = filter;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            return Iterators.forArray((Object[])new Object[]{this.filter.getName(), ManagedDataAsReport.getId(this.filter.getComponentFilter(), ComponentFilter.class), this.filter.getDescription(), ManagedDataAsReport.getId(this.filter.getFilterOn(), Component.class)});
        }

        @Override
        @Nonnull
        public DataView getDataView() {
            return FILTER_VIEW;
        }
    }

    private static class ManagedMarkerModel
    implements DataModel {
        @Nonnull
        private static final DataView MARKER_VIEW = DataViewBuilder.getStructure().addField("name", DataType.STRING).addField("id", DataType.STRING).addField("description", DataType.STRING).addField("sValidOn", DataType.LIST).addField("dValidOn", DataType.LIST).build();
        @Nonnull
        private static final DataView ID_METHOD_VIEW = DataViewBuilder.getStructure().addField("id", DataType.STRING).addField("method", DataType.STRING).build();
        @Nonnull
        private final ManagedMarker marker;

        public ManagedMarkerModel(@Nonnull ManagedMarker marker) {
            this.marker = marker;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            return Iterators.forArray((Object[])new Object[]{this.marker.getName(), ManagedDataAsReport.getId(this.marker.getMarker(), Marker.class), this.marker.getDescription(), new IdList(Marker.class).addAll(this.marker.getStaticValidOn()), new DataModelListAdapter<ManagedMarker.InternalDynamicValidOn>(new DataModelListAdapter.Converter<ManagedMarker.InternalDynamicValidOn>(){

                @Override
                @Nonnull
                public DataModel apply(final ManagedMarker.InternalDynamicValidOn data) {
                    return new DataModel(){

                        @Override
                        @Nonnull
                        public Iterator<Object> iterator() {
                            return Iterators.forArray((Object[])new Object[]{ManagedDataAsReport.getId(data.getValidOn(), Marker.class), data.getMethod().getDeclaringClass().getCanonicalName() + "#" + data.getMethod().getName()});
                        }

                        @Override
                        @Nonnull
                        public DataView getDataView() {
                            return ID_METHOD_VIEW;
                        }
                    };
                }
            }).addAll(this.marker.getDynamicValidOn())});
        }

        @Override
        @Nonnull
        public DataView getDataView() {
            return MARKER_VIEW;
        }
    }

    private static class IdList
    extends DataModelListAdapter<Class<? extends Item>> {
        public IdList(final @Nonnull Class<? extends Item> category) {
            super(new DataModelListAdapter.Converter<Class<? extends Item>>(){

                @Override
                @Nonnull
                public DataModel apply(final Class<? extends Item> data) {
                    return new DataModel(){

                        @Override
                        @Nonnull
                        public Iterator<Object> iterator() {
                            return Iterators.forArray((Object[])new Object[]{ManagedDataAsReport.getId(data, category)});
                        }

                        @Override
                        @Nonnull
                        public DataView getDataView() {
                            return ID_VIEW;
                        }
                    };
                }
            });
        }
    }
}

