/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.print;

import com.android.sched.util.codec.BooleanCodec;
import com.android.sched.util.codec.DurationFormatter;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.codec.NumberFormatter;
import com.android.sched.util.codec.PercentFormatter;
import com.android.sched.util.codec.QuantityFormatter;
import com.android.sched.util.print.AbstractPrinter;
import com.android.sched.util.print.DataModel;
import com.android.sched.util.print.DataType;
import com.android.sched.util.print.FormatterAdapter;
import com.android.sched.util.print.Printer;
import com.android.sched.util.print.TypePrinter;
import com.google.common.base.Strings;
import java.io.PrintWriter;
import java.text.NumberFormat;
import javax.annotation.Nonnull;

@ImplementationName(iface=Printer.class, name="text")
public class TextPrinter
extends AbstractPrinter {
    @Nonnull
    private final String prefixFirst = "";
    @Nonnull
    private final String prefixFollowing = "";
    @Nonnull
    private final TextIndenter f = new TextIndenter(0);

    public TextPrinter(@Nonnull PrintWriter printer) {
        super(printer);
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setMinimumFractionDigits(4);
        formatter.setMaximumFractionDigits(4);
        this.printers.put(DataType.NOTHING, new AbstractPrinter.NothingPrinter());
        this.printers.put(DataType.BOOLEAN, new FormatterAdapter<Boolean>(new BooleanCodec()));
        this.printers.put(DataType.DURATION, new FormatterAdapter<Long>(new DurationFormatter()));
        this.printers.put(DataType.NUMBER, new FormatterAdapter<Number>(new NumberFormatter().setNumberFormatter(formatter)));
        this.printers.put(DataType.PERCENT, new FormatterAdapter<Double>(new PercentFormatter()));
        this.printers.put(DataType.QUANTITY, new FormatterAdapter<Long>(new QuantityFormatter()));
        this.printers.put(DataType.STRING, new TextStringFormatter());
        this.printers.put(DataType.BUNDLE, new AbstractPrinter.WithBundlePrinter());
        this.printers.put(DataType.STRUCT, new TextStructurePrinter());
        this.printers.put(DataType.LIST, new TextListPrinter());
    }

    private static class TextIndenter {
        private int indent = 0;
        @Nonnull
        private String blank = "  ";
        @Nonnull
        private String bullet = "- ";
        @Nonnull
        private String currentBlank = "";
        @Nonnull
        private String currentBullet = "";
        private boolean needBullet;
        private boolean newLineDone = true;
        private boolean prefixDone = false;

        public TextIndenter(@Nonnull int indent) {
            this.indent = indent;
        }

        public TextIndenter setBullet(String bullet) {
            this.bullet = bullet;
            if (this.indent > 1) {
                this.currentBullet = Strings.repeat((String)this.blank, (int)(this.indent - 1)) + bullet;
            }
            return this;
        }

        public TextIndenter setIndent(@Nonnull String indent) {
            this.blank = indent;
            if (this.indent > 0) {
                this.currentBlank = Strings.repeat((String)this.blank, (int)this.indent);
            }
            if (this.indent > 1) {
                this.currentBullet = Strings.repeat((String)this.blank, (int)(this.indent - 1)) + this.bullet;
            }
            return this;
        }

        public int getIndent() {
            return this.indent;
        }

        public void push() {
            ++this.indent;
            this.currentBullet = this.currentBlank + this.bullet;
            this.currentBlank = this.currentBlank + this.blank;
        }

        public void bullet() {
            this.needBullet = true;
        }

        public void pop() {
            --this.indent;
            this.currentBlank = this.currentBlank.substring(this.blank.length());
            this.currentBullet = this.currentBullet.substring(this.blank.length());
        }

        public void print(@Nonnull PrintWriter printer, @Nonnull String str) {
            if (!this.prefixDone) {
                if (this.needBullet) {
                    printer.print(this.currentBullet);
                    this.needBullet = false;
                } else {
                    printer.print(this.currentBlank);
                }
                this.prefixDone = true;
            }
            printer.print(str);
            this.newLineDone = false;
        }

        public void println(@Nonnull PrintWriter printer) {
            this.prefixDone = false;
            if (!this.newLineDone) {
                printer.println();
                this.newLineDone = true;
            }
        }
    }

    private class TextStructurePrinter
    implements TypePrinter<DataModel> {
        private TextStructurePrinter() {
        }

        @Override
        @Nonnull
        public boolean print(@Nonnull PrintWriter printer, @Nonnull DataModel model) {
            boolean notEmpty = false;
            DataType[] types = model.getDataView().getDataTypes();
            String[] names = model.getDataView().getDataNames();
            int idx = 0;
            TextPrinter.this.f.println(printer);
            TextPrinter.this.f.push();
            TextPrinter.this.f.bullet();
            for (Object object : model) {
                if (object != null) {
                    TextPrinter.this.f.print(printer, TextPrinter.this.getString(names[idx]));
                    TextPrinter.this.f.print(printer, ": ");
                    TypePrinter formatter = TextPrinter.this.getFormatter(types[idx]);
                    formatter.print(printer, object);
                    TextPrinter.this.f.println(printer);
                }
                ++idx;
            }
            TextPrinter.this.f.pop();
            return notEmpty;
        }
    }

    private class TextListPrinter
    implements TypePrinter<DataModel> {
        private TextListPrinter() {
        }

        @Override
        @Nonnull
        public boolean print(@Nonnull PrintWriter printer, @Nonnull DataModel model) {
            TypePrinter formatter = TextPrinter.this.getFormatter(model.getDataView().getDataTypes()[0]);
            boolean notEmpty = false;
            TextPrinter.this.f.println(printer);
            for (Object object : model) {
                TextPrinter.this.f.bullet();
                notEmpty |= formatter.print(printer, object);
            }
            return notEmpty;
        }
    }

    private static class TextStringFormatter
    implements TypePrinter<String> {
        private TextStringFormatter() {
        }

        @Override
        public boolean print(@Nonnull PrintWriter printer, @Nonnull String value) {
            printer.print(value);
            return true;
        }
    }
}

