/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.print;

import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.print.AbstractPrinter;
import com.android.sched.util.print.DataModel;
import com.android.sched.util.print.DataType;
import com.android.sched.util.print.Printer;
import com.android.sched.util.print.TypePrinter;
import java.io.PrintWriter;
import javax.annotation.Nonnull;

@ImplementationName(iface=Printer.class, name="json")
public class JsonPrinter
extends AbstractPrinter {
    public JsonPrinter(@Nonnull PrintWriter printer) {
        super(printer);
        this.printers.put(DataType.NOTHING, new AbstractPrinter.NothingPrinter());
        this.printers.put(DataType.BOOLEAN, new JsonBooleanFormatter());
        this.printers.put(DataType.DURATION, new JsonNumberFormatter());
        this.printers.put(DataType.NUMBER, new JsonNumberFormatter());
        this.printers.put(DataType.PERCENT, new JsonNumberFormatter());
        this.printers.put(DataType.QUANTITY, new JsonNumberFormatter());
        this.printers.put(DataType.STRING, new JsonStringFormatter());
        this.printers.put(DataType.BUNDLE, new JsonStringFormatter());
        this.printers.put(DataType.STRUCT, new JsonStructureFormatter());
        this.printers.put(DataType.LIST, new JsonListFormatter());
    }

    private class JsonStructureFormatter
    implements TypePrinter<DataModel> {
        private JsonStructureFormatter() {
        }

        @Override
        @Nonnull
        public boolean print(@Nonnull PrintWriter printer, @Nonnull DataModel model) {
            DataType[] types = model.getDataView().getDataTypes();
            String[] names = model.getDataView().getDataNames();
            boolean first = true;
            int idx = 0;
            printer.print('{');
            for (Object object : model) {
                if (object != null) {
                    if (!first) {
                        printer.print(',');
                    } else {
                        first = false;
                    }
                    printer.print('\"');
                    printer.print(names[idx]);
                    printer.print("\":");
                    TypePrinter formatter = JsonPrinter.this.getFormatter(types[idx]);
                    formatter.print(printer, object);
                }
                ++idx;
            }
            printer.print('}');
            return true;
        }
    }

    private class JsonListFormatter
    implements TypePrinter<DataModel> {
        private JsonListFormatter() {
        }

        @Override
        @Nonnull
        public boolean print(@Nonnull PrintWriter printer, @Nonnull DataModel model) {
            TypePrinter formatter = JsonPrinter.this.getFormatter(model.getDataView().getDataTypes()[0]);
            boolean first = true;
            boolean idx = false;
            printer.print('[');
            for (Object object : model) {
                if (!first) {
                    printer.print(',');
                } else {
                    first = false;
                }
                formatter.print(printer, object);
            }
            printer.print(']');
            return true;
        }
    }

    private static class JsonStringFormatter
    implements TypePrinter<String> {
        private JsonStringFormatter() {
        }

        @Override
        public boolean print(@Nonnull PrintWriter printer, @Nonnull String value) {
            printer.print("\"" + value.replace("\"", "\\\"") + "\"");
            return true;
        }
    }

    private static class JsonBooleanFormatter
    implements TypePrinter<Boolean> {
        private JsonBooleanFormatter() {
        }

        @Override
        @Nonnull
        public boolean print(@Nonnull PrintWriter printer, @Nonnull Boolean value) {
            printer.print(value != false ? "true" : "false");
            return true;
        }
    }

    private static class JsonNumberFormatter
    implements TypePrinter<Number> {
        private JsonNumberFormatter() {
        }

        @Override
        @Nonnull
        public boolean print(@Nonnull PrintWriter printer, @Nonnull Number value) {
            if (value instanceof Double) {
                if (((Double)value).isNaN() || ((Double)value).isInfinite()) {
                    printer.print("null");
                } else {
                    printer.print(value.toString());
                }
            } else if (value instanceof Float) {
                if (((Float)value).isNaN() || ((Float)value).isInfinite()) {
                    printer.print("null");
                } else {
                    printer.print(value.toString());
                }
            } else {
                printer.print(value.toString());
            }
            return true;
        }
    }
}

