/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.sched.util.RunnableHooks;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.Statusful;
import com.android.sched.util.file.StreamFileStatus;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.stream.QueryableStream;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class AbstractStreamFile
extends FileOrDirectory
implements Statusful {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @CheckForNull
    protected final File file;
    @CheckForNull
    protected QueryableStream stream;
    protected boolean wasUsed = false;

    protected AbstractStreamFile(@Nonnull String name, @CheckForNull RunnableHooks hooks) {
        this(new File(name), new FileLocation(name), hooks);
    }

    protected AbstractStreamFile(@Nonnull File file, @Nonnull FileLocation location, @CheckForNull RunnableHooks hooks) {
        super(hooks);
        this.file = file;
        this.location = location;
    }

    protected AbstractStreamFile(@Nonnull Location location) {
        super(null);
        this.file = null;
        this.location = location;
    }

    protected void performChecks(@Nonnull FileOrDirectory.Existence existence, int permissions, @Nonnull FileOrDirectory.ChangePermission change) throws NoSuchFileException, NotFileException, WrongPermissionException, FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException {
        assert (this.file != null);
        if (existence == FileOrDirectory.Existence.MAY_EXIST) {
            existence = this.file.exists() ? FileOrDirectory.Existence.MUST_EXIST : FileOrDirectory.Existence.NOT_EXIST;
        }
        switch (existence) {
            case MUST_EXIST: {
                AbstractStreamFile.check(this.file, this.location);
                FileOrDirectory.checkPermissions(this.file, this.location, permissions);
                break;
            }
            case NOT_EXIST: {
                AbstractStreamFile.create(this.file, this.location);
                this.addRemover(this.file);
                FileOrDirectory.setPermissions(this.file, this.location, permissions, change);
                FileOrDirectory.checkPermissions(this.file, this.location, permissions);
                break;
            }
            case MAY_EXIST: {
                throw new AssertionError();
            }
        }
    }

    public boolean isStandard() {
        return this.file == null;
    }

    @Nonnull
    public String toString() {
        return this.location.getDescription();
    }

    public static void create(@Nonnull File file, @Nonnull Location location) throws FileAlreadyExistsException, CannotCreateFileException {
        try {
            if (file.createNewFile()) {
                logger.log(Level.FINE, "Create {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
                return;
            }
        }
        catch (IOException e) {
            throw new CannotCreateFileException(location);
        }
        throw new FileAlreadyExistsException(location);
    }

    public static void check(@Nonnull File file, @Nonnull Location location) throws NoSuchFileException, NotFileException {
        if (!file.exists()) {
            throw new NoSuchFileException(location);
        }
        if (file.isDirectory()) {
            throw new NotFileException(location);
        }
    }

    @Override
    @Nonnull
    public String getPath() {
        assert (this.file != null);
        return this.file.getPath();
    }

    @Override
    @Nonnull
    public final synchronized StreamFileStatus getStatus() {
        if (!this.wasUsed) {
            return StreamFileStatus.NOT_USED;
        }
        assert (this.stream != null);
        return this.stream.isClosed() ? StreamFileStatus.CLOSED : StreamFileStatus.OPEN;
    }
}

