/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.expression;

import com.android.sched.util.codec.Selector;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.expression.Expression;
import com.android.sched.util.config.expression.PropertyNotRequiredException;
import com.google.common.base.Joiner;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class ClassExpression<T>
extends Expression {
    @Nonnull
    private final Selector<T> selector;

    public abstract Class<? extends T> eval(@Nonnull ConfigChecker var1) throws PropertyIdException, PropertyNotRequiredException;

    protected ClassExpression(@Nonnull Selector<T> selector) {
        this.selector = selector;
    }

    @Nonnull
    public BooleanExpression isImplementedBy(final @Nonnull Class<? extends T> type) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return type == ClassExpression.this.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return ClassExpression.this.format(ClassExpression.this.getDescription(), true, ClassExpression.this.selector.getName(type));
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return ClassExpression.this.format(ClassExpression.this.getCause(checker), this.eval(checker), ClassExpression.this.selector.getName(ClassExpression.this.eval(checker)));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isNotImplementedBy(final @Nonnull Class<? extends T> type) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return type != ClassExpression.this.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return ClassExpression.this.format(ClassExpression.this.getDescription(), false, ClassExpression.this.selector.getName(type));
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return ClassExpression.this.format(ClassExpression.this.getCause(checker), !this.eval(checker), ClassExpression.this.selector.getName(ClassExpression.this.eval(checker)));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isSubClassOf(final @Nonnull Class<? extends T> type) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return type.isAssignableFrom(ClassExpression.this.eval(checker));
            }

            @Override
            @Nonnull
            public String getDescription() {
                return ClassExpression.this.format(ClassExpression.this.getDescription(), true, ClassExpression.this.selector.getNames(type));
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return ClassExpression.this.format(ClassExpression.this.getCause(checker), this.eval(checker), ClassExpression.this.selector.getName(ClassExpression.this.eval(checker)));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isNotSubClassOf(final @Nonnull Class<? extends T> type) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return !type.isAssignableFrom(ClassExpression.this.eval(checker));
            }

            @Override
            @Nonnull
            public String getDescription() {
                return ClassExpression.this.format(ClassExpression.this.getDescription(), false, ClassExpression.this.selector.getNames(type));
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return ClassExpression.this.format(ClassExpression.this.getCause(checker), !this.eval(checker), ClassExpression.this.selector.getName(type));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    private String format(@Nonnull String left, boolean set, @Nonnull String right) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        sb.append(" is ");
        if (!set) {
            sb.append("not ");
        }
        sb.append("set to '");
        sb.append(right);
        sb.append('\'');
        return sb.toString();
    }

    @Nonnull
    private String format(@Nonnull String left, boolean set, @Nonnull List<String> rights) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        sb.append(" is ");
        if (!set) {
            sb.append("not ");
        }
        sb.append("set to ");
        if (rights.size() > 1) {
            sb.append("one of {");
            Joiner.on((char)',').appendTo(sb, rights);
            sb.append('}');
        } else if (rights.size() == 1) {
            sb.append('\'');
            sb.append(rights.get(0));
            sb.append('\'');
        } else {
            sb.append("nothing");
        }
        return sb.toString();
    }
}

