/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class LongCodec
implements StringCodec<Long> {
    private long min;
    private long max;

    public LongCodec() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public LongCodec(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public void setMax(long max) {
        this.max = max;
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "an integer belonging to [" + this.min + " .. " + this.max + "]";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "number";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Long checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            Long l = Long.valueOf(string);
            try {
                this.checkValue(context, l);
            }
            catch (CheckingException e) {
                throw new ParsingException(e);
            }
            return l;
        }
        catch (NumberFormatException e) {
            throw new ParsingException("The value must be " + this.getUsage() + " but is '" + string + "'");
        }
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull Long l) throws CheckingException {
        long v = l;
        if (v < this.min || v > this.max) {
            throw new CheckingException("The value must be " + this.getUsage() + " but is " + l);
        }
    }

    @Override
    @Nonnull
    public Long parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull Long l) {
        return l.toString();
    }
}

