/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler.genetic;

import com.android.sched.item.Component;
import com.android.sched.scheduler.GroupPlanCandidate;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.Request;
import com.android.sched.scheduler.TagOrMarkerOrComponentSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;

class MoveRunnerMutation<T extends Component>
implements EvolutionaryOperator<GroupPlanCandidate<T>> {
    @Nonnull
    private final NumberGenerator<Probability> moveProbability;
    @Nonnull
    private final Request request;

    public MoveRunnerMutation(@Nonnull NumberGenerator<Probability> moveProbability, @Nonnull Request request) {
        this.moveProbability = moveProbability;
        this.request = request;
    }

    @Nonnull
    public List<GroupPlanCandidate<T>> apply(List<GroupPlanCandidate<T>> selectedCandidates, Random rng) {
        ArrayList<GroupPlanCandidate<T>> mutatedCandidates = new ArrayList<GroupPlanCandidate<T>>(selectedCandidates.size());
        for (GroupPlanCandidate<T> candidate : selectedCandidates) {
            if (((Probability)this.moveProbability.nextValue()).nextEvent(rng)) {
                ArrayList<ManagedRunnable> newRunners = new ArrayList<ManagedRunnable>(candidate.getRunnables());
                if (candidate.getSatisfiedRunnerCount() > 0) {
                    int forward;
                    int idx = rng.nextInt(candidate.getSatisfiedRunnerCount());
                    idx = candidate.getIndexFromSatisfiedIndex(idx);
                    ManagedRunnable runner = (ManagedRunnable)newRunners.get(idx);
                    for (forward = 1; forward <= idx; ++forward) {
                        int newIdx = idx - forward;
                        TagOrMarkerOrComponentSet beforeTags = candidate.getBeforeTags(newIdx);
                        if (runner.getUnsatisfiedConstraintCount(this.request.getFeatures(), beforeTags) > 0) break;
                        TagOrMarkerOrComponentSet afterTags = runner.getAfterTags(beforeTags);
                        if (((ManagedRunnable)newRunners.get(newIdx)).getUnsatisfiedConstraintCount(this.request.getFeatures(), afterTags) > 0) break;
                    }
                    if (--forward > 0) {
                        if (forward > 1) {
                            forward = rng.nextInt(forward) + 1;
                        }
                        newRunners.remove(idx);
                        newRunners.add(idx - forward, runner);
                    }
                }
                mutatedCandidates.add(new GroupPlanCandidate<T>(candidate, newRunners));
                continue;
            }
            mutatedCandidates.add(candidate);
        }
        return mutatedCandidates;
    }
}

