/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.filter.NoFilter;
import com.android.sched.item.Component;
import com.android.sched.item.Items;
import com.android.sched.schedulable.AdapterSchedulable;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Schedulable;
import com.android.sched.schedulable.VisitorSchedulable;
import com.android.sched.scheduler.ComponentFilterSet;
import com.android.sched.scheduler.MultipleScheduleInstance;
import com.android.sched.scheduler.Plan;
import com.android.sched.scheduler.PlanStep;
import com.android.sched.scheduler.ProcessException;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.util.codec.ImplementationFilter;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.codec.ReflectFactorySelector;
import com.android.sched.util.codec.VariableName;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ReflectFactory;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.config.id.IntegerPropertyId;
import com.android.sched.util.config.id.ListPropertyId;
import com.android.sched.util.config.id.LongPropertyId;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.ThreadTracerState;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@HasKeyId
@ImplementationName(iface=ScheduleInstance.class, name="multi-threaded")
public class MultiWorkersScheduleInstance<T extends Component>
extends MultipleScheduleInstance<T> {
    @Nonnull
    private static final BooleanPropertyId MANAGED_SYNC = BooleanPropertyId.create("sched.runner.thread.synchronized", "If scheduler manages synchronized schedulable by itself").requiredIf(ScheduleInstance.DEFAULT_RUNNER.getClazz().isSubClassOf(MultiWorkersScheduleInstance.class)).addDefaultValue(Boolean.TRUE);
    @Nonnull
    private static final IntegerPropertyId CHECK_FREQUENCY = IntegerPropertyId.create("sched.runner.thread.detector.frequency", "Define at which frequency the detector is triggered (in ms)").withMin(100L).requiredIf(ScheduleInstance.DEFAULT_RUNNER.getClazz().isSubClassOf(MultiWorkersScheduleInstance.class)).addDefaultValue("30000");
    @Nonnegative
    private final int checkEvery = ThreadConfig.get(CHECK_FREQUENCY).intValue();
    @Nonnull
    private final Synchronized[] syncs;

    protected MultiWorkersScheduleInstance(@Nonnull Plan<T> plan) throws Exception {
        super(plan);
        boolean isSynchronizedManaged = ThreadConfig.get(MANAGED_SYNC);
        this.syncs = new Synchronized[plan.size()];
        if (isSynchronizedManaged) {
            int idx = 0;
            for (PlanStep step : plan) {
                if (step.getManagedSchedulable().isSynchronized(this.steps[idx].getInstance())) {
                    this.syncs[idx] = new Synchronized();
                }
                ++idx;
            }
        }
    }

    @Override
    public <X extends VisitorSchedulable<T>, U extends Component> void process(@Nonnull T data) throws ProcessException {
        LinkedBlockingDeque<Task> queue = new LinkedBlockingDeque<Task>();
        ShutdownTask shutdown = new ShutdownTask(queue);
        ComponentFilterSet filters = this.scheduler.createComponentFilterSet();
        filters.add(NoFilter.class);
        new SequentialTask<T>(queue, this, data, filters, shutdown).commit();
        shutdown.commit();
        int threadPoolSize = this.getThreadPoolSize();
        String name = ThreadConfig.getConfig().getName() + "-worker-";
        long stackSize = ThreadConfig.get(ScheduleInstance.DEFAULT_STACK_SIZE);
        ArrayList<Worker> activeWorkers = new ArrayList<Worker>(threadPoolSize);
        for (int i = 0; i < threadPoolSize; ++i) {
            Worker worker = new Worker(name + i, queue, stackSize);
            worker.start();
            activeWorkers.add(worker);
        }
        List factories = (List)((Object)ThreadConfig.get(Detector.DETECTORS));
        ArrayList detectors = new ArrayList(factories.size());
        for (ReflectFactory factory : factories) {
            detectors.add(factory.create(activeWorkers.size()));
        }
        boolean shutdownInProgress = false;
        while (activeWorkers.size() > 0) {
            Thread thread = (Thread)activeWorkers.get(0);
            try {
                thread.join(this.checkEvery);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!thread.isAlive()) {
                activeWorkers.remove(0);
            }
            for (Detector detector : detectors) {
                if (detector.check(activeWorkers) || shutdownInProgress) continue;
                shutdownInProgress = true;
                new AssertionErrorTask(queue, new AssertionError()).commit();
            }
        }
        ((ShutdownTask)queue.pop()).throwPending();
        assert (queue.isEmpty()) : "Queue is not empty, size is " + queue.size();
    }

    @ImplementationName(iface=Detector.class, name="deadlock", filter=Filter.class)
    private static class DeadLock
    extends Detector {
        @Nonnull
        private final Logger logger = LoggerFactory.getLogger();
        @Nonnull
        ThreadMXBean threadManager = ManagementFactory.getThreadMXBean();
        @Nonnull
        private final List<Worker> blockedWorkers;

        protected DeadLock(@Nonnegative int size) {
            super(size);
            this.blockedWorkers = new ArrayList<Worker>(size);
        }

        @Override
        public boolean check(@Nonnull List<Worker> activeWorkers) {
            long[] deadlockedThreadIds = this.threadManager.findDeadlockedThreads();
            if (deadlockedThreadIds != null && deadlockedThreadIds.length > 0) {
                if (activeWorkers.size() > 0) {
                    Iterator<Worker> iter = activeWorkers.iterator();
                    block0: while (iter.hasNext()) {
                        Worker worker = iter.next();
                        for (long id : deadlockedThreadIds) {
                            if (worker.getId() == id) {
                                this.blockedWorkers.add(worker);
                                iter.remove();
                                continue block0;
                            }
                            ThreadInfo ti = this.threadManager.getThreadInfo(worker.getId());
                            if (ti == null || ti.getLockOwnerId() != id) continue;
                            this.blockedWorkers.add(worker);
                            iter.remove();
                            continue block0;
                        }
                    }
                }
                if (activeWorkers.size() == 0) {
                    assert (deadlockedThreadIds != null);
                    this.dump(deadlockedThreadIds, activeWorkers);
                }
                return false;
            }
            return true;
        }

        private void dump(@Nonnull long[] deadlockedThreadIds, @Nonnull List<Worker> activeWorkers) {
            this.logger.log(Level.SEVERE, "Deadlock detected during run:");
            for (ThreadInfo thread : this.threadManager.getThreadInfo(deadlockedThreadIds, true, true)) {
                if (thread == null) continue;
                boolean found = false;
                for (Worker worker : this.blockedWorkers) {
                    if (worker.getId() != thread.getThreadId()) continue;
                    found = true;
                    this.dump(thread, worker);
                    break;
                }
                if (found) continue;
                this.dump(thread, null);
            }
        }

        private void dump(@Nonnull ThreadInfo thread, @CheckForNull Worker worker) {
            LockInfo[] locks;
            String lockName;
            this.logger.log(Level.SEVERE, "  Thread ''{0}'' ({1}) {2} {3}", new Object[]{thread.getThreadName(), thread.getThreadId(), thread.getThreadState(), thread.isInNative() ? "(in native)" : ""});
            if (worker != null) {
                WorkerStatus status = worker.getStatus();
                this.logger.log(Level.SEVERE, "    Works on {0} during {1} ms", new Object[]{status.getCurrentTask(), (int)(System.currentTimeMillis() - status.getCurrentTaskStartOn())});
            }
            if ((lockName = thread.getLockName()) != null) {
                String lockOwnerName = thread.getLockOwnerName();
                this.logger.log(Level.SEVERE, "    Blocked on ''{0}'' owned by ''{1}'' ({2})", new Object[]{thread.getLockName(), lockOwnerName != null ? lockOwnerName : "<unknown>", thread.getLockOwnerId()});
            }
            if ((locks = thread.getLockedSynchronizers()).length > 0) {
                this.logger.log(Level.SEVERE, "    Owned locks:");
                for (LockInfo lock : locks) {
                    this.logger.log(Level.SEVERE, "      {0}", lock);
                }
            }
            this.logger.log(Level.SEVERE, "    Stack traces:");
            StackTraceElement[] traces = thread.getStackTrace();
            if (traces != null && traces.length > 0) {
                for (StackTraceElement stackTraceElement : traces) {
                    this.logger.log(Level.SEVERE, "      {0}", stackTraceElement);
                    for (MonitorInfo monitor : thread.getLockedMonitors()) {
                        if (!monitor.getLockedStackFrame().equals(stackTraceElement)) continue;
                        this.logger.log(Level.SEVERE, "      |- locked {0}", monitor);
                    }
                }
            } else {
                this.logger.log(Level.SEVERE, "      no stack traces available");
            }
        }

        private static class Filter
        implements ImplementationFilter {
            private Filter() {
            }

            @Override
            public boolean isValid() {
                try {
                    ThreadMXBean threadManager = ManagementFactory.getThreadMXBean();
                    return threadManager.isSynchronizerUsageSupported() && threadManager.isObjectMonitorUsageSupported();
                }
                catch (Throwable e) {
                    return false;
                }
            }
        }
    }

    @HasKeyId
    @ImplementationName(iface=Detector.class, name="log-long-running")
    private static class LongRunningLog
    extends Detector {
        @Nonnull
        private static final LongPropertyId TIMEOUT = LongPropertyId.create("sched.runner.thread.detector.log-long-running.timeout", "Duration allowed by the detector before logging long running worker (in ms)").addDefaultValue("3600000").withMin(0L);
        @Nonnull
        private final Logger logger = LoggerFactory.getLogger();
        @Nonnegative
        private final long timeout = ThreadConfig.get(TIMEOUT);
        @Nonnull
        private final Set<Task> signaledTasks = new HashSet<Task>();

        protected LongRunningLog(@Nonnegative int size) {
            super(size);
        }

        @Override
        public boolean check(@Nonnull List<Worker> activeWorkers) {
            long time = System.currentTimeMillis();
            for (Worker worker : activeWorkers) {
                WorkerStatus status = worker.getStatus();
                Task task = worker.getStatus().getCurrentTask();
                if (task == null || this.signaledTasks.contains(task) || (long)((int)(time - status.getCurrentTaskStartOn())) <= this.timeout) continue;
                this.signaledTasks.add(task);
                this.dump(worker);
            }
            return true;
        }

        private void dump(@Nonnull Worker worker) {
            StackTraceElement[] stackTrace = worker.getStackTrace();
            this.logger.log(Level.WARNING, "Long running worker detected:");
            if (worker.isAlive()) {
                WorkerStatus status = worker.getStatus();
                this.logger.log(Level.WARNING, "  Thread ''{0}'' ({1}) {2}", new Object[]{worker.getName(), worker.getId(), worker.getState()});
                this.logger.log(Level.WARNING, "    Works on {0} during {1} ms", new Object[]{status.getCurrentTask(), (int)(System.currentTimeMillis() - status.getCurrentTaskStartOn())});
                this.logger.log(Level.WARNING, "    Stack traces:");
                if (stackTrace != null) {
                    for (StackTraceElement stackTraceElement : stackTrace) {
                        this.logger.log(Level.WARNING, "      {0}", stackTraceElement);
                    }
                } else {
                    this.logger.log(Level.WARNING, "      no stack traces available");
                }
            }
        }
    }

    @HasKeyId
    @ImplementationName(iface=Detector.class, name="abort-long-running")
    private static class LongRunning
    extends Detector {
        @Nonnull
        private static final LongPropertyId TIMEOUT = LongPropertyId.create("sched.runner.thread.detector.abort-long-running.timeout", "Duration allowed by the detector before aborting compilation (in ms)").addDefaultValue("3600000").withMin(0L);
        @Nonnull
        private final Logger logger = LoggerFactory.getLogger();
        @Nonnegative
        private final long timeout = ThreadConfig.get(TIMEOUT);
        @Nonnull
        private final List<Worker> blockedWorkers;

        protected LongRunning(@Nonnegative int size) {
            super(size);
            this.blockedWorkers = new ArrayList<Worker>(size);
        }

        @Override
        public boolean check(@Nonnull List<Worker> activeWorkers) {
            long time = System.currentTimeMillis();
            Iterator<Worker> iter = activeWorkers.iterator();
            while (iter.hasNext()) {
                Worker worker = iter.next();
                WorkerStatus status = worker.getStatus();
                int duration = (int)(time - status.getCurrentTaskStartOn());
                if (status.getCurrentTask() == null || (long)duration <= this.timeout) continue;
                iter.remove();
                this.blockedWorkers.add(worker);
            }
            if (this.blockedWorkers.size() > 0) {
                if (activeWorkers.size() == 0) {
                    this.dump(this.blockedWorkers);
                }
                return false;
            }
            return true;
        }

        private void dump(@Nonnull List<Worker> workers) {
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            this.logger.log(Level.SEVERE, "Long running worker detected:");
            boolean atLeastOne = false;
            for (Worker worker : workers) {
                if (!worker.isAlive()) continue;
                WorkerStatus status = worker.getStatus();
                atLeastOne = true;
                this.logger.log(Level.SEVERE, "  Thread ''{0}'' ({1}) {2}", new Object[]{worker.getName(), worker.getId(), worker.getState()});
                this.logger.log(Level.SEVERE, "    Works on {0} during {1} ms", new Object[]{status.getCurrentTask(), (int)(System.currentTimeMillis() - status.getCurrentTaskStartOn())});
                this.logger.log(Level.SEVERE, "    Stack traces:");
                StackTraceElement[] traces = stackTraces.get(worker);
                if (traces != null) {
                    for (StackTraceElement stackTraceElement : traces) {
                        this.logger.log(Level.SEVERE, "      {0}", stackTraceElement);
                    }
                    continue;
                }
                this.logger.log(Level.SEVERE, "      no stack traces available");
            }
            if (!atLeastOne) {
                this.logger.log(Level.SEVERE, "  No thread. Wrong detection. Try to increase timeout with ''{0}'' property", TIMEOUT.getName());
            }
        }
    }

    @ImplementationName(iface=Detector.class, name="none")
    private static class None
    extends Detector {
        protected None(@Nonnegative int size) {
            super(size);
        }

        @Override
        public boolean check(@Nonnull List<Worker> activeWorkers) {
            return true;
        }
    }

    @HasKeyId
    @VariableName(value="detector")
    private static abstract class Detector {
        @Nonnull
        public static final ListPropertyId<ReflectFactory<Detector>> DETECTORS = ((ListPropertyId)((ListPropertyId)new ListPropertyId<Detector>("sched.runner.thread.detectors", "Set a list of detectors", new ReflectFactorySelector<Detector>(Detector.class).addArgType(Integer.TYPE).bypassAccessibility()).minElements(1).requiredIf(ScheduleInstance.DEFAULT_RUNNER.getClazz().isSubClassOf(MultiWorkersScheduleInstance.class))).addDefaultValue("deadlock,log-long-running")).addDefaultValue("log-long-running");

        protected Detector(@Nonnegative int size) {
        }

        public abstract boolean check(@Nonnull List<Worker> var1);
    }

    private static class SequentialTask<U extends Component>
    extends Task {
        @Nonnull
        private static final Logger logger = LoggerFactory.getLogger();
        @Nonnull
        private final U component;
        private int next = 0;
        @Nonnull
        private final MultiWorkersScheduleInstance<U> schedule;
        @Nonnull
        private final ComponentFilterSet currentFilters;

        public SequentialTask(@Nonnull Deque<Task> queue, @Nonnull MultiWorkersScheduleInstance<U> schedule, @Nonnull U component, @Nonnull ComponentFilterSet parentFilters, @Nonnull Task blocking) {
            super(queue, blocking);
            this.component = component;
            this.schedule = schedule;
            this.currentFilters = schedule.applyFilters(parentFilters, component);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean process() {
            block15: {
                while (this.next < this.schedule.steps.length) {
                    ScheduleInstance.SchedStep step = this.schedule.steps[this.next];
                    Synchronized sync = ((MultiWorkersScheduleInstance)this.schedule).syncs[this.next];
                    Schedulable instance = step.getInstance();
                    if (step.isSkippable(this.currentFilters)) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.log(Level.FINER, "Skipping {0} ''{1}'' on ''{2}'' because requiring {3} but having {4}", new Object[]{step instanceof ScheduleInstance.RunnableSchedStep ? "runner" : "adapter", step.getName(), this.component, step.getRequiredFilters(), this.currentFilters});
                        }
                        ++this.next;
                        continue;
                    }
                    if (sync != null && !sync.tryLock(this)) break block15;
                    ++this.next;
                    try {
                        if (instance instanceof AdapterSchedulable) {
                            Iterator dataIter = this.schedule.adaptWithLog((AdapterSchedulable)instance, this.component);
                            if (!dataIter.hasNext()) continue;
                            MultiWorkersScheduleInstance subSchedInstance = (MultiWorkersScheduleInstance)((ScheduleInstance.AdapterSchedStep)step).getSubSchedInstance();
                            assert (subSchedInstance != null);
                            this.prepare();
                            do {
                                new SequentialTask<Component>(this.queue, subSchedInstance, (Component)dataIter.next(), this.currentFilters, this).commit();
                            } while (dataIter.hasNext());
                        } else {
                            if (instance instanceof RunnableSchedulable) {
                                this.schedule.runWithLog((RunnableSchedulable)instance, this.component);
                                continue;
                            }
                            if (instance instanceof VisitorSchedulable) {
                                this.schedule.visitWithLog((VisitorSchedulable)instance, this.component);
                                continue;
                            }
                            throw new AssertionError();
                        }
                        this.commit();
                        break block15;
                    }
                    catch (ProcessException e) {
                        new ProcessExceptionTask((Deque<Task>)this.queue, e).commit();
                        break block15;
                    }
                    finally {
                        if (sync == null) continue;
                        sync.unlock();
                    }
                }
                this.notifyEnd();
            }
            return false;
        }

        @Nonnull
        public String toString() {
            return "a sequential task running " + Items.getName(this.schedule.steps[this.next - 1].getInstance().getClass()) + " on '" + this.component.toString() + "'";
        }
    }

    private static class AssertionErrorTask
    extends ShutdownTask {
        @Nonnull
        private final AssertionError error;

        public AssertionErrorTask(@Nonnull Deque<Task> queue, @Nonnull AssertionError error) {
            super(queue);
            this.error = error;
        }

        @Override
        public void throwPending() throws AssertionError {
            throw this.error;
        }

        @Override
        @Nonnull
        public String toString() {
            return "an error task (" + this.error.getClass().getCanonicalName() + ": " + ((Throwable)((Object)this.error)).getMessage();
        }
    }

    private static class ProcessExceptionTask
    extends ShutdownTask {
        @Nonnull
        private final ProcessException exception;

        public ProcessExceptionTask(@Nonnull Deque<Task> queue, @Nonnull ProcessException exception) {
            super(queue);
            this.exception = exception;
        }

        @Override
        public void throwPending() throws ProcessException {
            throw this.exception;
        }

        @Override
        @Nonnull
        public String toString() {
            return "an exception task (" + this.exception.getClass().getCanonicalName() + ": " + this.exception.getMessage();
        }
    }

    private static class ShutdownTask
    extends Task {
        public ShutdownTask(@Nonnull Deque<Task> queue) {
            super(queue);
        }

        public void throwPending() throws ProcessException, AssertionError {
        }

        @Override
        protected void enqueue() {
            this.queue.addFirst(this);
        }

        @Override
        public boolean process() {
            this.prepare();
            this.commit();
            return true;
        }

        @Nonnull
        public String toString() {
            return "a shutdown task";
        }
    }

    private static abstract class Task {
        @CheckForNull
        private final Task blocking;
        @Nonnull
        protected final Deque<Task> queue;
        @Nonnull
        private int blockCounter = 0;
        private boolean commited = false;

        public Task(@Nonnull Deque<Task> queue) {
            this.queue = queue;
            this.blocking = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task(@Nonnull Deque<Task> queue, @Nonnull Task blocking) {
            this.queue = queue;
            this.blocking = blocking;
            Task task = blocking;
            synchronized (task) {
                assert (!blocking.commited);
                ++blocking.blockCounter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            Task task = this;
            synchronized (task) {
                assert (!this.commited);
                assert (this.blockCounter >= 0) : "blockCounter = " + this.blockCounter;
                this.commited = true;
                if (this.blockCounter == 0) {
                    this.enqueue();
                }
            }
        }

        public synchronized void prepare() {
            assert (this.blockCounter == 0) : "blockCounter = " + this.blockCounter;
            assert (this.commited);
            this.commited = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyEnd() {
            if (this.blocking != null) {
                Task task = this.blocking;
                synchronized (task) {
                    assert (this.blocking.blockCounter > 0) : "blockCounter = " + this.blocking.blockCounter;
                    --this.blocking.blockCounter;
                    if (this.blocking.commited && this.blocking.blockCounter == 0) {
                        this.blocking.enqueue();
                    }
                }
            }
        }

        protected void enqueue() {
            assert (this.assertProcessable());
            this.queue.addLast(this);
        }

        public synchronized boolean assertProcessable() {
            assert (this.blockCounter == 0) : "blockCounter = " + this.blockCounter;
            assert (this.commited);
            return true;
        }

        abstract boolean process();
    }

    private static class Synchronized {
        @Nonnull
        private final List<Task> queue = new LinkedList<Task>();
        private boolean taken = false;

        private Synchronized() {
        }

        public synchronized boolean tryLock(@Nonnull Task task) {
            if (!this.taken) {
                this.taken = true;
                return true;
            }
            this.queue.add(task);
            return false;
        }

        public synchronized void unlock() {
            this.taken = false;
            if (!this.queue.isEmpty()) {
                this.queue.remove(0).enqueue();
            }
        }
    }

    private static class WorkerStatus {
        @CheckForNull
        private final Task currentTask;
        @Nonnegative
        private final long currentTaskStartOn;

        public WorkerStatus(@CheckForNull Task currentTask, @Nonnegative long currentTaskStartOn) {
            this.currentTask = currentTask;
            this.currentTaskStartOn = currentTaskStartOn;
        }

        @CheckForNull
        public Task getCurrentTask() {
            return this.currentTask;
        }

        @Nonnegative
        public long getCurrentTaskStartOn() {
            return this.currentTaskStartOn;
        }
    }

    private static class Worker
    extends Thread
    implements Runnable {
        @Nonnull
        BlockingDeque<Task> queue;
        @CheckForNull
        private Task currentTask = null;
        @Nonnegative
        private long currentTaskStartOn;
        @CheckForNull
        private ThreadTracerState state;
        @Nonnull
        private final Tracer tracer;

        public Worker(@Nonnull String name, @Nonnull BlockingDeque<Task> queue, @Nonnegative long stackSize) {
            super(null, null, name, stackSize);
            this.queue = queue;
            this.tracer = TracerFactory.getTracer();
            this.setDaemon(true);
        }

        /*
         * Exception decompiling
         */
        @Override
        @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 34[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void start() {
            this.state = this.tracer.getThreadState();
            super.start();
        }

        @Nonnull
        public synchronized WorkerStatus getStatus() {
            return new WorkerStatus(this.currentTask, this.currentTaskStartOn);
        }
    }
}

