/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.filter.NoFilter;
import com.android.sched.item.Component;
import com.android.sched.item.Feature;
import com.android.sched.item.Item;
import com.android.sched.item.Production;
import com.android.sched.item.TagOrMarker;
import com.android.sched.item.TagOrMarkerOrComponent;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.ComponentFilter;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.Optional;
import com.android.sched.schedulable.ProcessorSchedulable;
import com.android.sched.schedulable.Produce;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.ToSupport;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.schedulable.With;
import com.android.sched.scheduler.ComponentFilterSet;
import com.android.sched.scheduler.FeatureSet;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.ProductionSet;
import com.android.sched.scheduler.SchedulableNotConformException;
import com.android.sched.scheduler.Scheduler;
import com.android.sched.scheduler.TagOrMarkerOrComponentSet;
import com.android.sched.util.Reflect;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.log.LoggerFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ManagedRunnable
extends ManagedSchedulable {
    @Nonnull
    private final Scheduler scheduler;
    @Nonnull
    private final Class<? extends ProcessorSchedulable<? extends Component>> runnable;
    @Nonnull
    private final FeatureSet supportedFeatures;
    @Nonnull
    private final Map<FeatureSet, TagOrMarkerOrComponentSet> neededTags = new HashMap<FeatureSet, TagOrMarkerOrComponentSet>();
    @Nonnull
    private final Map<FeatureSet, TagOrMarkerOrComponentSet> unsupportedTags = new HashMap<FeatureSet, TagOrMarkerOrComponentSet>();
    @Nonnull
    private final TagOrMarkerOrComponentSet addedTags;
    @Nonnull
    private final TagOrMarkerOrComponentSet removedTags;
    @Nonnull
    private final TagOrMarkerOrComponentSet modifiedTags;
    @Nonnull
    private final TagOrMarkerOrComponentSet protectAddingTags;
    @Nonnull
    private final TagOrMarkerOrComponentSet protectRemovingTags;
    @Nonnull
    private final TagOrMarkerOrComponentSet protectModifyingTags;
    @Nonnull
    private final TagOrMarkerOrComponentSet unprotectByAddingTags;
    @Nonnull
    private final TagOrMarkerOrComponentSet unprotectByRemovingTags;
    @Nonnull
    private final ProductionSet productions;
    @Nonnull
    private final ComponentFilterSet neededFilters;
    @Nonnull
    private final FeatureSet filtersIfAll;
    @Nonnull
    private final FeatureSet filtersUnlessOne;
    @Nonnull
    private Class<? extends Component> exclusiveAccess;
    @Nonnull
    private Class<? extends Component> access;
    @Nonnull
    private final List<Class<?>> useTools = new ArrayList();
    @Nonnull
    private Class<? extends Component> schedulableOn;

    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    public ManagedRunnable(@Nonnull Scheduler scheduler, @Nonnull Class<? extends ProcessorSchedulable<? extends Component>> runnable) throws SchedulableNotConformException {
        super(runnable);
        this.scheduler = scheduler;
        this.runnable = runnable;
        this.addedTags = scheduler.createTagOrMarkerOrComponentSet();
        this.removedTags = scheduler.createTagOrMarkerOrComponentSet();
        this.modifiedTags = scheduler.createTagOrMarkerOrComponentSet();
        this.productions = scheduler.createProductionSet();
        this.protectAddingTags = scheduler.createTagOrMarkerOrComponentSet();
        this.protectRemovingTags = scheduler.createTagOrMarkerOrComponentSet();
        this.protectModifyingTags = scheduler.createTagOrMarkerOrComponentSet();
        this.unprotectByAddingTags = scheduler.createTagOrMarkerOrComponentSet();
        this.unprotectByRemovingTags = scheduler.createTagOrMarkerOrComponentSet();
        this.neededFilters = scheduler.createComponentFilterSet();
        this.filtersIfAll = scheduler.createFeatureSet();
        this.filtersUnlessOne = scheduler.createFeatureSet();
        this.supportedFeatures = scheduler.createFeatureSet();
        this.extractUse(runnable);
        this.extractSchedulableOn(runnable);
        this.extractAccesses(runnable);
        this.extractTransform(runnable);
        this.extractProduce(runnable);
        this.extractProtect(runnable);
        this.extractSupport(runnable);
        this.extractFilters(runnable);
        for (Class<?> tool : this.useTools) {
            this.extractTransform(tool);
            this.extractProduce(tool);
            this.extractProtect(tool);
            this.extractSupport(tool);
        }
        this.extractConstraint(runnable);
        this.extractOptional(runnable);
        for (Class<?> tool : this.useTools) {
            this.extractConstraint(tool);
            this.extractOptional(tool);
        }
        this.checkValidity();
        LoggerFactory.getLogger().log(Level.CONFIG, "{0}", this);
    }

    private void checkValidity() throws SchedulableNotConformException {
        if (this.addedTags.containsOne(this.removedTags)) {
            throw new SchedulableNotConformException("RunnableSchedulable '" + this.getName() + "' can not have same tags " + this.addedTags.getIntersection(this.removedTags).toString() + " in added and removed");
        }
        if (this.getAllPossibleNeededTags().containsOne(this.getAllPossibleUnsupportedTags())) {
            throw new SchedulableNotConformException("RunnableSchedulable '" + this.getName() + "' can not have same tags " + this.getAllPossibleNeededTags().getIntersection(this.getAllPossibleUnsupportedTags()).toString() + " in needed and unsupported");
        }
        if (this.removedTags.containsOne(this.getAllPossibleUnsupportedTags())) {
            throw new SchedulableNotConformException("RunnableSchedulable '" + this.getName() + "' can not have same tags " + this.removedTags.getIntersection(this.getAllPossibleUnsupportedTags()).toString() + " in removed and unsupported");
        }
    }

    @Nonnull
    public Class<? extends ProcessorSchedulable<? extends Component>> getRunnableSchedulable() {
        return this.runnable;
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getNeededTags(@Nonnull FeatureSet features) {
        TagOrMarkerOrComponentSet set = new TagOrMarkerOrComponentSet(this.getDefaultNeededTags());
        for (Map.Entry<FeatureSet, TagOrMarkerOrComponentSet> entry : this.neededTags.entrySet()) {
            if (!features.equals(entry.getKey())) continue;
            set.addAll(entry.getValue());
        }
        return set;
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getUnsupportedTags(@Nonnull FeatureSet features) {
        TagOrMarkerOrComponentSet set = new TagOrMarkerOrComponentSet(this.getDefaultUnsupportedTags());
        for (Map.Entry<FeatureSet, TagOrMarkerOrComponentSet> entry : this.unsupportedTags.entrySet()) {
            if (!features.equals(entry.getKey())) continue;
            set.addAll(entry.getValue());
        }
        return set;
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getAllPossibleNeededTags() {
        TagOrMarkerOrComponentSet set = this.scheduler.createTagOrMarkerOrComponentSet();
        for (TagOrMarkerOrComponentSet ts : this.neededTags.values()) {
            set.addAll(ts);
        }
        return set;
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getAllPossibleUnsupportedTags() {
        TagOrMarkerOrComponentSet set = this.scheduler.createTagOrMarkerOrComponentSet();
        for (TagOrMarkerOrComponentSet ts : this.unsupportedTags.values()) {
            set.addAll(ts);
        }
        return set;
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getDefaultNeededTags() {
        TagOrMarkerOrComponentSet set = new TagOrMarkerOrComponentSet(this.neededTags.get(this.supportedFeatures));
        return set;
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getDefaultUnsupportedTags() {
        TagOrMarkerOrComponentSet set = new TagOrMarkerOrComponentSet(this.unsupportedTags.get(this.supportedFeatures));
        return set;
    }

    public boolean isCompatible(@Nonnull FeatureSet features, @Nonnull TagOrMarkerOrComponentSet tags) {
        return tags.containsAll(this.getNeededTags(features)) && tags.containsNone(this.getUnsupportedTags(features));
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getAfterTags(@Nonnull TagOrMarkerOrComponentSet beforeTags) {
        TagOrMarkerOrComponentSet afterTags = new TagOrMarkerOrComponentSet(beforeTags);
        afterTags.addAll(this.getAddedTags());
        afterTags.removeAll(this.getRemovedTags());
        return afterTags;
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getMissingTags(@Nonnull FeatureSet features, @Nonnull TagOrMarkerOrComponentSet tags) {
        TagOrMarkerOrComponentSet needed = new TagOrMarkerOrComponentSet(this.getNeededTags(features));
        needed.removeAll(tags);
        return needed;
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getForbiddenTags(@Nonnull FeatureSet features, @Nonnull TagOrMarkerOrComponentSet tags) {
        TagOrMarkerOrComponentSet unsupported = new TagOrMarkerOrComponentSet(this.getUnsupportedTags(features));
        return unsupported.getIntersection(tags);
    }

    @Nonnegative
    public int getConstraintCount(@Nonnull FeatureSet features) {
        return this.getNeededTags(features).getSize() + this.getUnsupportedTags(features).getSize();
    }

    @Nonnegative
    public int getUnsatisfiedConstraintCount(@Nonnull FeatureSet features, @Nonnull TagOrMarkerOrComponentSet tags) {
        return this.getMissingTags(features, tags).getSize() + this.getForbiddenTags(features, tags).getSize();
    }

    @Nonnull
    public ProductionSet getProductions() {
        return this.productions.clone();
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getAddedTags() {
        return this.addedTags.clone();
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getRemovedTags() {
        return this.removedTags.clone();
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getModifiedTags() {
        return this.modifiedTags.clone();
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getProtectAddingTags() {
        return this.protectAddingTags.clone();
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getProtectRemovingTags() {
        return this.protectRemovingTags.clone();
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getProtectModifyingTags() {
        return this.protectModifyingTags.clone();
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getUnprotectByAddingTags() {
        return this.unprotectByAddingTags.clone();
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getUnprotectByRemovingTags() {
        return this.unprotectByRemovingTags.clone();
    }

    @Override
    @Nonnull
    public Class<? extends Component> getRunOn() {
        return this.schedulableOn;
    }

    @Nonnull
    public Class<? extends Component> getAccess() {
        return this.access;
    }

    @Nonnull
    public Class<? extends Component> getExclusiveAccess() {
        return this.exclusiveAccess;
    }

    @Nonnull
    public ComponentFilterSet getFilters(@Nonnull FeatureSet features) {
        if (features.containsAll(this.filtersIfAll) && features.containsNone(this.filtersUnlessOne)) {
            return this.neededFilters.clone();
        }
        ComponentFilterSet set = this.scheduler.createComponentFilterSet();
        set.add(NoFilter.class);
        return set;
    }

    @Override
    public boolean isVisitor() {
        return false;
    }

    @Override
    public boolean isRunnable() {
        return true;
    }

    @Nonnull
    public FeatureSet getSupportedFeatures() {
        return this.supportedFeatures.clone();
    }

    @Nonnull
    public List<FeatureSet> getOptionalFeatures() {
        ArrayList<FeatureSet> list = new ArrayList<FeatureSet>();
        list.addAll(this.neededTags.keySet());
        list.remove(this.supportedFeatures);
        return list;
    }

    @Override
    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Runnable '");
        sb.append(this.getName());
        sb.append('\'');
        return new String(sb);
    }

    private void extractUse(@Nonnull Class<?> cls) {
        Use uses = cls.getAnnotation(Use.class);
        if (uses != null && uses.value() != null) {
            for (Class<?> use : uses.value()) {
                if (this.useTools.contains(use)) continue;
                this.useTools.add(use);
                this.extractUse(use);
            }
        }
    }

    private void extractTransform(@Nonnull Class<?> cls) {
        Transform transform = cls.getAnnotation(Transform.class);
        if (transform != null) {
            if (transform.add() != null) {
                for (Class<? extends TagOrMarkerOrComponent> clazz : transform.add()) {
                    this.addedTags.add(clazz);
                }
            }
            if (transform.remove() != null) {
                for (Class<? extends TagOrMarkerOrComponent> clazz : transform.remove()) {
                    this.removedTags.add(clazz);
                }
            }
            if (transform.modify() != null) {
                for (Class<? extends TagOrMarkerOrComponent> clazz : transform.modify()) {
                    this.modifiedTags.add(clazz);
                }
            }
        }
    }

    private void extractProduce(@Nonnull Class<?> cls) {
        Produce produce = cls.getAnnotation(Produce.class);
        if (produce != null && produce.value() != null) {
            for (Class<? extends Production> production : produce.value()) {
                this.productions.add(production);
            }
        }
    }

    private void extractAccesses(@Nonnull Class<?> cls) {
        ExclusiveAccess exclusiveAccessAnnotation = cls.getAnnotation(ExclusiveAccess.class);
        this.exclusiveAccess = exclusiveAccessAnnotation != null ? exclusiveAccessAnnotation.value() : this.getRunOn();
        Access accessAnnotation = cls.getAnnotation(Access.class);
        this.access = accessAnnotation != null ? accessAnnotation.value() : this.getRunOn();
    }

    private void extractSupport(@Nonnull Class<?> cls) {
        Support support = cls.getAnnotation(Support.class);
        if (support != null && support.value() != null) {
            for (Class<? extends Feature> feature : support.value()) {
                this.supportedFeatures.add(feature);
            }
        }
    }

    private void extractFilters(@Nonnull Class<?> cls) {
        Filter filters = cls.getAnnotation(Filter.class);
        if (filters != null) {
            if (filters.value() != null) {
                for (Class<? extends ComponentFilter<? extends Component>> clazz : filters.value()) {
                    this.neededFilters.add(clazz);
                }
                for (Class<Item> clazz : filters.ifAll()) {
                    this.filtersIfAll.add(clazz);
                }
                for (Class<Item> clazz : filters.unlessOne()) {
                    this.filtersUnlessOne.add(clazz);
                }
            } else {
                this.neededFilters.add(NoFilter.class);
            }
        } else {
            this.neededFilters.add(NoFilter.class);
        }
    }

    private void extractOptional(@Nonnull Class<?> cls) {
        Optional optional = cls.getAnnotation(Optional.class);
        if (optional != null && optional.value() != null) {
            for (ToSupport toSupport : optional.value()) {
                TagOrMarkerOrComponentSet unsupport;
                FeatureSet features = this.scheduler.createFeatureSet();
                for (Class<? extends Feature> feature : toSupport.feature()) {
                    features.add(feature);
                }
                TagOrMarkerOrComponentSet needed = this.neededTags.get(features);
                if (needed == null) {
                    needed = this.scheduler.createTagOrMarkerOrComponentSet();
                    this.neededTags.put(features, needed);
                }
                if ((unsupport = this.unsupportedTags.get(features)) == null) {
                    unsupport = this.scheduler.createTagOrMarkerOrComponentSet();
                    this.unsupportedTags.put(features, unsupport);
                }
                if (toSupport.add() == null) continue;
                for (Constraint constraint : toSupport.add()) {
                    if (constraint.need() != null) {
                        for (Class<? extends TagOrMarkerOrComponent> tag : constraint.need()) {
                            needed.add(tag);
                        }
                    }
                    if (constraint.no() == null) continue;
                    for (Class<? extends TagOrMarkerOrComponent> tag : constraint.no()) {
                        unsupport.add(tag);
                    }
                }
            }
        }
    }

    private void extractConstraint(@Nonnull Class<?> cls) {
        Constraint constraint;
        TagOrMarkerOrComponentSet unsupport;
        TagOrMarkerOrComponentSet needed = this.neededTags.get(this.supportedFeatures);
        if (needed == null) {
            needed = this.scheduler.createTagOrMarkerOrComponentSet();
            this.neededTags.put(this.supportedFeatures, needed);
        }
        if ((unsupport = this.unsupportedTags.get(this.supportedFeatures)) == null) {
            unsupport = this.scheduler.createTagOrMarkerOrComponentSet();
            this.unsupportedTags.put(this.supportedFeatures, unsupport);
        }
        if ((constraint = cls.getAnnotation(Constraint.class)) != null) {
            if (constraint.need() != null) {
                for (Class<? extends TagOrMarkerOrComponent> tag : constraint.need()) {
                    needed.add(tag);
                }
            }
            if (constraint.no() != null) {
                for (Class<? extends TagOrMarkerOrComponent> tag : constraint.no()) {
                    unsupport.add(tag);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void extractProtect(@Nonnull Class<?> cls) {
        Protect protect = cls.getAnnotation(Protect.class);
        if (protect != null) {
            void var6_13;
            With[] withs;
            if (protect.add() != null) {
                for (Class<? extends TagOrMarkerOrComponent> clazz : protect.add()) {
                    this.protectAddingTags.add(clazz);
                }
            }
            if (protect.remove() != null) {
                for (Class<? extends TagOrMarkerOrComponent> clazz : protect.remove()) {
                    this.protectRemovingTags.add(clazz);
                }
            }
            if (protect.modify() != null) {
                for (Class<? extends TagOrMarkerOrComponent> clazz : protect.modify()) {
                    this.protectModifyingTags.add(clazz);
                }
            }
            With[] withArray = withs = protect.unprotect();
            int n = withArray.length;
            boolean bl = false;
            while (var6_13 < n) {
                With with = withArray[var6_13];
                if (with.add() != null) {
                    for (Class<? extends TagOrMarker> item : with.add()) {
                        this.unprotectByAddingTags.add(item);
                    }
                }
                if (with.remove() != null) {
                    for (Class<? extends TagOrMarker> item : with.remove()) {
                        this.unprotectByRemovingTags.add(item);
                    }
                }
                ++var6_13;
            }
        }
    }

    private void extractSchedulableOn(@Nonnull Class<? extends ProcessorSchedulable<? extends Component>> cls) {
        for (Type intf : Reflect.getAllGenericInSuperClassOrInterface(cls)) {
            ParameterizedType pt;
            if (!(intf instanceof ParameterizedType) || !ProcessorSchedulable.class.isAssignableFrom((Class)(pt = (ParameterizedType)intf).getRawType())) continue;
            this.schedulableOn = (Class)pt.getActualTypeArguments()[0];
            return;
        }
        throw new AssertionError();
    }
}

