/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.jacoco;

import com.android.jack.tools.jacoco.Constants;
import com.android.jack.tools.jacoco.ReportType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.ParserProperties;

public class Options {
    @Option(name="--metadata-file", metaVar="<file>", usage="coverage description file generated at compilation-time (repeatable)", required=true)
    @Nonnull
    private List<File> coverageDescriptionFiles = new ArrayList<File>();
    @Option(name="--coverage-file", metaVar="<file>", usage="coverage execution file generated at run-time (repeatable)", required=true)
    @Nonnull
    private List<File> coverageExecutionFiles = new ArrayList<File>();
    @Option(name="--report-dir", metaVar="<dir>", usage="the directory where the report must be generated.", required=true)
    @CheckForNull
    private File reportOutputDirectory;
    @Option(name="-h", aliases={"--help"}, usage="show help", help=true)
    private boolean showHelp;
    @Option(name="--version", usage="show version", help=true)
    private boolean showVersion;
    @Option(name="--source-dir", metaVar="<dir>", usage="a directory containing Java source files (repeatable)")
    @Nonnull
    private List<File> sourceFilesDirectories = new ArrayList<File>();
    @Option(name="--report-name", metaVar="<name>", usage="the name of the report")
    @Nonnull
    private String reportName = "Report";
    @Option(name="--report-type", metaVar="<type>", usage="the type of the report (default is HTML)")
    @Nonnull
    private ReportType reportType = Constants.DEFAULT_REPORT_TYPE;
    @Option(name="--output-encoding", metaVar="<encoding>", usage="the encoding for output report files (default is UTF-8)")
    @Nonnull
    private String outputReportEncoding = "UTF-8";
    @Option(name="--input-encoding", metaVar="<encoding>", usage="the encoding for input source files (default is UTF-8)")
    @Nonnull
    private String inputSourceFilesEncoding = "UTF-8";
    @Option(name="--tab-width", metaVar="<value>", usage="the width of tabs in source code (default is 4)")
    private int tabWidth = 4;
    @Option(name="--mapping-file", metaVar="<file>", usage="the mapping file to support shrinking and obfuscation")
    @CheckForNull
    private File mappingFile;

    @Nonnull
    public List<File> getCoverageDescriptionFiles() {
        return this.coverageDescriptionFiles;
    }

    @Nonnull
    public List<File> getCoverageExecutionFiles() {
        return this.coverageExecutionFiles;
    }

    @Nonnull
    public List<File> getSourceFilesDirectories() {
        return this.sourceFilesDirectories;
    }

    @Nonnull
    public File getReportOutputDirectory() {
        assert (this.reportOutputDirectory != null);
        return this.reportOutputDirectory;
    }

    @Nonnull
    public String getReportName() {
        return this.reportName;
    }

    @Nonnull
    public ReportType getReportType() {
        return this.reportType;
    }

    @Nonnull
    public String getOutputReportEncoding() {
        return this.outputReportEncoding;
    }

    @Nonnull
    public String getInputSourceFilesEncoding() {
        return this.inputSourceFilesEncoding;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    @CheckForNull
    public File getMappingFile() {
        return this.mappingFile;
    }

    public boolean askForHelp() {
        return this.showHelp;
    }

    public boolean askForVersion() {
        return this.showVersion;
    }

    @Nonnull
    public static Options parseCommandLine(@Nonnull List<String> list) throws CmdLineException {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser(options, ParserProperties.defaults().withUsageWidth(100));
        parser.parseArgument(list);
        parser.stopOptionParsing();
        return options;
    }
}

