/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.jacoco;

import javax.annotation.Nonnull;

public class NamingUtils {
    @Nonnull
    public static String fqNameToBinaryName(@Nonnull String typeName) {
        assert (typeName.indexOf(47) < 0);
        return typeName.replace('.', '/');
    }

    @Nonnull
    public static String binaryNameToFqName(@Nonnull String binaryName) {
        assert (binaryName.indexOf(46) < 0);
        return binaryName.replace('/', '.');
    }

    @Nonnull
    public static String fqNameToSignature(@Nonnull String typeName) {
        int arrayPos = typeName.lastIndexOf(91);
        if (arrayPos > 0) {
            assert (arrayPos == typeName.length() - 2);
            assert (typeName.charAt(arrayPos + 1) == ']');
            return '[' + NamingUtils.fqNameToSignature(typeName.substring(0, arrayPos));
        }
        if (typeName.equals("boolean")) {
            return "Z";
        }
        if (typeName.equals("byte")) {
            return "B";
        }
        if (typeName.equals("char")) {
            return "C";
        }
        if (typeName.equals("short")) {
            return "S";
        }
        if (typeName.equals("int")) {
            return "I";
        }
        if (typeName.equals("float")) {
            return "F";
        }
        if (typeName.equals("double")) {
            return "D";
        }
        if (typeName.equals("long")) {
            return "J";
        }
        if (typeName.equals("void")) {
            return "V";
        }
        return NamingUtils.binaryNameToSignature(NamingUtils.fqNameToBinaryName(typeName));
    }

    @Nonnull
    public static String binaryNameToSignature(@Nonnull String binaryName) {
        assert (binaryName.indexOf(46) < 0);
        return 'L' + binaryName + ';';
    }

    @Nonnull
    public static String signatureToBinaryName(@Nonnull String signature) {
        assert (signature.length() > 2);
        assert (signature.charAt(0) == 'L');
        int lastCharPos = signature.length() - 1;
        assert (lastCharPos > 1);
        assert (signature.charAt(lastCharPos) == ';');
        return signature.substring(1, lastCharPos);
    }
}

