/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.google.common.base.Function;
import com.android.jill.google.common.base.Joiner;
import com.android.jill.google.common.collect.Lists;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.Statusful;
import com.android.sched.util.file.StreamFileStatus;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.Capabilities;
import com.android.sched.vfs.ParentVDir;
import com.android.sched.vfs.ParentVFile;
import com.android.sched.vfs.UnionVFSReadOnlyException;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VPath;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class UnionVFS
extends BaseVFS<UnionVDir, UnionVFile>
implements VFS,
Statusful {
    private static final boolean SHALLOW_DELETE = true;
    @Nonnull
    List<VFS> vfsList;
    @Nonnull
    private final Set<Capabilities> capabilities;
    @Nonnull
    private final UnionVDir rootDir;
    private final boolean writable;
    private boolean used = false;

    public UnionVFS(@Nonnull List<VFS> vfsList) {
        assert (!vfsList.isEmpty());
        this.vfsList = vfsList;
        ArrayList<BaseVDir> wrappedDirs = new ArrayList<BaseVDir>(vfsList.size());
        for (VFS vfs : vfsList) {
            wrappedDirs.add((BaseVDir)vfs.getRootDir());
        }
        VFS topVfs = vfsList.get(0);
        EnumSet<Capabilities> capabilities = EnumSet.noneOf(Capabilities.class);
        block10: for (Capabilities topVfsCapability : topVfs.getCapabilities()) {
            switch (topVfsCapability) {
                case CASE_SENSITIVE: {
                    if (!this.isSupportedByAll(topVfsCapability)) continue block10;
                    capabilities.add(topVfsCapability);
                    continue block10;
                }
                case DIGEST: {
                    if (!this.isSupportedByAll(topVfsCapability)) continue block10;
                    capabilities.add(topVfsCapability);
                    continue block10;
                }
                case PARALLEL_READ: {
                    if (!this.isSupportedByAll(topVfsCapability)) continue block10;
                    capabilities.add(topVfsCapability);
                    continue block10;
                }
                case PARALLEL_WRITE: {
                    capabilities.add(topVfsCapability);
                    continue block10;
                }
                case READ: {
                    if (!this.isSupportedByAny(topVfsCapability)) continue block10;
                    capabilities.add(topVfsCapability);
                    continue block10;
                }
                case UNIQUE_ELEMENT: {
                    continue block10;
                }
                case WRITE: {
                    capabilities.add(topVfsCapability);
                    continue block10;
                }
            }
            throw new AssertionError();
        }
        this.capabilities = Collections.unmodifiableSet(capabilities);
        this.writable = topVfs.getCapabilities().contains((Object)Capabilities.WRITE);
        this.rootDir = new UnionVDir(this, wrappedDirs, this.writable);
    }

    private boolean isSupportedByAll(@Nonnull Capabilities capability) {
        boolean supportedByAll = true;
        for (VFS vfs : this.vfsList) {
            if (vfs.getCapabilities().contains((Object)capability)) continue;
            supportedByAll = false;
            break;
        }
        return supportedByAll;
    }

    private boolean isSupportedByAny(@Nonnull Capabilities capability) {
        boolean supportedByAny = false;
        for (VFS vfs : this.vfsList) {
            if (!vfs.getCapabilities().contains((Object)capability)) continue;
            supportedByAny = true;
            break;
        }
        return supportedByAny;
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.vfsList.get(0).getLocation();
    }

    @Override
    public void close() throws CannotCloseException {
        if (!this.closed) {
            for (VFS vfs : this.vfsList) {
                vfs.close();
            }
            this.closed = true;
        }
    }

    @Override
    @Nonnull
    public String getDescription() {
        StringBuilder sb = new StringBuilder("a union between \"");
        Joiner joiner = Joiner.on("\", \"");
        List<String> descriptionList = Lists.transform(this.vfsList, new Function<VFS, String>(){

            @Override
            public String apply(VFS vfs) {
                return vfs.getDescription();
            }
        });
        joiner.appendTo(sb, (Iterable<?>)descriptionList);
        return sb.append("\"").toString();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.vfsList.get(0).getPath();
    }

    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public boolean needsSequentialWriting() {
        return !this.capabilities.contains((Object)Capabilities.PARALLEL_WRITE);
    }

    @Override
    @Nonnull
    public Set<Capabilities> getCapabilities() {
        return this.capabilities;
    }

    @Override
    @Nonnull
    public UnionVDir getRootDir() {
        this.used = true;
        return this.rootDir;
    }

    @Override
    @Nonnull
    InputStream openRead(@Nonnull UnionVFile file) throws WrongPermissionException {
        return file.getWrappedFile().getInputStream();
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull UnionVFile file) throws WrongPermissionException {
        return this.openWrite(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull UnionVFile file, boolean append) throws WrongPermissionException {
        if (!this.isWritable()) {
            throw new UnsupportedOperationException();
        }
        UnionVFile unionVFile = file;
        synchronized (unionVFile) {
            if (!file.isWritable()) {
                try {
                    this.loadWritableFile(file);
                }
                catch (CannotCreateFileException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        return file.getWrappedFile().getOutputStream(append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWritableFile(@Nonnull UnionVFile file) throws CannotCreateFileException {
        UnionVDir parent;
        assert (this.isWritable());
        UnionVDir unionVDir = parent = (UnionVDir)file.getParent();
        synchronized (unionVDir) {
            if (!parent.isWritable()) {
                this.loadWritableDir(parent);
            }
        }
        file.setWritableWrappedFile(parent.getWrappedDirs().get(0).createVFile(file.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWritableDir(@Nonnull UnionVDir dir) throws CannotCreateFileException {
        assert (this.isWritable());
        UnionVDir parent = (UnionVDir)dir.getParent();
        assert (parent != null);
        UnionVDir unionVDir = parent;
        synchronized (unionVDir) {
            if (!parent.isWritable()) {
                this.loadWritableDir(parent);
            }
        }
        dir.addWritableWrappedDir(parent.getWrappedDirs().get(0).createVDir(dir.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    UnionVDir getVDir(@Nonnull UnionVDir parent, @Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        parent.ensureFullyLoaded();
        List<BaseVDir> parentWrappedDirs = parent.getWrappedDirs();
        BaseVDir dirToWrap = null;
        boolean writable = parent.isWritable();
        List<BaseVDir> list = parentWrappedDirs;
        synchronized (list) {
            for (BaseVDir parentWrappedDir : parentWrappedDirs) {
                try {
                    dirToWrap = parentWrappedDir.getVDir(name);
                    break;
                }
                catch (NoSuchFileException e) {
                    writable = false;
                }
            }
        }
        if (dirToWrap == null) {
            throw new NoSuchFileException(this.getVDirLocation(parent, name));
        }
        return new UnionVDir(this, parent, Lists.newArrayList(dirToWrap), writable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    UnionVFile getVFile(@Nonnull UnionVDir parent, @Nonnull String name) throws NotFileException, NoSuchFileException {
        parent.ensureFullyLoaded();
        List<BaseVDir> parentWrappedDirs = parent.getWrappedDirs();
        BaseVFile fileToWrap = null;
        boolean writable = parent.isWritable();
        List<BaseVDir> list = parentWrappedDirs;
        synchronized (list) {
            for (BaseVDir parentWrappedDir : parentWrappedDirs) {
                try {
                    fileToWrap = parentWrappedDir.getVFile(name);
                    break;
                }
                catch (NoSuchFileException e) {
                    writable = false;
                }
            }
        }
        if (fileToWrap == null) {
            throw new NoSuchFileException(this.getVFileLocation(parent, name));
        }
        return new UnionVFile(this, parent, fileToWrap, writable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    UnionVDir createVDir(@Nonnull UnionVDir parent, @Nonnull String name) throws CannotCreateFileException {
        UnionVDir vDir = null;
        try {
            vDir = this.getVDir(parent, name);
        }
        catch (NotDirectoryException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchFileException e) {
            // empty catch block
        }
        if (vDir == null) {
            if (!this.isWritable()) {
                throw new UnsupportedOperationException();
            }
            UnionVDir e = parent;
            synchronized (e) {
                if (!parent.isWritable()) {
                    this.loadWritableDir(parent);
                }
            }
            BaseVDir dirToWrap = parent.getWrappedDirs().get(0).createVDir(name);
            vDir = new UnionVDir(this, parent, Lists.newArrayList(dirToWrap), true);
        }
        return vDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    UnionVFile createVFile(@Nonnull UnionVDir parent, @Nonnull String name) throws CannotCreateFileException {
        UnionVFile vFile = null;
        try {
            vFile = this.getVFile(parent, name);
        }
        catch (NotFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchFileException e) {
            // empty catch block
        }
        if (vFile == null) {
            if (!this.isWritable()) {
                throw new UnsupportedOperationException();
            }
            UnionVDir e = parent;
            synchronized (e) {
                if (!parent.isWritable()) {
                    this.loadWritableDir(parent);
                }
            }
            BaseVFile fileToWrap = parent.getWrappedDirs().get(0).createVFile(name);
            vFile = new UnionVFile(this, parent, fileToWrap, true);
        }
        return vFile;
    }

    @Override
    @Nonnull
    void delete(@Nonnull UnionVFile file) throws CannotDeleteFileException {
        if (!this.isWritable()) {
            throw new UnsupportedOperationException();
        }
        try {
            UnionVDir parent = (UnionVDir)file.getParent();
            parent.internalDelete(file.getName());
        }
        catch (UnsupportedOperationException e) {
            throw new UnionVFSReadOnlyException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    Collection<? extends BaseVElement> list(@Nonnull UnionVDir dir) {
        List<BaseVDir> wrappedDirs;
        dir.ensureFullyLoaded();
        ArrayList<UnionVFile> unionElements = new ArrayList<UnionVFile>();
        List<BaseVDir> list = wrappedDirs = dir.getWrappedDirs();
        synchronized (list) {
            for (BaseVDir wrappedDir : wrappedDirs) {
                boolean writable = dir.isWritable();
                for (BaseVElement baseVElement : wrappedDir.list()) {
                    String currentName = baseVElement.getName();
                    boolean unionVElementExists = false;
                    for (BaseVElement baseVElement2 : unionElements) {
                        if (!baseVElement2.getName().equals(currentName)) continue;
                        unionVElementExists = true;
                        break;
                    }
                    if (!unionVElementExists) {
                        BaseVElement unionElement = baseVElement.isVDir() ? new UnionVDir(this, dir, Lists.newArrayList((BaseVDir)baseVElement), writable) : new UnionVFile(this, dir, (BaseVFile)baseVElement, writable);
                        unionElements.add((UnionVFile)unionElement);
                    }
                    writable = false;
                }
            }
        }
        return unionElements;
    }

    @Override
    boolean isEmpty(@Nonnull UnionVDir dir) {
        return this.list(dir).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    VPath getPathFromDir(@Nonnull UnionVDir parent, @Nonnull UnionVFile file) {
        List<BaseVDir> parentWrappedDirs;
        BaseVFile wrappedFile = file.getWrappedFile();
        BaseVFS<BaseVDir, BaseVFile> fileVFS = wrappedFile.getVFS();
        BaseVDir matchingDir = null;
        List<BaseVDir> list = parentWrappedDirs = parent.getWrappedDirs();
        synchronized (list) {
            for (BaseVDir parentWrappedDir : parentWrappedDirs) {
                if (parentWrappedDir.getVFS() != fileVFS) continue;
                matchingDir = parentWrappedDir;
                break;
            }
        }
        assert (matchingDir != null);
        return fileVFS.getPathFromDir(matchingDir, wrappedFile);
    }

    @Override
    @Nonnull
    VPath getPathFromRoot(@Nonnull UnionVFile file) {
        return file.getWrappedFile().getPathFromRoot();
    }

    @Override
    @Nonnull
    FileTime getLastModified(@Nonnull UnionVFile file) throws CannotGetModificationTimeException {
        return file.getWrappedFile().getLastModified();
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull UnionVFile file) {
        return file.getWrappedFile().getLocation();
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull UnionVDir parent, @Nonnull String name) {
        BaseVDir parentWrappedDir = parent.getWrappedDirs().get(0);
        return parentWrappedDir.getVFS().getVFileLocation(parentWrappedDir, name);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull UnionVDir parent, @Nonnull VPath path) {
        BaseVDir parentWrappedDir = parent.getWrappedDirs().get(0);
        return parentWrappedDir.getVFS().getVFileLocation(parentWrappedDir, path);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull UnionVDir dir) {
        return dir.getWrappedDirs().get(0).getLocation();
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull UnionVDir parent, @Nonnull String name) {
        BaseVDir parentWrappedDir = parent.getWrappedDirs().get(0);
        return parentWrappedDir.getVFS().getVDirLocation(parentWrappedDir, name);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull UnionVDir parent, @Nonnull VPath path) {
        BaseVDir parentWrappedDir = parent.getWrappedDirs().get(0);
        return parentWrappedDir.getVFS().getVDirLocation(parentWrappedDir, path);
    }

    @Override
    @Nonnull
    public StreamFileStatus getStatus() {
        if (!this.used) {
            return StreamFileStatus.NOT_USED;
        }
        if (this.closed) {
            return StreamFileStatus.CLOSED;
        }
        return StreamFileStatus.OPEN;
    }

    @Override
    @CheckForNull
    public String getInfoString() {
        return this.vfsList.get(0).getInfoString();
    }

    public String toString() {
        return "unionFS >> " + this.vfsList.toString();
    }

    static class UnionVDir
    extends ParentVDir {
        boolean fullyLoaded = false;
        private boolean writable;
        @Nonnull
        private final List<BaseVDir> wrappedDirs;

        public UnionVDir(@Nonnull BaseVFS<UnionVDir, UnionVFile> vfs, @Nonnull List<BaseVDir> wrappedDirs, boolean writable) {
            super(vfs, wrappedDirs.get(0).getName());
            this.wrappedDirs = Collections.synchronizedList(wrappedDirs);
            this.writable = writable;
        }

        public UnionVDir(@Nonnull BaseVFS<UnionVDir, UnionVFile> vfs, @Nonnull UnionVDir parent, @Nonnull List<BaseVDir> wrappedDirs, boolean writable) {
            super(vfs, parent, wrappedDirs.get(0).getName());
            this.wrappedDirs = Collections.synchronizedList(wrappedDirs);
            this.writable = writable;
        }

        @Override
        @Nonnull
        public VPath getPath() {
            return this.wrappedDirs.get(0).getPath();
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return this.wrappedDirs.get(0).getLocation();
        }

        @Nonnull
        List<BaseVDir> getWrappedDirs() {
            return this.wrappedDirs;
        }

        boolean isWritable() {
            return this.writable;
        }

        synchronized void addWritableWrappedDir(@Nonnull BaseVDir writableDir) {
            this.wrappedDirs.add(0, writableDir);
            this.writable = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void ensureFullyLoaded() {
            if (!this.fullyLoaded) {
                UnionVDir parent = (UnionVDir)this.getParent();
                if (parent != null) {
                    List<BaseVDir> parentWrappedDirs;
                    parent.ensureFullyLoaded();
                    List<BaseVDir> list = parentWrappedDirs = parent.getWrappedDirs();
                    synchronized (list) {
                        for (BaseVDir parentWrappedDir : parentWrappedDirs) {
                            boolean alreadyContained = false;
                            List<BaseVDir> list2 = this.wrappedDirs;
                            synchronized (list2) {
                                for (BaseVDir wrappedDir : this.wrappedDirs) {
                                    if (wrappedDir.getVFS() != parentWrappedDir.getVFS()) continue;
                                    alreadyContained = true;
                                    break;
                                }
                            }
                            if (alreadyContained) continue;
                            try {
                                BaseVDir newWrappedDir = parentWrappedDir.getVDir(this.name);
                                this.wrappedDirs.add(newWrappedDir);
                            }
                            catch (NotDirectoryException e) {
                                throw new AssertionError((Object)e);
                            }
                            catch (NoSuchFileException noSuchFileException) {
                            }
                        }
                    }
                }
                this.fullyLoaded = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void internalDelete(@Nonnull String name) throws CannotDeleteFileException {
            this.ensureFullyLoaded();
            List<BaseVDir> list = this.wrappedDirs;
            synchronized (list) {
                for (BaseVDir wrappedDir : this.wrappedDirs) {
                    try {
                        BaseVFile vFile = wrappedDir.getVFile(name);
                        wrappedDir.delete(vFile);
                        return;
                    }
                    catch (NotFileException notFileException) {
                    }
                    catch (NoSuchFileException noSuchFileException) {
                    }
                }
            }
        }
    }

    static class UnionVFile
    extends ParentVFile {
        @Nonnull
        private BaseVFile wrappedFile;
        private boolean writable;

        public UnionVFile(@Nonnull BaseVFS<UnionVDir, UnionVFile> vfs, @Nonnull UnionVDir parent, @Nonnull BaseVFile wrappedFile, boolean writable) {
            super(vfs, parent, wrappedFile.getName());
            this.wrappedFile = wrappedFile;
            this.writable = writable;
        }

        @Override
        @Nonnull
        public VPath getPath() {
            return this.wrappedFile.getPath();
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return this.wrappedFile.getLocation();
        }

        @Nonnull
        BaseVFile getWrappedFile() {
            return this.wrappedFile;
        }

        boolean isWritable() {
            return this.writable;
        }

        synchronized void setWritableWrappedFile(BaseVFile writableFile) {
            this.wrappedFile = writableFile;
            this.writable = true;
        }
    }
}

