/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

abstract class InMemoryVDir
extends BaseVDir {
    @Nonnull
    private final Map<String, BaseVElement> map = new HashMap<String, BaseVElement>();

    public InMemoryVDir(@Nonnull BaseVFS<? extends InMemoryVDir, ? extends BaseVFile> vfs, @Nonnull String name) {
        super(vfs, name);
    }

    @Override
    @Nonnull
    public synchronized BaseVDir getVDir(@Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        assert (!this.vfs.isClosed());
        BaseVElement element = this.map.get(name);
        if (element != null) {
            if (element.isVDir()) {
                return (BaseVDir)element;
            }
            throw new NotDirectoryException(this.vfs.getVDirLocation(this, name));
        }
        throw new NoSuchFileException(this.vfs.getVDirLocation(this, name));
    }

    @Override
    @Nonnull
    public synchronized BaseVFile getVFile(@Nonnull String name) throws NoSuchFileException, NotFileException {
        assert (!this.vfs.isClosed());
        BaseVElement element = this.map.get(name);
        if (element != null) {
            if (!element.isVDir()) {
                return (BaseVFile)element;
            }
            throw new NotFileException(this.vfs.getVFileLocation(this, name));
        }
        throw new NoSuchFileException(this.vfs.getVFileLocation(this, name));
    }

    @Override
    @Nonnull
    public synchronized BaseVDir createVDir(@Nonnull String name) throws CannotCreateFileException {
        try {
            return this.getVDir(name);
        }
        catch (NoSuchFileException e) {
            InMemoryVDir dir = this.vfs.createVDir(this, name);
            this.map.put(name, dir);
            return dir;
        }
        catch (NotDirectoryException e) {
            throw new CannotCreateFileException(this.vfs.getVDirLocation(this, name), (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public synchronized BaseVFile createVFile(@Nonnull String name) throws CannotCreateFileException {
        try {
            return this.getVFile(name);
        }
        catch (NoSuchFileException e) {
            Object file = this.vfs.createVFile(this, name);
            this.map.put(name, (BaseVElement)file);
            return file;
        }
        catch (NotFileException e) {
            throw new CannotCreateFileException(this.vfs.getVFileLocation(this, name), (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public synchronized Collection<? extends BaseVElement> list() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    synchronized void internalDelete(@Nonnull String name) {
        this.map.remove(name);
    }

    @CheckForNull
    synchronized BaseVElement getFromCache(@Nonnull String name) {
        return this.map.get(name);
    }

    synchronized void putInCache(@Nonnull String name, @Nonnull BaseVElement vElement) {
        this.map.put(name, vElement);
    }

    synchronized Collection<? extends BaseVElement> getAllFromCache() {
        return this.map.values();
    }
}

