/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.InputOutputVFile;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.VFile;
import com.android.sched.vfs.VPath;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.attribute.FileTime;

public class GenericInputOutputVFile
implements InputOutputVFile {
    @Nonnull
    private final VFile file;

    GenericInputOutputVFile(@Nonnull VFile file) {
        this.file = file;
    }

    @Override
    public boolean isVDir() {
        return false;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.file.getName();
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.file.getLocation();
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws WrongPermissionException {
        return this.file.getInputStream();
    }

    @Override
    @Nonnull
    public OutputStream getOutputStream() throws WrongPermissionException {
        return this.getOutputStream(false);
    }

    @Override
    @Nonnull
    public OutputStream getOutputStream(boolean append) throws WrongPermissionException {
        return this.file.getOutputStream(append);
    }

    @Override
    @Nonnull
    public PrintStream getPrintStream(boolean append) throws WrongPermissionException {
        return new PrintStream(this.getOutputStream(append));
    }

    @Override
    public void delete() throws CannotDeleteFileException {
        this.file.delete();
    }

    @Override
    @CheckForNull
    public String getDigest() {
        return this.file.getDigest();
    }

    @Override
    @Nonnull
    public VPath getPathFromRoot() {
        return this.file.getPathFromRoot();
    }

    @Override
    @Nonnull
    public FileTime getLastModified() throws CannotGetModificationTimeException {
        return this.file.getLastModified();
    }

    @Override
    @Nonnull
    public VFile getVFile() {
        return this.file;
    }

    @Override
    public void copy(@Nonnull InputVFile inputFile) throws WrongPermissionException, CannotCloseException, CannotReadException, CannotWriteException {
        this.file.copy(inputFile.getVFile());
    }
}

