/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.Capabilities;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VFSStatCategory;
import com.android.sched.vfs.VFile;
import com.android.sched.vfs.VPath;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class DeflateFS
extends BaseVFS<DeflateVDir, DeflateVFile>
implements VFS {
    @Nonnull
    private final BaseVFS<BaseVDir, BaseVFile> vfs;

    public DeflateFS(@Nonnull VFS vfs) {
        this.vfs = (BaseVFS)vfs;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "deflater wrapper";
    }

    @Override
    @Nonnull
    public Set<Capabilities> getCapabilities() {
        return this.vfs.getCapabilities();
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.vfs.getLocation();
    }

    @Override
    public void close() throws CannotCloseException {
        this.vfs.close();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.vfs.getPath();
    }

    @Override
    @Nonnull
    public DeflateVDir getRootDir() {
        return new DeflateVDir(this, (BaseVDir)this.vfs.getRootDir());
    }

    @Override
    @Nonnull
    InputStream openRead(@Nonnull DeflateVFile file) throws WrongPermissionException {
        return new InflaterInputStream(this.vfs.openRead(file.getWrappedFile()));
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull DeflateVFile file) throws WrongPermissionException {
        return this.openWrite(file, false);
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull DeflateVFile file, boolean append) throws WrongPermissionException {
        return new DeflaterOutputStream(this.vfs.openWrite(file.getWrappedFile(), append));
    }

    @Override
    @Nonnull
    void delete(@Nonnull DeflateVFile file) throws CannotDeleteFileException {
        this.vfs.delete(file.getWrappedFile());
    }

    @Override
    @Nonnull
    Collection<? extends BaseVElement> list(@Nonnull DeflateVDir dir) {
        Collection<BaseVElement> elements = this.vfs.list(dir.getWrappedDir());
        ArrayList<DeflateVDir> newElements = new ArrayList<DeflateVDir>(elements.size());
        for (BaseVElement element : elements) {
            BaseVElement newElement = element.isVDir() ? new DeflateVDir(this, (BaseVDir)element) : new DeflateVFile(this, (BaseVFile)element);
            newElements.add((DeflateVDir)newElement);
        }
        return newElements;
    }

    @Override
    boolean isEmpty(@Nonnull DeflateVDir dir) {
        return this.vfs.isEmpty(dir);
    }

    @Override
    @Nonnull
    FileTime getLastModified(@Nonnull DeflateVFile file) throws CannotGetModificationTimeException {
        return this.vfs.getLastModified(file.getWrappedFile());
    }

    @Override
    @Nonnull
    DeflateVFile createVFile(@Nonnull DeflateVDir parent, @Nonnull String name) throws CannotCreateFileException {
        return new DeflateVFile(this, this.vfs.createVFile(parent.getWrappedDir(), name));
    }

    @Override
    @Nonnull
    DeflateVDir createVDir(@Nonnull DeflateVDir parent, @Nonnull String name) throws CannotCreateFileException {
        return new DeflateVDir(this, this.vfs.createVDir(parent.getWrappedDir(), name));
    }

    @Override
    @Nonnull
    DeflateVDir getVDir(@Nonnull DeflateVDir parent, @Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        return new DeflateVDir(this, this.vfs.getVDir(parent.getWrappedDir(), name));
    }

    @Override
    @Nonnull
    DeflateVFile getVFile(@Nonnull DeflateVDir parent, @Nonnull String name) throws NotFileException, NoSuchFileException {
        return new DeflateVFile(this, this.vfs.getVFile(parent.getWrappedDir(), name));
    }

    @Override
    public boolean needsSequentialWriting() {
        return this.vfs.needsSequentialWriting();
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull DeflateVFile file) {
        return this.vfs.getVFileLocation(file.getWrappedFile());
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull DeflateVDir parent, @Nonnull String name) {
        return this.vfs.getVFileLocation(parent.getWrappedDir(), name);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull DeflateVDir dir) {
        return this.vfs.getVDirLocation(dir.getWrappedDir());
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull DeflateVDir parent, @Nonnull String name) {
        return this.vfs.getVDirLocation(parent.getWrappedDir(), name);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull DeflateVDir parent, @Nonnull VPath path) {
        return this.vfs.getVFileLocation(parent.getWrappedDir(), path);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull DeflateVDir parent, @Nonnull VPath path) {
        return this.vfs.getVDirLocation(parent.getWrappedDir(), path);
    }

    @Override
    @Nonnull
    VPath getPathFromDir(@Nonnull DeflateVDir parent, @Nonnull DeflateVFile file) {
        return this.vfs.getPathFromDir(parent.getWrappedDir(), file);
    }

    @Override
    @Nonnull
    VPath getPathFromRoot(@Nonnull DeflateVFile file) {
        return this.vfs.getPathFromRoot(file.getWrappedFile());
    }

    @Override
    @CheckForNull
    public String getDigest() {
        return this.vfs.getDigest();
    }

    public String toString() {
        return "deflateFS >> " + this.vfs.toString();
    }

    @Override
    public void copy(@Nonnull VFile srcFile, @Nonnull DeflateVFile dstFile) throws WrongPermissionException, CannotCloseException, CannotReadException, CannotWriteException {
        if (srcFile instanceof DeflateVFile) {
            this.vfs.copy(((DeflateVFile)srcFile).getWrappedFile(), dstFile.getWrappedFile());
            VFSStatCategory.OPTIMIZED_COPIES.getPercentStat(this.getTracer(), this.getInfoString()).addTrue();
        } else {
            super.copy(srcFile, dstFile);
        }
    }

    @Override
    @CheckForNull
    public String getInfoString() {
        return this.vfs.getInfoString();
    }

    static class DeflateVDir
    extends BaseVDir {
        @Nonnull
        private final BaseVDir wrappedFile;

        public DeflateVDir(@Nonnull BaseVFS<DeflateVDir, DeflateVFile> vfs, @Nonnull BaseVDir wrappedFile) {
            super(vfs, wrappedFile.getName());
            this.wrappedFile = wrappedFile;
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return this.wrappedFile.getLocation();
        }

        @Override
        @Nonnull
        public VPath getPath() {
            return this.wrappedFile.getPath();
        }

        @Nonnull
        public BaseVDir getWrappedDir() {
            return this.wrappedFile;
        }
    }

    static class DeflateVFile
    extends BaseVFile {
        @Nonnull
        private final BaseVFile wrappedFile;

        public DeflateVFile(@Nonnull BaseVFS<DeflateVDir, DeflateVFile> vfs, @Nonnull BaseVFile wrappedFile) {
            super(vfs, wrappedFile.getName());
            this.wrappedFile = wrappedFile;
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return this.wrappedFile.getLocation();
        }

        @Override
        @Nonnull
        public VPath getPath() {
            return this.wrappedFile.getPath();
        }

        @Nonnull
        public BaseVFile getWrappedFile() {
            return this.wrappedFile;
        }

        @Override
        @CheckForNull
        public String getDigest() {
            return this.wrappedFile.getDigest();
        }
    }
}

