/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.google.common.base.Splitter;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.MessageDigestFactory;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.expression.LongExpression;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.config.id.IntegerPropertyId;
import com.android.sched.util.config.id.MessageDigestPropertyId;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.Statusful;
import com.android.sched.util.file.StreamFileStatus;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.ColumnAndLineLocation;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.BadVFSFormatException;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.Capabilities;
import com.android.sched.vfs.InMemoryVDir;
import com.android.sched.vfs.ParentVFile;
import com.android.sched.vfs.RuntimeBadVFSFormatException;
import com.android.sched.vfs.VDir;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VPath;
import com.android.sched.vfs.WrongFileFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;

@HasKeyId
public class CaseInsensitiveFS
extends BaseVFS<CaseInsensitiveVDir, CaseInsensitiveVFile>
implements VFS,
Statusful {
    static final String INDEX_NAME = "index";
    static final String DEBUG_NAME = "index.dbg";
    public static final IntegerPropertyId NB_GROUP = IntegerPropertyId.create("sched.vfs.case-insensitive.group.count", "Number of directory used to encode a path name").withMin(0L).addDefaultValue(1);
    public static final IntegerPropertyId SZ_GROUP = IntegerPropertyId.create("sched.vfs.case-insensitive.group.size", "Number of letters in directory name used to encode a path name").requiredIf(NB_GROUP.getValue().isGreater(LongExpression.getConstant(0L))).withMin(0L).addDefaultValue(2);
    @Nonnull
    public static final MessageDigestPropertyId ALGO = MessageDigestPropertyId.create("sched.vfs.case-insensitive.algo", "Algorithm used to encode a path name").addDefaultValue("SHA");
    @Nonnull
    public static final BooleanPropertyId DEBUG = BooleanPropertyId.create("sched.vfs.case-insensitive.debug", "generate an index file 'index.dbg' for debugging purpose").addDefaultValue(false);
    @Nonnull
    private static final char INDEX_SEPARATOR = '/';
    @Nonnull
    private static final Splitter splitter = Splitter.on('/');
    @Nonnegative
    private final int numGroups;
    @Nonnegative
    private final int groupSize;
    @Nonnull
    private final MessageDigestFactory mdf;
    private final boolean debug;
    @Nonnull
    private final CaseInsensitiveVDir root = new CaseInsensitiveVDir(this, null, "");
    @Nonnull
    private final Set<Capabilities> capabilities;
    @Nonnull
    private final BaseVFS<BaseVDir, BaseVFile> vfs;
    private boolean used = false;
    @Nonnull
    private static final byte[] code = "0123456789ABCDEF".getBytes();

    @Override
    @Nonnull
    public String getDescription() {
        return "case insensitive wrapper";
    }

    public CaseInsensitiveFS(@Nonnull VFS vfs) throws BadVFSFormatException {
        this(vfs, ThreadConfig.get(NB_GROUP).intValue(), ThreadConfig.get(SZ_GROUP).intValue(), ThreadConfig.get(ALGO), ThreadConfig.get(DEBUG));
    }

    public CaseInsensitiveFS(@Nonnull VFS vfs, int numGroups, int groupSize, @Nonnull MessageDigestFactory mdf, boolean debug) throws BadVFSFormatException {
        this.vfs = (BaseVFS)vfs;
        EnumSet<Capabilities> capabilities = EnumSet.copyOf(vfs.getCapabilities());
        capabilities.add(Capabilities.CASE_SENSITIVE);
        capabilities.add(Capabilities.UNIQUE_ELEMENT);
        this.capabilities = Collections.unmodifiableSet(capabilities);
        this.numGroups = numGroups;
        this.groupSize = groupSize;
        this.mdf = mdf;
        this.debug = debug;
        this.initVFS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initVFS() throws BadVFSFormatException {
        BaseVFile file;
        BufferedReader reader;
        block28: {
            reader = null;
            file = null;
            try {
                file = ((BaseVDir)this.vfs.getRootDir()).getVFile(INDEX_NAME);
            }
            catch (NoSuchFileException e) {
                if (!((BaseVDir)this.vfs.getRootDir()).isEmpty()) {
                    throw new BadVFSFormatException(this, this.vfs.getLocation(), e);
                }
                if (reader == null) return;
                assert (file != null);
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            catch (NotFileException e) {
                throw new BadVFSFormatException(this, this.vfs.getLocation(), e);
            }
            reader = new LineNumberReader(new InputStreamReader(file.getInputStream()));
            break block28;
            catch (WrongPermissionException e) {
                throw new BadVFSFormatException(this, this.vfs.getLocation(), e);
            }
            finally {
                if (reader != null) {
                    assert (file != null);
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            block22: while (true) {
                String line = ((LineNumberReader)reader).readLine();
                if (line == null) return;
                if (line.charAt(1) != ':') {
                    throw new BadVFSFormatException(this, this.vfs.getLocation(), new WrongFileFormatException(new ColumnAndLineLocation(file.getLocation(), ((LineNumberReader)reader).getLineNumber())));
                }
                char type = line.charAt(0);
                switch (type) {
                    case 'd': {
                        this.loadVDir(line.substring(2));
                        continue block22;
                    }
                    case 'f': {
                        this.loadVFile(line.substring(2));
                        continue block22;
                    }
                }
                break;
            }
            throw new BadVFSFormatException(this, this.vfs.getLocation(), new WrongFileFormatException(new ColumnAndLineLocation(file.getLocation(), ((LineNumberReader)reader).getLineNumber())));
        }
        catch (NotDirectoryException | NotFileException e) {
            throw new BadVFSFormatException(this, this.vfs.getLocation(), e);
        }
        catch (IOException e) {
            throw new BadVFSFormatException(this, this.vfs.getLocation(), e);
        }
    }

    private void loadVDir(@Nonnull String path) throws NotDirectoryException {
        CaseInsensitiveVDir currentDir = this.getRootDir();
        Iterator<String> pathElementIterator = splitter.split(path).iterator();
        String pathElement = null;
        while (pathElementIterator.hasNext()) {
            pathElement = pathElementIterator.next();
            assert (!pathElement.isEmpty());
            currentDir = this.loadVDir(currentDir, pathElement);
        }
    }

    private void loadVFile(@Nonnull String path) throws NotDirectoryException, NotFileException {
        CaseInsensitiveVDir currentDir = this.getRootDir();
        Iterator<String> pathElementIterator = splitter.split(path).iterator();
        String pathElement = null;
        while (pathElementIterator.hasNext()) {
            pathElement = pathElementIterator.next();
            assert (!pathElement.isEmpty());
            if (!pathElementIterator.hasNext()) continue;
            currentDir = this.loadVDir(currentDir, pathElement);
        }
        this.loadVFile(currentDir, pathElement);
    }

    @Override
    @Nonnull
    public Set<Capabilities> getCapabilities() {
        return this.capabilities;
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.vfs.getLocation();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.vfs.getPath();
    }

    @Override
    @Nonnull
    public CaseInsensitiveVDir getRootDir() {
        this.used = true;
        return this.root;
    }

    @Override
    public synchronized void close() throws CannotCloseException {
        if (!this.closed) {
            try {
                PrintStream printer = new PrintStream(((BaseVDir)this.vfs.getRootDir()).createVFile(INDEX_NAME).getOutputStream());
                this.printIndex(printer, this.getRootDir());
                printer.flush();
                printer.close();
                if (this.debug) {
                    printer = new PrintStream(((BaseVDir)this.vfs.getRootDir()).createVFile(DEBUG_NAME).getOutputStream());
                    this.printDebug(printer, this.getRootDir());
                    printer.flush();
                    printer.close();
                }
            }
            catch (CannotCreateFileException | WrongPermissionException e) {
                throw new CannotCloseException((HasLocation)this, (Exception)e);
            }
            this.vfs.close();
            this.closed = true;
        }
    }

    private void printIndex(@Nonnull PrintStream printer, @Nonnull InMemoryVDir dir) {
        Collection<? extends BaseVElement> elements = dir.list();
        if (elements.size() > 0) {
            for (BaseVElement baseVElement : elements) {
                if (baseVElement.isVDir()) {
                    this.printIndex(printer, (InMemoryVDir)baseVElement);
                    continue;
                }
                CaseInsensitiveVFile file = (CaseInsensitiveVFile)baseVElement;
                printer.print("f:");
                printer.print(file.getPath().getPathAsString('/'));
                printer.println();
            }
        } else {
            printer.print("d:");
            printer.print(dir.getPath().getPathAsString('/'));
            printer.println();
        }
    }

    private void printDebug(@Nonnull PrintStream printer, @Nonnull InMemoryVDir dir) {
        Collection<? extends BaseVElement> elements = dir.list();
        printer.print("d:");
        printer.print(dir.getPath().getPathAsString(File.separatorChar));
        printer.println();
        for (BaseVElement baseVElement : elements) {
            if (baseVElement.isVDir()) {
                this.printDebug(printer, (InMemoryVDir)baseVElement);
                continue;
            }
            CaseInsensitiveVFile file = (CaseInsensitiveVFile)baseVElement;
            printer.print("f:");
            printer.print(this.loadAndGetEncodedFile(file).getPath().getPathAsString(File.separatorChar));
            printer.print(":");
            printer.print(file.getPath().getPathAsString(File.separatorChar));
            printer.println();
        }
    }

    @Nonnull
    private BaseVFile loadAndGetEncodedFile(@Nonnull CaseInsensitiveVFile file) {
        BaseVFile encodedFile = file.getEncodedFile();
        if (encodedFile == null) {
            try {
                encodedFile = ((BaseVDir)this.vfs.getRootDir()).getVFile(this.encode(file.getPath()));
                file.setEncodedFile(encodedFile);
            }
            catch (NoSuchFileException | NotDirectoryException | NotFileException e) {
                throw new RuntimeBadVFSFormatException(this.vfs, this.vfs.getLocation(), e);
            }
        }
        return encodedFile;
    }

    @Override
    @Nonnull
    InputStream openRead(@Nonnull CaseInsensitiveVFile file) throws WrongPermissionException {
        assert (!this.isClosed());
        return this.loadAndGetEncodedFile(file).getInputStream();
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull CaseInsensitiveVFile file) throws WrongPermissionException {
        return this.openWrite(file, false);
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull CaseInsensitiveVFile file, boolean append) throws WrongPermissionException {
        assert (!this.isClosed());
        return this.loadAndGetEncodedFile(file).getOutputStream(append);
    }

    @Override
    @Nonnull
    CaseInsensitiveVDir getVDir(@Nonnull CaseInsensitiveVDir parent, @Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        CaseInsensitiveVDir vDir = this.getVDirFromCache(parent, name);
        if (vDir != null) {
            return vDir;
        }
        throw new NoSuchFileException(this.getVDirLocation(parent, name));
    }

    @Override
    @Nonnull
    CaseInsensitiveVFile getVFile(@Nonnull CaseInsensitiveVDir parent, @Nonnull String name) throws NotFileException, NoSuchFileException {
        CaseInsensitiveVFile vFile = this.getVFileFromCache(parent, name);
        if (vFile != null) {
            return vFile;
        }
        throw new NoSuchFileException(this.getVFileLocation(parent, name));
    }

    @CheckForNull
    CaseInsensitiveVFile getVFileFromCache(@Nonnull CaseInsensitiveVDir parent, @Nonnull String name) throws NotFileException {
        BaseVElement element = parent.getFromCache(name);
        if (element == null) {
            return null;
        }
        if (!element.isVDir()) {
            return (CaseInsensitiveVFile)element;
        }
        throw new NotFileException(this.getVFileLocation(parent, name));
    }

    @CheckForNull
    CaseInsensitiveVDir getVDirFromCache(@Nonnull CaseInsensitiveVDir parent, @Nonnull String name) throws NotDirectoryException {
        BaseVElement element = parent.getFromCache(name);
        if (element == null) {
            return null;
        }
        if (element.isVDir()) {
            return (CaseInsensitiveVDir)element;
        }
        throw new NotDirectoryException(this.getVDirLocation(parent, name));
    }

    @Override
    @Nonnull
    CaseInsensitiveVDir createVDir(@Nonnull CaseInsensitiveVDir parent, @Nonnull String name) throws CannotCreateFileException {
        assert (!this.isClosed());
        try {
            return this.loadVDir(parent, name);
        }
        catch (NotDirectoryException e) {
            throw new CannotCreateFileException(this.getVDirLocation(parent, name), (Throwable)e);
        }
    }

    @Override
    @Nonnull
    synchronized CaseInsensitiveVFile createVFile(@Nonnull CaseInsensitiveVDir parent, @Nonnull String name) throws CannotCreateFileException {
        assert (!this.isClosed());
        try {
            CaseInsensitiveVFile vFile = this.getVFileFromCache(parent, name);
            if (vFile != null) {
                return vFile;
            }
            CaseInsensitiveVFile original = new CaseInsensitiveVFile(this, (VDir)parent, name);
            BaseVFile encoded = ((BaseVDir)this.vfs.getRootDir()).createVFile(this.encode(original.getPath()));
            original.setEncodedFile(encoded);
            parent.putInCache(name, original);
            return original;
        }
        catch (NotFileException e) {
            throw new CannotCreateFileException(this.getVFileLocation(parent, name), (Throwable)e);
        }
    }

    @Nonnull
    synchronized CaseInsensitiveVDir loadVDir(@Nonnull CaseInsensitiveVDir parent, @Nonnull String name) throws NotDirectoryException {
        assert (!this.isClosed());
        CaseInsensitiveVDir vDir = this.getVDirFromCache(parent, name);
        if (vDir != null) {
            return vDir;
        }
        CaseInsensitiveVDir dir = new CaseInsensitiveVDir(this, parent, name);
        parent.putInCache(name, dir);
        return dir;
    }

    @Nonnull
    synchronized CaseInsensitiveVFile loadVFile(@Nonnull CaseInsensitiveVDir parent, @Nonnull String name) throws NotFileException {
        assert (!this.isClosed());
        CaseInsensitiveVFile vFile = this.getVFileFromCache(parent, name);
        if (vFile != null) {
            return vFile;
        }
        CaseInsensitiveVFile original = new CaseInsensitiveVFile(this, (VDir)parent, name);
        parent.putInCache(name, original);
        return original;
    }

    @Override
    @Nonnull
    void delete(@Nonnull CaseInsensitiveVFile file) throws CannotDeleteFileException {
        assert (!this.isClosed());
        try {
            BaseVFile encoded = ((BaseVDir)this.vfs.getRootDir()).getVFile(this.encode(file.getPath()));
            this.vfs.delete(encoded);
            file.deleteFromCache();
        }
        catch (NotDirectoryException e) {
            throw new CannotDeleteFileException(file);
        }
        catch (NotFileException e) {
            throw new CannotDeleteFileException(file);
        }
        catch (NoSuchFileException e) {
            throw new CannotDeleteFileException(file);
        }
    }

    @Override
    @Nonnull
    Collection<? extends BaseVElement> list(@Nonnull CaseInsensitiveVDir dir) {
        return dir.getAllFromCache();
    }

    @Override
    boolean isEmpty(@Nonnull CaseInsensitiveVDir dir) {
        return dir.isEmpty();
    }

    @Override
    @Nonnull
    public FileTime getLastModified(@Nonnull CaseInsensitiveVFile file) throws CannotGetModificationTimeException {
        return this.vfs.getLastModified(this.loadAndGetEncodedFile(file));
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull CaseInsensitiveVFile file) {
        return this.vfs.getVFileLocation(this.loadAndGetEncodedFile(file));
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull CaseInsensitiveVDir parent, @Nonnull String name) {
        return ((BaseVDir)this.vfs.getRootDir()).getVFileLocation(this.encode(parent.getPath().clone().appendPath(new VPath(name, '/'))));
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull CaseInsensitiveVDir dir) {
        return ((BaseVDir)this.vfs.getRootDir()).getVDirLocation(this.encode(dir.getPath()));
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull CaseInsensitiveVDir parent, @Nonnull String name) {
        return ((BaseVDir)this.vfs.getRootDir()).getVDirLocation(this.encode(parent.getPath().clone().appendPath(new VPath(name, '/'))));
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull CaseInsensitiveVDir parent, @Nonnull VPath path) {
        return ((BaseVDir)this.vfs.getRootDir()).getVFileLocation(this.encode(parent.getPath().clone().appendPath(path)));
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull CaseInsensitiveVDir parent, @Nonnull VPath path) {
        return ((BaseVDir)this.vfs.getRootDir()).getVDirLocation(this.encode(parent.getPath().clone().appendPath(path)));
    }

    @Override
    public boolean needsSequentialWriting() {
        return this.vfs.needsSequentialWriting();
    }

    @Nonnull
    private VPath encode(@Nonnull VPath path) {
        char[] digest = CaseInsensitiveFS.encode(this.mdf.create().digest(path.getPathAsString('/').getBytes()));
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        try {
            for (int groupIdx = 0; groupIdx < this.numGroups; ++groupIdx) {
                for (int letterIdx = 0; letterIdx < this.groupSize; ++letterIdx) {
                    sb.append(digest[idx++]);
                }
                sb.append('/');
            }
            if (idx < digest.length) {
                sb.append(digest, idx, digest.length - idx);
            } else {
                sb.setLength(sb.length() - 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return new VPath(sb.toString(), '/');
    }

    @Nonnull
    static char[] encode(@Nonnull byte[] bytes) {
        char[] array = new char[bytes.length * 2];
        for (int idx = 0; idx < bytes.length; ++idx) {
            array[idx << 1] = (char)code[(bytes[idx] & 0xF0) >> 4];
            array[(idx << 1) + 1] = (char)code[bytes[idx] & 0xF];
        }
        return array;
    }

    @Override
    @Nonnull
    VPath getPathFromDir(@Nonnull CaseInsensitiveVDir parent, @Nonnull CaseInsensitiveVFile file) {
        StringBuilder path = this.getPathFromDirInternal(parent, (CaseInsensitiveVDir)file.getParent()).append(file.getName());
        return new VPath(path.toString(), '/');
    }

    @Nonnull
    private StringBuilder getPathFromDirInternal(@Nonnull CaseInsensitiveVDir baseDir, @Nonnull CaseInsensitiveVDir currentDir) {
        if (baseDir == currentDir) {
            return new StringBuilder();
        }
        CaseInsensitiveVDir currentParent = (CaseInsensitiveVDir)currentDir.getParent();
        assert (currentParent != null);
        return this.getPathFromDirInternal(baseDir, currentParent).append(currentDir.getName()).append('/');
    }

    @Override
    @Nonnull
    VPath getPathFromRoot(@Nonnull CaseInsensitiveVFile file) {
        return this.getPathFromDir(this.root, file);
    }

    @Override
    @Nonnull
    public StreamFileStatus getStatus() {
        if (!this.used) {
            return StreamFileStatus.NOT_USED;
        }
        if (this.closed) {
            return StreamFileStatus.CLOSED;
        }
        return StreamFileStatus.OPEN;
    }

    @Override
    @CheckForNull
    public String getInfoString() {
        return this.vfs.getInfoString();
    }

    public String toString() {
        return "ciFS >> " + this.vfs.toString();
    }

    static class CaseInsensitiveVFile
    extends ParentVFile {
        @CheckForNull
        private BaseVFile encodedFile;

        CaseInsensitiveVFile(@Nonnull BaseVFS<? extends InMemoryVDir, ? extends CaseInsensitiveVFile> vfs, @Nonnull VDir parent, @Nonnull String name) {
            super(vfs, parent, name);
        }

        private void setEncodedFile(@Nonnull BaseVFile encodedFile) {
            this.encodedFile = encodedFile;
        }

        @CheckForNull
        private BaseVFile getEncodedFile() {
            return this.encodedFile;
        }

        @Override
        public void delete() throws CannotDeleteFileException {
            this.vfs.delete(this);
        }

        private void deleteFromCache() {
            ((InMemoryVDir)this.parent).internalDelete(this.name);
        }
    }

    static class CaseInsensitiveVDir
    extends InMemoryVDir {
        @CheckForNull
        protected final VDir parent;

        CaseInsensitiveVDir(@Nonnull BaseVFS<? extends InMemoryVDir, ? extends CaseInsensitiveVFile> vfs, @CheckForNull VDir parent, @Nonnull String name) {
            super((BaseVFS<? extends InMemoryVDir, ? extends BaseVFile>)vfs, name);
            this.parent = parent;
        }

        @Override
        @Nonnull
        public VPath getPath() {
            if (this.parent != null) {
                return this.parent.getPath().clone().appendPath(new VPath(this.name, '/'));
            }
            return VPath.ROOT;
        }

        @Override
        @Nonnull
        public BaseVFile getVFile(@Nonnull String name) throws NoSuchFileException, NotFileException {
            return this.vfs.getVFile(this, name);
        }

        @Override
        @Nonnull
        public BaseVDir getVDir(@Nonnull String name) throws NotDirectoryException, NoSuchFileException {
            return this.vfs.getVDir(this, name);
        }

        @Override
        @Nonnull
        public BaseVFile createVFile(@Nonnull String name) throws CannotCreateFileException {
            return this.vfs.createVFile(this, name);
        }

        @Override
        @Nonnull
        public BaseVDir createVDir(@Nonnull String name) throws CannotCreateFileException {
            return this.vfs.createVDir(this, name);
        }

        @Override
        @Nonnull
        public Collection<? extends BaseVElement> list() {
            return this.vfs.list(this);
        }

        @CheckForNull
        public VDir getParent() {
            return this.parent;
        }
    }
}

