/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.stream.LocationByteStreamSucker;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VFSStatCategory;
import com.android.sched.vfs.VFile;
import com.android.sched.vfs.VPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.Collection;

abstract class BaseVFS<DIR extends BaseVDir, FILE extends BaseVFile>
implements VFS {
    @CheckForNull
    private Tracer tracer;
    protected boolean closed = false;

    BaseVFS() {
    }

    @Nonnull
    public abstract DIR getRootDir();

    @Nonnull
    abstract InputStream openRead(@Nonnull FILE var1) throws WrongPermissionException;

    @Nonnull
    abstract OutputStream openWrite(@Nonnull FILE var1) throws WrongPermissionException;

    @Nonnull
    abstract OutputStream openWrite(@Nonnull FILE var1, boolean var2) throws WrongPermissionException;

    @Nonnull
    abstract DIR getVDir(@Nonnull DIR var1, @Nonnull String var2) throws NotDirectoryException, NoSuchFileException;

    @Nonnull
    abstract FILE getVFile(@Nonnull DIR var1, @Nonnull String var2) throws NotFileException, NoSuchFileException;

    @Nonnull
    abstract DIR createVDir(@Nonnull DIR var1, @Nonnull String var2) throws CannotCreateFileException;

    @Nonnull
    abstract FILE createVFile(@Nonnull DIR var1, @Nonnull String var2) throws CannotCreateFileException;

    @Nonnull
    abstract void delete(@Nonnull FILE var1) throws CannotDeleteFileException;

    @Nonnull
    abstract Collection<? extends BaseVElement> list(@Nonnull DIR var1);

    abstract boolean isEmpty(@Nonnull DIR var1);

    @Nonnull
    abstract VPath getPathFromDir(@Nonnull DIR var1, @Nonnull FILE var2);

    @Nonnull
    abstract VPath getPathFromRoot(@Nonnull FILE var1);

    @Nonnull
    abstract FileTime getLastModified(@Nonnull FILE var1) throws CannotGetModificationTimeException;

    @Nonnull
    abstract Location getVFileLocation(@Nonnull FILE var1);

    @Nonnull
    abstract Location getVFileLocation(@Nonnull DIR var1, @Nonnull String var2);

    @Nonnull
    abstract Location getVFileLocation(@Nonnull DIR var1, @Nonnull VPath var2);

    @Nonnull
    abstract Location getVDirLocation(@Nonnull DIR var1);

    @Nonnull
    abstract Location getVDirLocation(@Nonnull DIR var1, @Nonnull String var2);

    @Nonnull
    abstract Location getVDirLocation(@Nonnull DIR var1, @Nonnull VPath var2);

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    @CheckForNull
    public String getDigest() {
        return null;
    }

    public void copy(@Nonnull VFile srcFile, @Nonnull FILE dstFile) throws WrongPermissionException, CannotCloseException, CannotReadException, CannotWriteException {
        try (InputStream is = srcFile.getInputStream();){
            try (OutputStream os = ((BaseVFile)dstFile).getOutputStream();){
                new LocationByteStreamSucker(is, os, srcFile, (HasLocation)dstFile).suck();
            }
            catch (IOException e) {
                throw new CannotCloseException((HasLocation)dstFile, (Exception)e);
            }
        }
        catch (IOException e) {
            throw new CannotCloseException((HasLocation)srcFile, (Exception)e);
        }
        VFSStatCategory.OPTIMIZED_COPIES.getPercentStat(this.getTracer(), this.getInfoString()).addFalse();
    }

    @CheckForNull
    protected Tracer getTracer() {
        if (this.tracer == null) {
            try {
                this.tracer = TracerFactory.getTracer();
            }
            catch (ConfigurationError configurationError) {
                // empty catch block
            }
        }
        return this.tracer;
    }
}

