/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.probe;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.ImplementationFilter;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.tracer.probe.Probe;
import com.android.sched.util.log.tracer.probe.TimeNanosProbe;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

@ImplementationName(iface=Probe.class, name="thread-cpu-time", filter=Filter.class)
public class ThreadTimeProbe
extends TimeNanosProbe {
    @Nonnull
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public ThreadTimeProbe() {
        super("Per Thread CPU time", 1);
        this.threadMXBean.setThreadCpuTimeEnabled(true);
    }

    @Override
    @Nonnegative
    public long read() {
        return this.threadMXBean.getCurrentThreadCpuTime();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    static class Filter
    implements ImplementationFilter {
        Filter() {
        }

        @Override
        public boolean isValid() {
            try {
                ThreadMXBean threadManager = ManagementFactory.getThreadMXBean();
                return threadManager.isCurrentThreadCpuTimeSupported();
            }
            catch (Throwable e) {
                return false;
            }
        }
    }
}

